/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.ldap;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.security.auth.callback.CallbackHandler;
import org.openthinclient.ldap.DirectoryFacade;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPConnectionDescriptor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ProviderType providerType = ProviderType.SUN;
    private ConnectionMethod connectionMethod;
    private AuthenticationMethod authenticationMethod;
    private String hostname;
    private short portNumber;
    private String baseDN = "";
    private CallbackHandler callbackHandler;
    private Hashtable<String, Object> extraEnv = new Hashtable();
    private final String referralPreference = "follow";
    private boolean readOnly;

    public LDAPConnectionDescriptor() {
        this.connectionMethod = ConnectionMethod.PLAIN;
        this.authenticationMethod = AuthenticationMethod.NONE;
        this.hostname = "localhost";
        this.portNumber = (short)-1;
        this.baseDN = "";
    }

    public LDAPConnectionDescriptor(LDAPConnectionDescriptor lcd) {
        this.providerType = lcd.providerType;
        this.connectionMethod = lcd.connectionMethod;
        this.authenticationMethod = lcd.authenticationMethod;
        this.hostname = lcd.hostname;
        this.portNumber = lcd.portNumber;
        this.baseDN = lcd.baseDN;
        this.callbackHandler = lcd.callbackHandler;
        this.extraEnv.putAll(lcd.extraEnv);
        this.readOnly = lcd.readOnly;
    }

    public String getLDAPUrl() {
        switch (this.providerType) {
            default: {
                try {
                    if (null == this.hostname) {
                        this.hostname = "localhost";
                    }
                    return new URI(this.connectionMethod != ConnectionMethod.SSL ? "ldap" : "ldaps", null, this.hostname, this.getPortNumber(), "/" + this.baseDN, null, null).toString();
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException("Got exception trying to build a URI", e);
                }
            }
            case APACHE_DS_EMBEDDED: 
        }
        return this.baseDN;
    }

    public int hashCode() {
        try {
            Hashtable<String, Object> env = this.extraEnv;
            int hashCode = 0;
            Enumeration<String> i = env.keys();
            while (i.hasMoreElements()) {
                String key = i.nextElement();
                hashCode = null != key ? (hashCode ^= key.hashCode()) : (hashCode ^= 0x5DE00A2);
                if (null != env.get(key)) {
                    hashCode ^= env.get(key).hashCode();
                    continue;
                }
                hashCode ^= 0x14DCE9D;
            }
            return hashCode ^ this.portNumber ^ this.hostname.hashCode() ^ this.callbackHandler.hashCode() ^ this.connectionMethod.hashCode() ^ this.authenticationMethod.hashCode();
        }
        catch (Exception e) {
            return -9999;
        }
    }

    public void setAuthenticationMethod(AuthenticationMethod authenticationMethod) {
        this.authenticationMethod = authenticationMethod;
    }

    public AuthenticationMethod getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    public void setBaseDN(String baseDN) {
        this.baseDN = baseDN;
    }

    public String getBaseDN() {
        return this.baseDN;
    }

    public void setCallbackHandler(CallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    public CallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    public void setConnectionMethod(ConnectionMethod connectionMethod) {
        this.connectionMethod = connectionMethod;
    }

    public ConnectionMethod getConnectionMethod() {
        return this.connectionMethod;
    }

    public void setExtraEnv(Hashtable<String, Object> extraEnv) {
        this.extraEnv = extraEnv;
    }

    public Hashtable<String, Object> getExtraEnv() {
        return this.extraEnv;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setPortNumber(short portNumber) {
        this.portNumber = portNumber;
    }

    public short getPortNumber() {
        if (this.portNumber > 0) {
            return this.portNumber;
        }
        if (this.connectionMethod == ConnectionMethod.SSL) {
            return 10636;
        }
        return 10389;
    }

    public boolean isBaseDnSet() {
        return this.getBaseDN() != null && this.getBaseDN().length() > 0;
    }

    public ProviderType getProviderType() {
        return this.providerType;
    }

    public void setProviderType(ProviderType providerType) {
        this.providerType = providerType;
    }

    public String getReferralPreference() {
        return "follow";
    }

    public DirectoryFacade createDirectoryFacade() {
        return new DirectoryFacade(this);
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DirectoryType {
        MS_2003R2(true),
        MS_SFU(true),
        OPEN_LDAP(false),
        APACHE_DS(false),
        GENERIC_RFC(false);

        private final boolean upperCaseRDNAttributeNames;

        private DirectoryType(boolean upperCaseRDNAttributeNames) {
            this.upperCaseRDNAttributeNames = upperCaseRDNAttributeNames;
        }

        public boolean requiresUpperCaseRDNAttributeNames() {
            return this.upperCaseRDNAttributeNames;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AuthenticationMethod {
        NONE,
        SIMPLE,
        SASL;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ConnectionMethod {
        PLAIN,
        SSL,
        START_TLS;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ProviderType {
        SUN("com.sun.jndi.ldap.LdapCtxFactory"),
        APACHE_DS_EMBEDDED("org.apache.directory.server.jndi.ServerContextFactory");

        private final String className;

        private ProviderType(String className) {
            this.className = className;
        }

        public String getClassName() {
            return this.className;
        }
    }
}

