/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.ldap;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.directory.AttributeInUseException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import org.apache.log4j.Logger;
import org.openthinclient.ldap.AttributeMapping;
import org.openthinclient.ldap.DirectoryException;
import org.openthinclient.ldap.DiropLogger;
import org.openthinclient.ldap.Filter;
import org.openthinclient.ldap.GroupMapping;
import org.openthinclient.ldap.Transaction;
import org.openthinclient.ldap.TypeMapping;

public class ManyToManyMapping
extends AttributeMapping {
    private static final Logger logger = Logger.getLogger(ManyToManyMapping.class);
    private String filter;
    private String memberField;
    private final Class peerType;
    private GroupMapping peerMapping;

    public ManyToManyMapping(String fieldName, String fieldType) throws ClassNotFoundException {
        super(fieldName, Set.class.getName());
        this.peerType = Class.forName(fieldType);
        if (!Object.class.isAssignableFrom(this.peerType)) {
            throw new IllegalArgumentException("The field " + fieldName + " is not a subclass of Object");
        }
    }

    protected Object valueFromAttributes(Attributes attributes, final Object o, Transaction tx) throws NamingException, DirectoryException {
        return Proxy.newProxyInstance(o.getClass().getClassLoader(), new Class[]{Set.class}, new InvocationHandler(){
            private Set realObjectSet;

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (null == this.realObjectSet) {
                    String dn = ManyToManyMapping.this.type.getDN(o);
                    DiropLogger.LOG.logReadComment("LAZY LOAD: {0} containing {1}", ManyToManyMapping.this.peerType.getSimpleName(), dn);
                    this.realObjectSet = ManyToManyMapping.this.loadObjectSet(dn);
                    ManyToManyMapping.this.setValue(o, this.realObjectSet);
                }
                return method.invoke((Object)this.realObjectSet, args);
            }
        });
    }

    private Set loadObjectSet(String referencedDN) throws DirectoryException {
        Transaction tx = new Transaction(this.type.getMapping());
        try {
            referencedDN = this.peerMapping.getDirectoryFacade().fixNameCase(referencedDN);
            Set set = this.wrapValueSet(this.peerMapping.list(null != this.filter ? new Filter(this.filter, referencedDN) : null, null, null, tx));
            return set;
        }
        catch (NamingException e) {
            throw new DirectoryException("Can't fix DN case for " + this.peerMapping);
        }
        finally {
            tx.commit();
        }
    }

    public Object dehydrate(Object o, BasicAttributes a) throws DirectoryException {
        return null;
    }

    protected void cascadePostSave(Object o, Transaction tx, DirContext ctx) throws DirectoryException {
        try {
            Set existing;
            Set newAssociations = (Set)this.getValue(o);
            if (null == newAssociations) {
                return;
            }
            if (null != newAssociations) {
                if (Proxy.isProxyClass(newAssociations.getClass())) {
                    return;
                }
                for (Object peer : newAssociations) {
                    this.peerMapping.save(peer, null, tx);
                }
            }
            String dn = this.peerMapping.getDirectoryFacade().fixNameCase(this.type.getDN(o));
            Transaction nested = new Transaction(tx);
            try {
                existing = this.peerMapping.list(null != this.filter ? new Filter(this.filter, dn) : null, null, null, nested);
            }
            catch (DirectoryException e) {
                nested.rollback();
                throw e;
            }
            catch (RuntimeException e) {
                nested.rollback();
                throw e;
            }
            finally {
                nested.commit();
            }
            LinkedList missing = new LinkedList();
            if (null != newAssociations) {
                missing.addAll(newAssociations);
            }
            Iterator i = missing.iterator();
            while (i.hasNext()) {
                if (!existing.remove(i.next())) continue;
                i.remove();
            }
            for (Object group : existing) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Remove: " + group));
                }
                this.peerMapping.removeMember(group, this.memberField, dn, tx);
            }
            i = missing.iterator();
            while (i.hasNext()) {
                try {
                    Object group;
                    group = i.next();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Save: " + group));
                    }
                    if (!this.peerMapping.isInDirectory(group, this.memberField, dn, tx)) {
                        this.peerMapping.addMember(group, this.memberField, dn, tx);
                        continue;
                    }
                    logger.error((Object)"Object already exists !!!");
                }
                catch (AttributeInUseException a) {
                    logger.error((Object)"Object already exists !!!", (Throwable)a);
                }
            }
        }
        catch (DirectoryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DirectoryException("Can't update many-to-many association", e);
        }
    }

    protected boolean checkNull(Attributes a) {
        return false;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    protected void initNewInstance(Object instance) throws DirectoryException {
        this.setValue(instance, this.wrapValueSet(new HashSet()));
    }

    private Set wrapValueSet(Set s) {
        return s;
    }

    public void setMemberField(String memberField) {
        this.memberField = memberField;
    }

    protected void initPostLoad() {
        super.initPostLoad();
        TypeMapping peer = this.type.getMapping().getMapping(this.peerType);
        if (null == peer) {
            throw new IllegalStateException(this + ": no mapping for peer type " + this.peerType);
        }
        if (!(peer instanceof GroupMapping)) {
            throw new IllegalStateException("many-to-many-mapping " + this + " needs a group as a partner, not a " + peer);
        }
        this.peerMapping = (GroupMapping)peer;
        peer.addReferrer(this);
    }
}

