/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.ldap;

import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.apache.log4j.Logger;
import org.openthinclient.ldap.Cardinality;
import org.openthinclient.ldap.DirectoryException;
import org.openthinclient.ldap.ReferenceAttributeMapping;
import org.openthinclient.ldap.Transaction;
import org.openthinclient.ldap.TypeMapping;

public class ManyToOneMapping
extends ReferenceAttributeMapping {
    private static final Logger logger = Logger.getLogger(ManyToOneMapping.class);
    private final Class refereeType;
    private TypeMapping refereeMapping;

    public ManyToOneMapping(String fieldName, String fieldType) throws ClassNotFoundException {
        super(fieldName, fieldType);
        this.refereeType = Class.forName(fieldType);
        if (!Object.class.isAssignableFrom(this.refereeType)) {
            throw new IllegalArgumentException("The field " + fieldName + " is not a subclass of Object");
        }
    }

    protected Object valueFromAttributes(Attributes attributes, Object o, Transaction tx) throws NamingException, DirectoryException {
        Attribute attribute = attributes.get(this.fieldName);
        if (null != attribute) {
            String dn = attribute.get().toString();
            try {
                return this.type.getMapping().getMapping(this.getFieldType(), dn).load(dn, tx);
            }
            catch (NameNotFoundException e) {
                logger.warn((Object)("Referenced object for many-to-one mapping not found: " + dn));
            }
        }
        return null;
    }

    protected void initPostLoad() {
        super.initPostLoad();
        TypeMapping child = this.type.getMapping().getMapping(this.refereeType);
        if (null == child) {
            throw new IllegalStateException(this + ": no mapping for peer type " + this.refereeType);
        }
        this.refereeMapping = child;
        child.addReferrer(this);
    }

    protected Object getValue(Object o) throws DirectoryException {
        Object referenced = super.getValue(o);
        if (null == referenced) {
            return null;
        }
        return this.refereeMapping.getDN(referenced);
    }

    protected void cascadePreSave(Object o, Transaction tx) throws DirectoryException {
        super.cascadePreSave(o, tx);
        Object referenced = super.getValue(o);
        if (null != referenced) {
            this.refereeMapping.save(referenced, null, tx);
        }
    }

    Cardinality getCardinality() {
        return Cardinality.ZERO_OR_ONE;
    }
}

