/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.ldap;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.log4j.Logger;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.openthinclient.ldap.Cardinality;
import org.openthinclient.ldap.DirectoryException;
import org.openthinclient.ldap.DirectoryFacade;
import org.openthinclient.ldap.DiropLogger;
import org.openthinclient.ldap.EhCacheSecondLevelCache;
import org.openthinclient.ldap.Filter;
import org.openthinclient.ldap.LDAPConnectionDescriptor;
import org.openthinclient.ldap.ReferenceAttributeMapping;
import org.openthinclient.ldap.SecondLevelCache;
import org.openthinclient.ldap.Transaction;
import org.openthinclient.ldap.TypeMapping;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mapping {
    public static boolean disableCache = false;
    private static final Logger logger = Logger.getLogger(Mapping.class);
    public static final String PROPERTY_FORCE_SINGLE_THREADED = "ldap.mapping.single-treaded";
    private final Map<Class, TypeMapping> defaultMappers = new HashMap<Class, TypeMapping>();
    private boolean initialized;
    private final Set<TypeMapping> mappers = new HashSet<TypeMapping>();
    private final Map<DirectoryFacade, Set<TypeMapping>> mappersByDirectory = new HashMap<DirectoryFacade, Set<TypeMapping>>();
    private final Map<Class, Set<TypeMapping>> mappersByType = new HashMap<Class, Set<TypeMapping>>();
    private String name;
    private final SecondLevelCache secondLevelCache = new EhCacheSecondLevelCache();

    public static Mapping load(InputStream is) throws IOException, MappingException, ValidationException, MarshalException {
        InputStreamReader reader = new InputStreamReader(is);
        org.exolab.castor.mapping.Mapping m = new org.exolab.castor.mapping.Mapping();
        m.loadMapping(new InputSource(Mapping.class.getResourceAsStream("ldap-mapping.xml")));
        Unmarshaller unmarshaller = new Unmarshaller(m);
        Mapping loadedMapping = (Mapping)unmarshaller.unmarshal((Reader)reader);
        return loadedMapping;
    }

    public Mapping() {
    }

    public Mapping(Mapping m) {
        this();
        for (TypeMapping tm : m.mappers) {
            try {
                this.add(tm.clone());
            }
            catch (CloneNotSupportedException e1) {
                throw new RuntimeException(e1);
            }
        }
        this.initialize();
    }

    public void add(TypeMapping typeMapping) {
        if (this.mappers.contains(typeMapping)) {
            throw new IllegalArgumentException("The specified TypeMapping already contained in this mapping");
        }
        typeMapping.setMapping(this);
        this.mappers.add(typeMapping);
        this.defaultMappers.put(typeMapping.getMappedType(), typeMapping);
        Set<TypeMapping> mappersForClass = this.mappersByType.get(typeMapping.getMappedType());
        if (null == mappersForClass) {
            mappersForClass = new HashSet<TypeMapping>();
            this.mappersByType.put(typeMapping.getMappedType(), mappersForClass);
        }
        mappersForClass.add(typeMapping);
        DirectoryFacade lcd = typeMapping.getDirectoryFacade();
        if (null != lcd) {
            Set<TypeMapping> mappersForConnection = this.mappersByDirectory.get(lcd);
            if (null == mappersForConnection) {
                mappersForConnection = new HashSet<TypeMapping>();
                this.mappersByDirectory.put(lcd, mappersForConnection);
            }
            mappersForConnection.add(typeMapping);
        }
    }

    public void close() {
        try {
            if (null != this.secondLevelCache) {
                this.secondLevelCache.clear();
            }
        }
        catch (Exception e) {
            logger.error((Object)"Can't purge cache", (Throwable)e);
        }
    }

    public <T> T create(Class<T> type) throws DirectoryException {
        TypeMapping tm;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("create(): create=" + type));
        }
        if (null == (tm = this.defaultMappers.get(type))) {
            throw new IllegalArgumentException("No mapping for class " + type);
        }
        return (T)tm.create();
    }

    public boolean delete(Object object) throws DirectoryException {
        TypeMapping tm;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("delete(): type=" + object.getClass()));
        }
        if (null == (tm = this.defaultMappers.get(object.getClass()))) {
            throw new IllegalArgumentException("No mapping for class " + object.getClass());
        }
        Transaction tx = new Transaction(this);
        try {
            boolean bl = tm.delete(object, tx);
            return bl;
        }
        catch (DirectoryException e) {
            tx.rollback();
            throw e;
        }
        catch (RuntimeException e) {
            tx.rollback();
            throw e;
        }
        finally {
            if (!tx.isClosed()) {
                tx.commit();
            }
        }
    }

    Set<TypeMapping> getMappers() {
        return this.mappers;
    }

    TypeMapping getMapping(Class c) {
        return this.defaultMappers.get(c);
    }

    TypeMapping getMapping(Class type, DirectoryFacade connectionDescriptor) {
        Set<TypeMapping> mappers = this.mappersByDirectory.get(connectionDescriptor);
        for (TypeMapping tm : mappers) {
            if (!tm.getMappedType().equals(type)) continue;
            return tm;
        }
        throw new IllegalArgumentException("No mapping for the specified type and connection descriptor");
    }

    TypeMapping getMapping(Class type, String baseDN) throws NamingException {
        if (null == baseDN) {
            return this.defaultMappers.get(type);
        }
        Set<TypeMapping> mappersForClass = this.mappersByType.get(type);
        for (TypeMapping tm : mappersForClass) {
            if (!tm.getDirectoryFacade().contains(tm.getDirectoryFacade().getNameParser().parse(baseDN))) continue;
            return tm;
        }
        return this.defaultMappers.get(type);
    }

    TypeMapping getMapping(String dn, Transaction tx) throws DirectoryException, NamingException {
        for (Map.Entry<DirectoryFacade, Set<TypeMapping>> e : this.mappersByDirectory.entrySet()) {
            Set<TypeMapping> mappings;
            Name parsedDN;
            DirectoryFacade df = e.getKey();
            if (!df.contains(parsedDN = df.getNameParser().parse(dn))) continue;
            DirContext ctx = tx.getContext(df);
            String[] attributes = new String[]{"objectClass"};
            DiropLogger.LOG.logGetAttributes(dn, attributes, "determining mapping");
            Attributes a = ctx.getAttributes(df.makeRelativeName(dn), attributes);
            Attribute objectClasses = a.get("objectClass");
            TypeMapping match = this.getMapping(parsedDN, objectClasses, mappings = e.getValue());
            if (null == match) continue;
            return match;
        }
        return null;
    }

    private TypeMapping getMapping(Name parsedDN, Attribute objectClasses, Set<TypeMapping> mappings) throws NamingException, InvalidNameException {
        ArrayList<TypeMapping> candidates = new ArrayList<TypeMapping>();
        for (TypeMapping tm : mappings) {
            if (!tm.matchesKeyClasses(objectClasses)) continue;
            candidates.add(tm);
        }
        if (candidates.size() == 1) {
            return (TypeMapping)candidates.get(0);
        }
        for (TypeMapping tm : candidates) {
            if (tm.getBaseRDN() == null || !parsedDN.startsWith(tm.getDefaultBaseName())) continue;
            return tm;
        }
        if (candidates.size() > 0) {
            return (TypeMapping)candidates.get(0);
        }
        return null;
    }

    public Map<Class, TypeMapping> getTypes() {
        return Collections.unmodifiableMap(this.defaultMappers);
    }

    public void initialize() {
        if (this.initialized) {
            return;
        }
        for (TypeMapping m : this.defaultMappers.values()) {
            m.initPostLoad();
        }
        this.initialized = true;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"LDAP mapping initialized");
        }
    }

    public <T> Set<T> list(Class<T> type) throws DirectoryException {
        if (!this.initialized) {
            throw new DirectoryException("Mapping is not yet initialized - call initialize() first");
        }
        return this.list(type, null, null, null);
    }

    public <T> Set<T> list(Class<T> type, Filter filter, String baseDN, TypeMapping.SearchScope scope) throws DirectoryException {
        TypeMapping tm;
        if (!this.initialized) {
            throw new DirectoryException("Mapping is not yet initialized - call initialize() first");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("list(): type=" + type + ", filter=" + filter + ", searchBase=" + baseDN));
        }
        try {
            tm = this.getMapping(type, baseDN);
        }
        catch (NamingException e) {
            throw new DirectoryException("Can't determine TypeMapping for this type and search base", e);
        }
        if (null == tm) {
            tm = this.defaultMappers.get(type);
        }
        if (null == tm) {
            throw new IllegalArgumentException("No mapping for class " + type);
        }
        Transaction tx = new Transaction(this);
        try {
            Set set = tm.list(filter, baseDN, scope, tx);
            return set;
        }
        catch (DirectoryException e) {
            tx.rollback();
            throw e;
        }
        catch (RuntimeException e) {
            tx.rollback();
            throw e;
        }
        finally {
            if (!tx.isClosed()) {
                tx.commit();
            }
        }
    }

    public <T> T load(Class<T> type, String dn) throws DirectoryException {
        return this.load(type, dn, false);
    }

    public <T> T load(Class<T> type, String dn, boolean noCache) throws DirectoryException {
        TypeMapping tm;
        if (!this.initialized) {
            throw new DirectoryException("Mapping is not yet initialized - call initialize() first");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("load(): type=" + type + ", dn=" + dn));
        }
        try {
            tm = this.getMapping(type, dn);
        }
        catch (NamingException e) {
            throw new DirectoryException("Can't determine TypeMapping for this type and DN", e);
        }
        if (null == tm) {
            throw new IllegalArgumentException("No mapping for class " + type);
        }
        Transaction tx = new Transaction(this, noCache);
        try {
            Object object = tm.load(dn, tx);
            return (T)object;
        }
        catch (DirectoryException e) {
            tx.rollback();
            throw e;
        }
        catch (RuntimeException e) {
            tx.rollback();
            throw e;
        }
        finally {
            if (!tx.isClosed()) {
                tx.commit();
            }
        }
    }

    public void refresh(Object o) throws DirectoryException {
        TypeMapping tm;
        if (!this.initialized) {
            throw new DirectoryException("Mapping is not yet initialized - call initialize() first");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("refresh(): object=" + o));
        }
        if (null == (tm = this.defaultMappers.get(o.getClass()))) {
            throw new IllegalArgumentException("No mapping for class " + o.getClass());
        }
        Transaction tx = new Transaction(this, true);
        try {
            tm.refresh(o, tx);
        }
        catch (DirectoryException e) {
            tx.rollback();
            throw e;
        }
        catch (RuntimeException e) {
            tx.rollback();
            throw e;
        }
        finally {
            if (!tx.isClosed()) {
                tx.commit();
            }
        }
    }

    public void remove(TypeMapping tm) {
        Set<TypeMapping> forConnection;
        if (!this.mappers.remove(tm)) {
            return;
        }
        this.defaultMappers.remove(tm.getMappedType());
        Set<TypeMapping> forType = this.mappersByType.get(tm.getMappedType());
        if (null != forType) {
            forType.remove(tm);
            if (forType.isEmpty()) {
                this.mappersByType.remove(tm.getMappedType());
            }
        }
        if (null != (forConnection = this.mappersByDirectory.get(tm.getDirectoryFacade()))) {
            forConnection.remove(tm);
            if (forConnection.isEmpty()) {
                this.mappersByDirectory.remove(tm.getDirectoryFacade());
            }
        }
    }

    public void save(Object o) throws DirectoryException {
        this.save(o, null);
    }

    public void save(Object o, String baseDN) throws DirectoryException {
        TypeMapping tm;
        if (!this.initialized) {
            throw new DirectoryException("Mapping is not yet initialized - call initialize() first");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("save(): object=" + o + ", baseDN=" + baseDN));
        }
        if (null == (tm = this.defaultMappers.get(o.getClass()))) {
            throw new IllegalArgumentException("No mapping for class " + o.getClass());
        }
        Transaction tx = new Transaction(this);
        try {
            tm.save(o, baseDN, tx);
        }
        catch (DirectoryException e) {
            tx.rollback();
            throw e;
        }
        catch (RuntimeException e) {
            tx.rollback();
            throw e;
        }
        finally {
            if (!tx.isClosed()) {
                tx.commit();
            }
        }
    }

    public void setConnectionDescriptor(LDAPConnectionDescriptor lcd) {
        this.setDirectoryFacade(lcd.createDirectoryFacade());
    }

    public void setDirectoryFacade(DirectoryFacade lcd) {
        for (TypeMapping tm : new ArrayList<TypeMapping>(this.mappers)) {
            this.remove(tm);
            tm.setDirectoryFacade(lcd);
            this.add(tm);
        }
    }

    void updateReferences(Transaction tx, String oldDN, String newDN) throws DirectoryException, NamingException {
        for (Map.Entry<DirectoryFacade, Set<TypeMapping>> e : this.mappersByDirectory.entrySet()) {
            Set<TypeMapping> mappers = e.getValue();
            DirectoryFacade directory = e.getKey();
            HashSet<ReferenceAttributeMapping> refererAttributes = new HashSet<ReferenceAttributeMapping>();
            for (TypeMapping m : mappers) {
                m.collectRefererAttributes(refererAttributes);
            }
            HashSet<String> attributeNames = new HashSet<String>();
            HashSet<TypeMapping> effectiveMappers = new HashSet<TypeMapping>();
            for (ReferenceAttributeMapping ra : refererAttributes) {
                attributeNames.add(ra.getFieldName());
                effectiveMappers.add(ra.getTypeMapping());
            }
            DirContext ctx = tx.getContext(directory);
            StringBuilder sb = new StringBuilder("(|");
            for (String name : attributeNames) {
                sb.append("(").append(name).append("=").append(oldDN).append(")");
            }
            sb.append(")");
            SearchControls sc = new SearchControls();
            sc.setSearchScope(2);
            sc.setReturningAttributes(new String[refererAttributes.size()]);
            sc.setDerefLinkFlag(false);
            String filter = sb.toString();
            DiropLogger.LOG.logSearch("", filter, null, sc, "searching references");
            NamingEnumeration<SearchResult> ne = ctx.search("", filter, sc);
            while (ne.hasMore()) {
                SearchResult result = ne.next();
                Attributes attributes = result.getAttributes();
                LinkedList<ModificationItem> mods = null;
                TypeMapping m = this.getMapping(directory.makeAbsoluteName(result.getName()), attributes.get("objectClass"), mappers);
                if (null == m) {
                    logger.warn((Object)("Could not determine TypeMapping for referencing object at " + result.getName()));
                    continue;
                }
                for (ReferenceAttributeMapping ra : refererAttributes) {
                    Attribute attr;
                    if (ra.getTypeMapping() != m || (attr = attributes.get(ra.getFieldName())) == null) continue;
                    if (null != newDN && null == mods) {
                        mods = new LinkedList<ModificationItem>();
                        attr.remove(oldDN);
                        attr.add(newDN);
                        mods.add(new ModificationItem(2, attr));
                    }
                    if (null != mods) continue;
                    mods = new LinkedList();
                    attr.remove(oldDN);
                    if (attr.size() == 0 && (ra.getCardinality() == Cardinality.ONE || ra.getCardinality() == Cardinality.ONE_OR_MANY)) {
                        attr.add(directory.getDummyMember());
                    }
                    mods.add(new ModificationItem(2, attr));
                }
                if (null == mods) continue;
                ModificationItem[] modsArray = mods.toArray(new ModificationItem[mods.size()]);
                DiropLogger.LOG.logModify(result.getName(), modsArray, "cascading update due to DN change of referenced object");
                ctx.modifyAttributes(result.getName(), modsArray);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    SecondLevelCache getSecondLevelCache() {
        return this.secondLevelCache;
    }
}

