/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.ldap;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import org.apache.log4j.Logger;
import org.openthinclient.ldap.Cardinality;
import org.openthinclient.ldap.DirectoryException;
import org.openthinclient.ldap.DiropLogger;
import org.openthinclient.ldap.ReferenceAttributeMapping;
import org.openthinclient.ldap.Transaction;
import org.openthinclient.ldap.TypeMapping;

public class OneToManyMapping
extends ReferenceAttributeMapping {
    private static final Logger logger = Logger.getLogger(OneToManyMapping.class);
    private final Class memberType;
    private TypeMapping memberMapping;
    private static final Set EMPTY = Collections.unmodifiableSet(new HashSet());

    public OneToManyMapping(String fieldName, String memberType) throws ClassNotFoundException {
        super(fieldName, Set.class.getName());
        this.memberType = memberType.equals("*") ? Object.class : Class.forName(memberType);
        this.cardinality = Cardinality.ONE_OR_MANY;
    }

    protected Object valueFromAttributes(final Attributes attributes, final Object o, Transaction tx) throws NamingException, DirectoryException {
        return Proxy.newProxyInstance(o.getClass().getClassLoader(), new Class[]{this.getFieldType()}, new InvocationHandler(){
            private Set realMemberSet;

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (null == this.realMemberSet) {
                    if (DiropLogger.LOG.isReadEnabled()) {
                        DiropLogger.LOG.logReadComment("LAZY LOAD: collection for {0}: {1}", OneToManyMapping.this.fieldName, OneToManyMapping.this.type.getDN(o));
                    }
                    this.realMemberSet = OneToManyMapping.this.loadMemberSet(attributes);
                    OneToManyMapping.this.setValue(o, this.realMemberSet);
                }
                return method.invoke((Object)this.realMemberSet, args);
            }
        });
    }

    /*
     * Exception decompiling
     */
    private Set loadMemberSet(Attributes attributes) throws DirectoryException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void cascadePreSave(Object o, Transaction tx) throws DirectoryException {
        super.cascadePreSave(o, tx);
        Set memberSet = (Set)this.getValue(o);
        if (null == memberSet) {
            memberSet = EMPTY;
        }
        if (!Proxy.isProxyClass(memberSet.getClass())) {
            for (Object member : memberSet) {
                TypeMapping mappingForMember = this.getMappingForMember(member);
                String dn = mappingForMember.getDN(member);
                if (null != dn) continue;
                mappingForMember.save(member, null, tx);
            }
        }
    }

    public Object dehydrate(Object o, BasicAttributes a) throws DirectoryException, NamingException {
        Set memberSet = (Set)this.getValue(o);
        if (null == memberSet) {
            memberSet = EMPTY;
        }
        if (!Proxy.isProxyClass(memberSet.getClass())) {
            BasicAttribute memberDNs = new BasicAttribute(this.fieldName);
            if (memberSet.isEmpty()) {
                if (this.cardinality == Cardinality.ONE_OR_MANY) {
                    memberDNs.add(this.type.getDirectoryFacade().getDummyMember());
                }
            } else {
                for (Object member : memberSet) {
                    try {
                        TypeMapping mappingForMember = this.getMappingForMember(member);
                        String memberDN = this.type.getDirectoryFacade().fixNameCase(mappingForMember.getDN(member));
                        memberDNs.add(memberDN);
                    }
                    catch (NamingException e) {
                        throw new DirectoryException("Can't dehydrate", e);
                    }
                }
            }
            if (memberDNs.size() > 0) {
                a.put(memberDNs);
            }
        } else {
            a.put(new BasicAttribute(this.fieldName, TypeMapping.ATTRIBUTE_UNCHANGED_MARKER));
        }
        return memberSet;
    }

    private TypeMapping getMappingForMember(Object member) throws DirectoryException {
        TypeMapping mappingForMember = this.memberMapping;
        if (null == mappingForMember) {
            mappingForMember = this.type.getMapping().getMapping(member.getClass());
        }
        if (null == mappingForMember) {
            throw new DirectoryException("One-to-many associaction contains a member of type " + member.getClass() + " for which I don't have a mapping.");
        }
        String dn = mappingForMember.getDN(member);
        if (null == dn) {
            return mappingForMember;
        }
        try {
            Name parsedDN = mappingForMember.getDirectoryFacade().getNameParser().parse(dn);
            if (!mappingForMember.getDirectoryFacade().contains(parsedDN)) {
                mappingForMember = this.type.getMapping().getMapping(member.getClass(), dn);
                parsedDN = mappingForMember.getDirectoryFacade().getNameParser().parse(dn);
            }
            return mappingForMember;
        }
        catch (NamingException e) {
            throw new DirectoryException("Unable to determine mapping for member", e);
        }
    }

    protected void cascadePostSave(Object o, Transaction tx, DirContext ctx) throws DirectoryException {
        Set memberSet = (Set)this.getValue(o);
        if (null == memberSet) {
            memberSet = EMPTY;
        }
        if (!Proxy.isProxyClass(memberSet.getClass())) {
            for (Object member : memberSet) {
                TypeMapping mm = this.getMappingForMember(member);
                if (null == mm) {
                    throw new DirectoryException(this + ": set contains member of unmapped type: " + member.getClass());
                }
                mm.save(member, null, tx);
            }
        }
    }

    protected boolean checkNull(Attributes a) {
        return false;
    }

    protected void initNewInstance(Object instance) throws DirectoryException {
        this.setValue(instance, EMPTY);
    }

    protected void initPostLoad() {
        super.initPostLoad();
        if (!this.memberType.equals(Object.class)) {
            TypeMapping member = this.type.getMapping().getMapping(this.memberType);
            if (null == member) {
                throw new IllegalStateException(this + ": no mapping for member type " + this.memberType);
            }
            this.memberMapping = member;
            member.addReferrer(this);
        }
    }

    public void setCardinality(String c) {
        super.setCardinality(c);
        if (this.cardinality != Cardinality.MANY && this.cardinality != Cardinality.ONE_OR_MANY) {
            throw new IllegalArgumentException("Illegal cardinality " + (Object)((Object)this.cardinality) + " for " + this.type.getMappedType() + "." + this.fieldName);
        }
    }

    Cardinality getCardinality() {
        return this.cardinality;
    }
}

