/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.ldap;

import java.util.regex.Pattern;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import org.openthinclient.ldap.AttributeMapping;
import org.openthinclient.ldap.DirectoryException;
import org.openthinclient.ldap.Transaction;

public class RDNAttributeMapping
extends AttributeMapping {
    private static final Pattern QUOTE_TO_LDAP = Pattern.compile("[\\\\,=]");
    private static final String QUOTE_REPLACEMENT = "\\\\$0";
    private static final Pattern UNQUOTE_FROM_LDAP = Pattern.compile("\\", 16);

    public RDNAttributeMapping(String fieldName) throws ClassNotFoundException {
        super(fieldName, "java.lang.String");
    }

    protected Object valueToAttributes(BasicAttributes a, Object v) {
        assert (v instanceof String);
        return super.valueToAttributes(a, QUOTE_TO_LDAP.matcher((String)v).replaceAll(QUOTE_REPLACEMENT));
    }

    protected Object valueFromAttributes(Attributes a, Object o, Transaction tx) throws NamingException, DirectoryException {
        Object value = super.valueFromAttributes(a, o, tx);
        if (value instanceof String) {
            return UNQUOTE_FROM_LDAP.matcher((String)value).replaceAll("");
        }
        return value;
    }
}

