/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.ldap;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.PagedResultsControl;
import javax.naming.ldap.PagedResultsResponseControl;
import org.apache.log4j.Logger;
import org.openthinclient.common.directory.LDAPDirectory;
import org.openthinclient.ldap.AttributeMapping;
import org.openthinclient.ldap.DirectoryException;
import org.openthinclient.ldap.DirectoryFacade;
import org.openthinclient.ldap.DiropLogger;
import org.openthinclient.ldap.Filter;
import org.openthinclient.ldap.ManyToManyMapping;
import org.openthinclient.ldap.Mapping;
import org.openthinclient.ldap.ReferenceAttributeMapping;
import org.openthinclient.ldap.Transaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeMapping
implements Cloneable {
    private static final Logger logger = Logger.getLogger(TypeMapping.class);
    protected List<AttributeMapping> attributes = new ArrayList<AttributeMapping>();
    private List<AttributeMapping> referrers = new ArrayList<AttributeMapping>();
    private final String baseRDN;
    protected static final Object ATTRIBUTE_UNCHANGED_MARKER = "dc=6f70656e7468696e636c69656e74";
    private Constructor constructor;
    private Mapping mapping;
    private final Class modelClass;
    private final String keyClass;
    private String[] objectClasses;
    private AttributeMapping dnAttribute;
    private AttributeMapping rdnAttribute;
    private final String searchFilter;
    private final int PAGESIZE = 1000;
    private SearchScope defaultScope = SearchScope.SUBTREE;
    private DirectoryFacade directoryFacade;
    private Name defaultBaseName;

    public TypeMapping(String className, String baseRDN, String searchFilter, String objectClasses, String keyClass) throws ClassNotFoundException {
        this.modelClass = Class.forName(className);
        this.baseRDN = baseRDN;
        this.searchFilter = searchFilter;
        this.objectClasses = null != objectClasses ? objectClasses.split("\\s*,\\s*") : new String[]{};
        this.keyClass = keyClass;
    }

    public void add(AttributeMapping attributeMapping) {
        attributeMapping.setTypeMapping(this);
        this.attributes.add(attributeMapping);
    }

    public Object create() throws DirectoryException {
        try {
            Object instance = this.createInstance();
            this.rdnAttribute.initNewInstance(instance);
            for (AttributeMapping am : this.attributes) {
                am.initNewInstance(instance);
            }
            return instance;
        }
        catch (Exception e) {
            throw new DirectoryException("Can't create instance of " + this.modelClass);
        }
    }

    private Object createInstance() throws Exception {
        Constructor c = this.getConstructor();
        Object newInstance = c.newInstance(new Object[0]);
        return newInstance;
    }

    Object createInstanceFromAttributes(String dn, Attributes a, Transaction tx) throws Exception {
        Object o = this.createInstance();
        this.setDN(dn, o);
        this.hydrateInstance(a, o, tx);
        return o;
    }

    private void hydrateInstance(Attributes a, Object o, Transaction tx) throws DirectoryException {
        this.rdnAttribute.hydrate(o, a, tx);
        Iterator<AttributeMapping> i$ = this.attributes.iterator();
        while (i$.hasNext()) {
            AttributeMapping element;
            AttributeMapping am = element = i$.next();
            am.hydrate(o, a, tx);
        }
    }

    private Object setDN(String dn, Object o) throws DirectoryException {
        return this.dnAttribute.setValue(o, dn);
    }

    public String getBaseRDN() {
        return this.baseRDN;
    }

    private Constructor getConstructor() throws SecurityException, NoSuchMethodException {
        if (null == this.constructor) {
            this.constructor = this.modelClass.getConstructor(new Class[0]);
        }
        return this.constructor;
    }

    public Mapping getMapping() {
        return this.mapping;
    }

    public Class getMappedType() {
        return this.modelClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     */
    public Set list(Filter filter, String searchBase, SearchScope scope, Transaction tx) throws DirectoryException {
        HashSet<Object> hashSet;
        LdapContext ctx = this.directoryFacade.createDirContext();
        try {
            String applicableFilter = this.searchFilter;
            Object[] args = null;
            if (null != filter) {
                String parsedFilter = filter.getExpression(0);
                args = filter.getArgs();
                String parseFilter = ".*(\\{0:(.*)\\}).*";
                while (parsedFilter.matches(".*(\\{0:(.*)\\}).*")) {
                    Pattern getPattern = Pattern.compile(".*(\\{0:(.*)\\}).*");
                    Matcher getPatternMatcher = getPattern.matcher(parsedFilter);
                    getPatternMatcher.find();
                    String patternString = getPatternMatcher.group(2);
                    Pattern pattern = Pattern.compile(patternString);
                    Matcher matcher = pattern.matcher(args[0].toString());
                    matcher.find();
                    parsedFilter = parsedFilter.replace(getPatternMatcher.group(1), matcher.group(1));
                }
                applicableFilter = "(&" + this.searchFilter + parsedFilter + ")";
            }
            if (null == searchBase) {
                String string = searchBase = null != this.baseRDN ? this.baseRDN : "";
            }
            if (searchBase.equals("${basedn}")) {
                searchBase = this.directoryFacade.fixNameCase(this.directoryFacade.getBaseDN());
            }
            Name searchBaseName = this.directoryFacade.makeRelativeName(searchBase);
            Name resultBaseName = this.directoryFacade.makeAbsoluteName(searchBase);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("listing objects of " + this.modelClass + " for base=" + searchBaseName + ", filter=" + filter));
            }
            SearchControls sc = new SearchControls();
            sc.setSearchScope(null != scope ? scope.getScope() : this.defaultScope.getScope());
            HashSet<Object> results = new HashSet<Object>();
            try {
                NamingEnumeration<SearchResult> ne;
                DiropLogger.LOG.logSearch(searchBase, applicableFilter, args, sc, "list objects");
                byte[] cookie = null;
                ctx.setRequestControls(new Control[]{new PagedResultsControl(1000, false)});
                do {
                    ne = ctx.search(searchBaseName, applicableFilter, args, sc);
                    while (ne.hasMore()) {
                        Object instance;
                        SearchResult result = ne.next();
                        Name elementName = this.directoryFacade.getNameParser().parse(result.getNameInNamespace());
                        if (result.isRelative() && !elementName.startsWith(resultBaseName)) {
                            elementName = elementName.addAll(0, resultBaseName);
                        }
                        if (null == (instance = tx.getCacheEntry(elementName))) {
                            Attributes a = result.getAttributes();
                            instance = this.createInstanceFromAttributes(elementName.toString(), a, tx);
                            tx.putCacheEntry(this, elementName, instance, a);
                        }
                        results.add(instance);
                    }
                    Control[] controls = ctx.getResponseControls();
                    if (controls != null) {
                        for (int i = 0; i < controls.length; ++i) {
                            if (!(controls[i] instanceof PagedResultsResponseControl)) continue;
                            PagedResultsResponseControl prrc = (PagedResultsResponseControl)controls[i];
                            cookie = prrc.getCookie();
                        }
                    }
                    ctx.setRequestControls(new Control[]{new PagedResultsControl(1000, cookie, true)});
                } while (cookie != null);
                ne.close();
                for (Object o : results) {
                    for (AttributeMapping am : this.attributes) {
                        am.cascadePostLoad(o, tx);
                    }
                }
            }
            catch (NameNotFoundException e) {
                logger.warn((Object)("NameNotFoundException listing objects of " + this.modelClass + " for base=" + searchBaseName + ". Returning empty set instead."));
            }
            hashSet = results;
        }
        catch (Throwable throwable) {
            try {
                ctx.close();
                throw throwable;
            }
            catch (Exception e) {
                throw new DirectoryException("Can't list objects for type " + this.modelClass, e);
            }
        }
        ctx.close();
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object load(String dn, Transaction tx) throws DirectoryException {
        try {
            if (null == dn) {
                dn = this.baseRDN;
            }
            DirContext ctx = tx.getContext(this.directoryFacade);
            Name targetName = this.directoryFacade.makeAbsoluteName(dn);
            Object cached = tx.getCacheEntry(targetName);
            if (null != cached) {
                return cached;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("loading object of " + this.modelClass + " for dn: " + targetName));
            }
            SearchControls sc = new SearchControls();
            sc.setSearchScope(0);
            Object o = null;
            Name searchName = this.directoryFacade.makeRelativeName(dn);
            DiropLogger.LOG.logSearch(dn, this.searchFilter, null, sc, "loading single object");
            NamingEnumeration<SearchResult> ne = ctx.search(searchName, this.searchFilter, null, sc);
            try {
                if (!ne.hasMore()) {
                    throw new NameNotFoundException("No object for the given dn found.");
                }
                SearchResult result = (SearchResult)ne.nextElement();
                if (ne.hasMore()) {
                    throw new DirectoryException("More than one result return for query");
                }
                Attributes a = result.getAttributes();
                o = this.createInstanceFromAttributes(targetName.toString(), a, tx);
                tx.putCacheEntry(this, targetName, o, a);
            }
            finally {
                ne.close();
            }
            for (AttributeMapping am : this.attributes) {
                am.cascadePostLoad(o, tx);
            }
            return o;
        }
        catch (Exception e) {
            throw new DirectoryException("Can't load object", e);
        }
    }

    public void save(Object o, String baseDN, Transaction tx) throws DirectoryException {
        assert (o.getClass().equals(this.modelClass));
        if (tx.didAlreadyProcessEntity(o)) {
            return;
        }
        tx.addEntity(o);
        try {
            Name name;
            String dn;
            DirContext ctx;
            block11: {
                ctx = tx.getContext(this.directoryFacade);
                dn = this.getDN(o);
                name = null;
                if (null == dn) {
                    try {
                        this.saveNewObject(o, ctx, baseDN, tx);
                        return;
                    }
                    catch (NameAlreadyBoundException e) {
                        name = this.fillEmptyDN(o, ctx, baseDN);
                        if (!logger.isDebugEnabled()) break block11;
                        logger.debug((Object)("Caught NameAlreadyBoundException on saveNewObject for " + name + ". trying update instead."));
                    }
                }
            }
            if (null == name) {
                name = this.directoryFacade.makeRelativeName(dn);
            }
            try {
                DiropLogger.LOG.logGetAttributes(name, null, "save object");
                Attributes currentAttributes = ctx.getAttributes(name);
                this.updateObject(o, ctx, name, currentAttributes, tx);
                return;
            }
            catch (NameNotFoundException e) {
                throw new DirectoryException("Object to be updated no longer exists");
            }
        }
        catch (DirectoryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DirectoryException("Can't save object", e);
        }
    }

    private void saveNewObject(Object o, DirContext ctx, String baseDN, Transaction tx) throws InvalidNameException, DirectoryException, NamingException {
        Name targetName = this.fillEmptyDN(o, ctx, baseDN);
        for (AttributeMapping attributeMapping : this.attributes) {
            attributeMapping.cascadePreSave(o, tx);
        }
        BasicAttributes a = new BasicAttributes();
        this.rdnAttribute.dehydrate(o, a);
        this.fillAttributes(o, a);
        DiropLogger.LOG.logAdd(this.getDN(o), (Attributes)a, "save new object");
        ctx.bind(targetName, null, (Attributes)a);
        tx.putCacheEntry(this, this.getDirectoryFacade().makeAbsoluteName(targetName), o, a);
        try {
            for (AttributeMapping attributeMapping : this.attributes) {
                attributeMapping.cascadePostSave(o, tx, ctx);
            }
        }
        catch (DirectoryException t) {
            try {
                DiropLogger.LOG.logDelete(targetName, "delete due to rollback");
                ctx.destroySubcontext(targetName);
            }
            catch (Throwable u) {
                // empty catch block
            }
            throw t;
        }
    }

    private Name fillEmptyDN(Object o, DirContext ctx, String baseDN) throws DirectoryException, NamingException, InvalidNameException {
        if (null == baseDN) {
            baseDN = this.baseRDN;
        }
        if (null == baseDN && this.getDirectoryFacade().isReadOnly()) {
            baseDN = "";
        }
        if (null == baseDN) {
            throw new DirectoryException("Can't save object: don't know where to save it to");
        }
        Name name = this.directoryFacade.makeRelativeName(baseDN);
        Object rdnValue = this.rdnAttribute.getValue(o);
        if (null == rdnValue) {
            throw new DirectoryException("Can't save new instance: attribute for RDN (" + this.rdnAttribute + ") not set.");
        }
        name.addAll(new LdapName(this.rdnAttribute.fieldName + "=" + rdnValue));
        this.setDN(this.directoryFacade.makeAbsoluteName(name).toString(), o);
        return name;
    }

    void setMapping(Mapping mapping) {
        if (null != this.mapping) {
            this.mapping.remove(this);
        }
        this.mapping = mapping;
    }

    public void setRDNAttribute(AttributeMapping rdnAttribute) {
        if (!this.dnAttribute.getFieldType().equals(String.class)) {
            throw new IllegalArgumentException("The RDN Attribute must be of type string");
        }
        rdnAttribute.setTypeMapping(this);
        this.rdnAttribute = rdnAttribute;
    }

    public AttributeMapping getRDNAttribute() {
        return this.rdnAttribute;
    }

    public String toString() {
        return "[TypeMapping class=" + this.modelClass + ", baseDN=" + this.baseRDN + ", filter=" + this.searchFilter + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateObject(Object o, DirContext ctx, Name targetName, Attributes currentAttributes, Transaction tx) throws DirectoryException, NamingException {
        Name targetDN = this.getDirectoryFacade().makeAbsoluteName(targetName);
        tx.purgeCacheEntry(targetDN);
        try {
            Attributes clearedAttributes;
            BasicAttributes newAttributes = new BasicAttributes();
            Object rdn = this.rdnAttribute.dehydrate(o, newAttributes);
            if (null == rdn) {
                throw new DirectoryException("Can't save new instance: attribute for RDN (" + this.rdnAttribute + ") not set.");
            }
            if (!rdn.equals(currentAttributes.get(this.rdnAttribute.fieldName).get()) && LDAPDirectory.isMutable(o.getClass())) {
                targetName = this.renameObject(targetName, ctx, rdn, o, tx, newAttributes);
                targetDN = this.getDirectoryFacade().makeAbsoluteName(targetName);
            }
            this.fillAttributes(o, newAttributes);
            LinkedList<ModificationItem> mods = new LinkedList<ModificationItem>();
            if (currentAttributes.size() > 0 && (clearedAttributes = this.getClearedAttributes((BasicAttributes)newAttributes.clone(), (Attributes)currentAttributes.clone())).size() > 0) {
                NamingEnumeration<? extends Attribute> enmAttribute = clearedAttributes.getAll();
                while (enmAttribute.hasMore()) {
                    Attribute clearedAttribute = enmAttribute.next();
                    mods.add(new ModificationItem(3, clearedAttribute));
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("The value of following Attribute will be cleared: " + clearedAttribute));
                }
            }
            NamingEnumeration<Attribute> ne = newAttributes.getAll();
            try {
                while (ne.hasMore()) {
                    Attribute newValues = ne.next();
                    String id = newValues.getID();
                    if (id.equalsIgnoreCase("objectclass") || id.equalsIgnoreCase("cn")) {
                        currentAttributes.remove(id);
                        continue;
                    }
                    this.updateAttributes(currentAttributes, currentAttributes.get(id), newValues, mods, o);
                }
            }
            finally {
                ne.close();
            }
            if (mods.size() > 0) {
                ModificationItem[] mi = mods.toArray(new ModificationItem[mods.size()]);
                DiropLogger.LOG.logModify(targetName, mi, "update object");
                if (LDAPDirectory.isMutable(this.getMappedType())) {
                    ctx.modifyAttributes(targetName, mi);
                }
            }
            tx.putCacheEntry(this, targetDN, o, newAttributes);
            for (AttributeMapping attributeMapping : this.attributes) {
                attributeMapping.cascadePostSave(o, tx, ctx);
            }
        }
        catch (DirectoryException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new DirectoryException("Can't marshal instance of " + this.modelClass, e);
        }
    }

    private Name renameObject(Name oldName, DirContext ctx, Object rdn, Object o, Transaction tx, BasicAttributes attrib) throws NamingException, DirectoryException {
        String newDN;
        Name newName = oldName.getPrefix(oldName.size() - 1).add(this.rdnAttribute.fieldName + "=" + rdn);
        String oldDN = this.getDN(o);
        if (oldDN.equals(newDN = ((Name)this.getDirectoryFacade().getBaseDNName().clone()).addAll(newName).toString())) {
            return oldName;
        }
        DiropLogger.LOG.logModRDN(oldName, newName, "rename object");
        ctx.rename(oldName, newName);
        this.getMapping().updateReferences(tx, oldDN, newDN);
        this.setDN(newDN, o);
        for (AttributeMapping attributeMapping : this.attributes) {
            attributeMapping.cascadeRDNChange(o, oldDN, newDN, tx);
        }
        attrib.remove(this.rdnAttribute.fieldName);
        return newName;
    }

    protected void updateAttributes(Attributes currentAttributes, Attribute currentValues, Attribute newValues, List<ModificationItem> mods, Object o) throws NamingException, DirectoryException {
        String id = newValues.getID();
        if (currentValues != null) {
            if (newValues.size() == 1 && newValues.get(0) == ATTRIBUTE_UNCHANGED_MARKER) {
                currentAttributes.remove(id);
            } else {
                if (!this.areAttributesEqual(newValues, currentValues)) {
                    mods.add(new ModificationItem(2, newValues));
                }
                currentAttributes.remove(id);
            }
        } else if (currentValues == null && newValues != null) {
            mods.add(new ModificationItem(1, newValues));
        }
    }

    private Attributes getClearedAttributes(BasicAttributes nowAttributes, Attributes ldapAttributes) throws NamingException {
        BasicAttributes cleared = new BasicAttributes();
        nowAttributes.remove("objectClass");
        ldapAttributes.remove("objectClass");
        NamingEnumeration<String> nowIDs = nowAttributes.getIDs();
        while (nowIDs.hasMore()) {
            String id = nowIDs.next();
            ldapAttributes.remove(id);
        }
        HashSet<String> attr = new HashSet<String>();
        for (AttributeMapping am : this.attributes) {
            if (am instanceof ManyToManyMapping) continue;
            attr.add(am.fieldName);
        }
        NamingEnumeration<String> ldapIDs = ldapAttributes.getIDs();
        while (ldapIDs.hasMore()) {
            String id = ldapIDs.next();
            for (String rightID : attr) {
                if (!rightID.equalsIgnoreCase(id)) continue;
                cleared.put(ldapAttributes.get(id));
            }
        }
        return cleared;
    }

    private boolean areAttributesEqual(Attribute a1, Attribute a2) throws NamingException {
        if (!a1.getID().equalsIgnoreCase(a2.getID())) {
            return false;
        }
        if (a1.get() == null && a2.get() == null) {
            return true;
        }
        if (a1.get() == null || a2.get() == null) {
            return false;
        }
        if (a1.size() != a2.size()) {
            return false;
        }
        int i = 0;
        if (i < a1.size()) {
            if (a1.get() instanceof byte[]) {
                return Arrays.equals((byte[])a1.get(), (byte[])a2.get());
            }
            return a1.get(i).equals(a2.get(i));
        }
        return true;
    }

    private void fillAttributes(Object o, BasicAttributes a) throws DirectoryException, NamingException {
        for (AttributeMapping attributeMapping : this.attributes) {
            attributeMapping.dehydrate(o, a);
        }
        BasicAttribute objectClassesAttribute = new BasicAttribute("objectClass");
        for (String oc : this.objectClasses) {
            objectClassesAttribute.add(oc);
        }
        a.put(objectClassesAttribute);
    }

    public boolean delete(Object o, Transaction tx) throws DirectoryException {
        if (!LDAPDirectory.isMutable(o.getClass())) {
            return false;
        }
        if (tx.didAlreadyProcessEntity(o)) {
            return true;
        }
        tx.addEntity(o);
        String dn = this.getDN(o);
        if (null == dn) {
            throw new DirectoryException("Can't delete this object: no DN (mayby it wasn't saved before?)");
        }
        try {
            DirContext ctx = tx.getContext(this.directoryFacade);
            Name targetName = this.directoryFacade.makeRelativeName(dn);
            tx.purgeCacheEntry(targetName);
            TypeMapping.deleteRecursively(ctx, targetName, tx, "delete object");
            this.getMapping().updateReferences(tx, dn, null);
            try {
                for (AttributeMapping attributeMapping : this.attributes) {
                    attributeMapping.cascadeDelete(targetName, tx);
                }
            }
            catch (DirectoryException e) {
                logger.error((Object)"Exception during cascade post RDN change", (Throwable)e);
            }
            return true;
        }
        catch (NameNotFoundException e) {
            logger.warn((Object)"Object to be deleted was not actually found.");
            return false;
        }
        catch (Exception e) {
            throw new DirectoryException("Can't load object", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void deleteRecursively(DirContext ctx, Name targetName, Transaction tx, String comment) throws NamingException {
        NamingEnumeration<NameClassPair> children = ctx.list(targetName);
        try {
            while (children.hasMore()) {
                NameClassPair child = children.next();
                targetName.add(child.getName());
                TypeMapping.deleteRecursively(ctx, targetName, tx, "delete recursively");
                targetName.remove(targetName.size() - 1);
            }
        }
        finally {
            children.close();
        }
        DiropLogger.LOG.logDelete(targetName, comment);
        try {
            ctx.destroySubcontext(targetName);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void initPostLoad() {
        for (AttributeMapping am : this.attributes) {
            am.initPostLoad();
        }
    }

    void addReferrer(AttributeMapping mapping) {
        this.referrers.add(mapping);
    }

    public AttributeMapping getDNAttribute() {
        return this.dnAttribute;
    }

    public void setDNAttribute(AttributeMapping dnAttribute) {
        if (!dnAttribute.getFieldType().equals(String.class)) {
            throw new IllegalArgumentException("The DN Attribute must be of type string");
        }
        this.dnAttribute = dnAttribute;
        dnAttribute.setTypeMapping(this);
    }

    String getDN(Object o) throws DirectoryException {
        return (String)this.dnAttribute.getValue(o);
    }

    public String[] getObjectClasses() {
        return this.objectClasses;
    }

    public void refresh(Object o, Transaction tx) throws DirectoryException {
        try {
            DirContext ctx = tx.getContext(this.directoryFacade);
            String dn = this.getDN(o);
            try {
                Name targetName = this.directoryFacade.makeRelativeName(dn);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("refreshing object of " + this.modelClass + " for dn: " + dn));
                }
                DiropLogger.LOG.logGetAttributes(dn, null, "refresh object");
                Attributes a = ctx.getAttributes(targetName);
                this.hydrateInstance(a, o, tx);
                for (AttributeMapping am : this.attributes) {
                    am.cascadePostLoad(o, tx);
                }
                Name absoluteName = this.directoryFacade.makeAbsoluteName(dn);
                tx.putCacheEntry(this, absoluteName, o, a);
            }
            catch (NameNotFoundException n) {
                throw new DirectoryException("Can't refresh " + dn + ": object doesn't exist (any longer?)");
            }
        }
        catch (DirectoryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DirectoryException("Can't refresh object", e);
        }
    }

    public void setScope(String scope) {
        this.defaultScope = SearchScope.valueOf(scope);
    }

    public void setScope(SearchScope scope) {
        this.defaultScope = scope;
    }

    protected TypeMapping clone() throws CloneNotSupportedException {
        TypeMapping clone = (TypeMapping)super.clone();
        clone.referrers = new ArrayList<AttributeMapping>();
        clone.attributes = new ArrayList<AttributeMapping>();
        for (AttributeMapping am : this.attributes) {
            AttributeMapping clonedAM = am.clone();
            clone.add(clonedAM);
        }
        return clone;
    }

    public String getSearchFilter() {
        return this.searchFilter;
    }

    public void setObjectClasses(String[] objectClasses) {
        this.objectClasses = objectClasses;
    }

    public String getKeyClass() {
        return this.keyClass;
    }

    void setDirectoryFacade(DirectoryFacade lcd) {
        this.directoryFacade = lcd;
    }

    DirectoryFacade getDirectoryFacade() {
        return this.directoryFacade;
    }

    public boolean matchesKeyClasses(Attribute objectClasses) throws NamingException {
        if (null == this.keyClass) {
            return false;
        }
        NamingEnumeration<?> ne = objectClasses.getAll();
        while (ne.hasMore()) {
            if (!((String)ne.next()).equalsIgnoreCase(this.keyClass)) continue;
            return true;
        }
        return false;
    }

    public Name getDefaultBaseName() throws InvalidNameException, NamingException {
        if (null == this.defaultBaseName) {
            Name baseDNName = (Name)this.directoryFacade.getBaseDNName().clone();
            this.defaultBaseName = baseDNName.add(this.getBaseRDN());
        }
        return this.defaultBaseName;
    }

    protected void collectRefererAttributes(Set<ReferenceAttributeMapping> refererAttributes) {
        for (AttributeMapping am : this.attributes) {
            if (!(am instanceof ReferenceAttributeMapping)) continue;
            refererAttributes.add((ReferenceAttributeMapping)am);
        }
    }

    void handleParentNameChange(Object o, String oldDN, String newDN, Transaction tx) throws DirectoryException, NamingException {
        String dn = this.getDN(o);
        if (null != dn) {
            if (dn.endsWith(oldDN)) {
                this.setDN(dn.substring(0, dn.length() - oldDN.length()) + newDN, o);
            } else {
                logger.warn((Object)("Unexpected state during parent DN change: object's dn " + dn + " doesn't start with " + oldDN));
            }
        }
        for (AttributeMapping attributeMapping : this.attributes) {
            attributeMapping.cascadeRDNChange(o, oldDN, newDN, tx);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SearchScope {
        OBJECT(0),
        ONELEVEL(1),
        SUBTREE(2);

        private final int sc;

        private SearchScope(int sc) {
            this.sc = sc;
        }

        public int getScope() {
            return this.sc;
        }
    }
}

