/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.Sizes;
import com.jgoodies.forms.util.LayoutStyle;
import com.levigo.util.messaging.DefaultMessageFactory;
import com.levigo.util.messaging.MessageFactory;
import com.levigo.util.messaging.MessageListener;
import com.levigo.util.messaging.MessageManager;
import com.levigo.util.messaging.dialog.DefaultDialogMessageListener;
import com.levigo.util.swing.SlickBevelBorder;
import com.levigo.util.swing.TitledPanel;
import com.levigo.util.swing.action.Context;
import com.levigo.util.swing.action.DefaultMenuComponentFactory;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.prefs.Preferences;
import javax.naming.NamingException;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXStatusBar;
import org.netbeans.core.startup.MainLookup;
import org.netbeans.core.startup.layers.ModuleLayeredFileSystem;
import org.openide.ErrorManager;
import org.openthinclient.console.ApplicationSplash;
import org.openthinclient.console.DetailViewTopComponent;
import org.openthinclient.console.DetailViewTopObject;
import org.openthinclient.console.JreFix;
import org.openthinclient.console.MainTreeTopComponent;
import org.openthinclient.console.Messages;
import org.openthinclient.console.UIDefaults;

public class ConsoleFrame
extends JFrame {
    private static final Logger logger = Logger.getLogger(ConsoleFrame.class);
    private static final long serialVersionUID = 1L;
    public static final Preferences PREFERENCES_ROOT = Preferences.userRoot().node("org.openthinclient/console");
    private static final Dimension DEFAULT_SIZE = new Dimension(1024, 768);
    private DetailViewTopComponent detailHolder;
    private DetailViewTopObject detailHolderObject;
    private JSplitPane splitPaneDetail;
    private JMenuBar menuBar;
    private JXStatusBar statusBar;
    private int statusBarCursor;
    protected Context context;
    protected static ConsoleFrame INSTANCE;

    public ConsoleFrame(String[] args) {
        this.init();
        this.setVisible(false);
        ApplicationSplash lSplash = new ApplicationSplash(this, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("splash.gif")));
        MainLookup.moduleClassLoadersUp();
        try {
            String nbHome = System.getProperty("netbeans.user");
            if (nbHome == null) {
                nbHome = System.getProperty("user.home");
                System.setProperty("netbeans.user", nbHome + File.separator + ".openthinclient");
            }
            ArrayList<URL> urls = new ArrayList<URL>(1);
            urls.add(this.getClass().getResource("layer.xml"));
            ModuleLayeredFileSystem.getUserModuleLayer().addURLs(urls);
            this.setTitle(Messages.getString("ConsoleFrame.title"));
            this.setDefaultCloseOperation(3);
            this.initGUI(args.length > 0 ? args[0] : null);
            lSplash.dispose();
        }
        catch (Throwable e) {
            ErrorManager.getDefault().notify(e);
            System.exit(1);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ConsoleFrame.this.setVisible(true);
                INSTANCE = ConsoleFrame.this;
            }
        });
    }

    protected void initGUI(String initialPage) {
        this.initLAF();
        MainTreeTopComponent mttc = MainTreeTopComponent.getDefault();
        mttc.requestActive();
        UIDefaults.install(this);
        this.initMenuBar(this.context);
        this.setJMenuBar(this.menuBar);
        this.detailHolder = DetailViewTopComponent.getDefault();
        this.detailHolderObject = DetailViewTopObject.getDefault();
        this.detailHolder.componentOpened();
        this.splitPaneDetail = new JSplitPane(0, true, (Component)new TitledPanel((JComponent)((Object)this.detailHolder)), (Component)new TitledPanel((JComponent)((Object)this.detailHolderObject)));
        this.splitPaneDetail.getComponent(1).setVisible(false);
        this.splitPaneDetail.setBorder(new EmptyBorder(2, 0, 2, 0));
        this.getContentPane().add((Component)this.splitPaneDetail, "Center");
        JSplitPane splitPane = new JSplitPane(1, true, (Component)new TitledPanel((JComponent)((Object)mttc)), this.splitPaneDetail);
        splitPane.setBorder(new EmptyBorder(2, 0, 2, 0));
        splitPane.setDividerLocation(265);
        this.getContentPane().add((Component)splitPane, "Center");
        JToolBar toolbar = DefaultMenuComponentFactory.getInstance((String)"/org/openthinclient/console/menucomponents.properties").getToolbar("toolbar", this.context);
        toolbar.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.getContentPane().add((Component)toolbar, "North");
    }

    private void initLAF() {
        int gap = LayoutStyle.getCurrent().getNarrowLinePad().getPixelSize((Component)this);
        UIManager.put("TitledPanel.border", new LineBorder(UIManager.getColor("controlShadow")));
        UIManager.put("TitledPanel.titleBarBorder", new CompoundBorder((Border)new SlickBevelBorder(0), new EmptyBorder(gap, gap, gap, gap)));
        UIManager.put("SplitPane.border", new EmptyBorder(2, 2, 2, 2));
        UIManager.put("SplitPaneDivider.border", new EmptyBorder(1, 1, 1, 1));
    }

    private void addStatusComponent(JComponent c) {
        Box b = Box.createHorizontalBox();
        if (this.statusBarCursor > 0) {
            this.statusBar.add(Box.createHorizontalStrut(Sizes.DLUX2.getPixelSize((Component)this)), this.statusBarCursor);
            ++this.statusBarCursor;
        }
        b.setBorder(new CompoundBorder((Border)SlickBevelBorder.getLoweredBevelBorder(), Borders.DLU2_BORDER));
        b.add(c);
        this.statusBar.add((Component)b, this.statusBarCursor);
        ++this.statusBarCursor;
    }

    public static void main(String[] args) {
        JreFix.init();
        try {
            Logger.getRootLogger().setLevel(Level.ALL);
            ConsoleFrame.basicInitialization();
            new ConsoleFrame(args);
        }
        catch (Throwable e) {
            ErrorManager.getDefault().notify(e);
            e.printStackTrace();
            System.exit(-1);
        }
    }

    static void basicInitialization() throws NamingException {
        MessageManager.addMessageFactory((MessageFactory)new DefaultMessageFactory("org.openthinclient.console.Bundle"));
        MessageManager.addMessageListener((MessageListener)DefaultDialogMessageListener.getInstance());
        DefaultDialogMessageListener.getInstance().setResizable(true);
        DefaultDialogMessageListener.getInstance().ignore("DISPLAY");
        DefaultDialogMessageListener.getInstance().setCenterOnParent(true);
    }

    protected void initMenuBar(Context context) {
        this.menuBar = new JMenuBar();
        DefaultMenuComponentFactory mcf = DefaultMenuComponentFactory.getInstance((String)"/org/openthinclient/console/menucomponents.properties");
        this.menuBar.add(mcf.getMenu("file", context));
        this.menuBar.add(mcf.getMenu("realm", context));
    }

    protected void init() {
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("icon.png")));
        this.initContext();
        this.setStartUpSize();
    }

    protected void initContext() {
        this.context = new Context((JComponent)this.getRootPane(), 1);
        this.context.clear();
        this.context.add((Object)this);
    }

    protected void setStartUpSize() {
        Dimension mySize = this.getSize();
        if (mySize.width < ConsoleFrame.DEFAULT_SIZE.width) {
            mySize.width = ConsoleFrame.DEFAULT_SIZE.width;
        }
        if (mySize.height < ConsoleFrame.DEFAULT_SIZE.height) {
            mySize.height = ConsoleFrame.DEFAULT_SIZE.height;
        }
        this.setSize(mySize);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - mySize.width) / 2, (screenSize.height - mySize.height) / 2);
    }

    public static ConsoleFrame getINSTANCE() {
        return INSTANCE;
    }

    public void showObjectDetails(int length) {
        if (length < 10) {
            this.splitPaneDetail.setDividerLocation(100 + 15 * length);
        } else {
            this.splitPaneDetail.setDividerLocation(0.33);
        }
        this.splitPaneDetail.getComponent(1).setVisible(true);
    }

    public void hideObjectDetails() {
        this.splitPaneDetail.getComponent(1).setVisible(false);
    }
}

