/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.ModificationItem;
import javax.naming.ldap.LdapContext;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;
import org.openthinclient.common.directory.LDAPDirectory;
import org.openthinclient.common.model.Application;
import org.openthinclient.common.model.ApplicationGroup;
import org.openthinclient.common.model.Device;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.common.model.Location;
import org.openthinclient.common.model.Printer;
import org.openthinclient.common.model.Realm;
import org.openthinclient.common.model.UserGroup;
import org.openthinclient.console.Messages;
import org.openthinclient.console.Refreshable;
import org.openthinclient.ldap.DirectoryException;
import org.openthinclient.ldap.DirectoryFacade;
import org.openthinclient.ldap.LDAPConnectionDescriptor;

public class CopyAction
extends NodeAction {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performAction(Node[] arg0) {
        for (Node node : arg0) {
            try {
                DirectoryObject dirObject = (DirectoryObject)node.getLookup().lookup(DirectoryObject.class);
                Realm realm = (Realm)node.getLookup().lookup(Realm.class);
                LDAPConnectionDescriptor lcd = realm.getConnectionDescriptor();
                DirectoryFacade df = lcd.createDirectoryFacade();
                LdapContext ctx = df.createDirContext();
                try {
                    DirectoryObject copy = (DirectoryObject)dirObject.getClass().newInstance();
                    copy.setName("copy");
                    realm.getDirectory().save((Object)copy);
                    Name name = df.makeRelativeName(dirObject.getDn());
                    String dnOU = copy.getDn().replace("," + lcd.getBaseDN(), "");
                    Name nameNew = df.makeRelativeName(dnOU);
                    Attributes dirObjAttrs = ctx.getAttributes(name);
                    NamingEnumeration<? extends Attribute> enm = dirObjAttrs.getAll();
                    LinkedList<ModificationItem> mods = new LinkedList<ModificationItem>();
                    while (enm.hasMore()) {
                        Attribute a = enm.next();
                        if (a.getID().equals("cn")) continue;
                        mods.add(new ModificationItem(2, a));
                    }
                    if (mods.size() > 0) {
                        ModificationItem[] mi = new ModificationItem[mods.size()];
                        mods.toArray(mi);
                        ctx.modifyAttributes(nameNew, mi);
                    }
                    Class[] classes = new Class[]{Realm.class, UserGroup.class, ApplicationGroup.class, Application.class, Printer.class, Device.class, Location.class};
                    HashSet set = new HashSet();
                    for (Class cl : classes) {
                        Set list = realm.getDirectory().getMapping().list(cl);
                        set.addAll(list);
                    }
                    for (DirectoryObject obj : set) {
                        Name targetName = df.makeRelativeName(obj.getDn());
                        Attributes attrs = ctx.getAttributes(targetName);
                        Attribute a = attrs.get("uniquemember");
                        if (a == null) continue;
                        for (int i = 0; a.size() > i; ++i) {
                            if (!a.get(i).equals(LDAPDirectory.idToUpperCase((String)dirObject.getDn()))) continue;
                            if (a.size() == 0) {
                                // empty if block
                            }
                            Attribute newMember = (Attribute)a.clone();
                            newMember.add(LDAPDirectory.idToUpperCase((String)copy.getDn()));
                            ModificationItem[] mod = new ModificationItem[]{new ModificationItem(2, newMember)};
                            ctx.modifyAttributes(targetName, mod);
                        }
                    }
                }
                finally {
                    ctx.close();
                }
                Node parentNode = node.getParentNode();
                if (null == parentNode || !(parentNode instanceof Refreshable)) continue;
                ((Refreshable)parentNode).refresh();
            }
            catch (DirectoryException e) {
                e.printStackTrace();
            }
            catch (NamingException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        for (Node node : activatedNodes) {
            Class currentClass = (Class)node.getLookup().lookup(Class.class);
            if (LDAPDirectory.isMutable((Class)currentClass)) continue;
            return false;
        }
        return true;
    }

    public String getName() {
        return Messages.getString("Copy");
    }

    public HelpCtx getHelpCtx() {
        return null;
    }
}

