/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.painter.Painter;
import org.jdesktop.swingx.painter.gradient.BasicGradientPainter;
import org.openide.ErrorManager;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;
import org.openthinclient.console.ConsoleFrame;
import org.openthinclient.console.DetailView;
import org.openthinclient.console.DetailViewProvider;
import org.openthinclient.console.DetailViewTopComponent;
import org.openthinclient.console.Messages;

public final class DetailViewTopObject
extends TopComponent {
    private static final long serialVersionUID = 1L;
    private static final int MAX_TITLE_LENGTH = 60;
    private static DetailViewTopObject instance;
    private final PropertyChangeListener propertyChangeListener;
    private final MyNodeListener listener = new MyNodeListener();
    private TopComponent lastTopComponent;
    private DetailViewProvider currentDetailViewProvider;

    private DetailViewTopObject() {
        this.setName(Messages.getString("DetailViewTopComponent.name"));
        Image loadImage = Utilities.loadImage((String)"org/openthinclient/console/rss16.gif", (boolean)true);
        this.setIcon(loadImage);
        this.setLayout(new BorderLayout());
        this.setBorder(null);
        this.propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("currentNodes")) {
                    Object src = evt.getSource();
                    DetailViewTopObject.this.nodeSelectionChanged(evt.getNewValue(), src instanceof TopComponent.Registry ? ((TopComponent.Registry)src).getActivated() : null);
                }
            }
        };
    }

    protected void componentOpened() {
        DetailViewTopObject.getRegistry().addPropertyChangeListener(this.propertyChangeListener);
    }

    protected void componentClosed() {
        super.componentClosed();
        if (null != this.propertyChangeListener) {
            DetailViewTopObject.getRegistry().removePropertyChangeListener(this.propertyChangeListener);
        }
    }

    public void nodeSelectionChanged(Object newValue, TopComponent topComponent) {
        this.lastTopComponent = topComponent;
        if (newValue == null || topComponent != null) {
            newValue = topComponent.getActivatedNodes();
        }
        if (newValue != null && newValue instanceof Node[] && newValue.length > 0) {
            Node[] selection = newValue;
            DetailViewProvider dvp = null;
            for (Node node : selection) {
                if (!(node instanceof DetailViewProvider)) continue;
                dvp = (DetailViewProvider)node;
                break;
            }
            if (null != dvp) {
                this.setTitle((Node)dvp);
                this.updateDetailView(dvp, selection, topComponent);
            }
        }
    }

    private void setTitle(Node node) {
        StringBuffer sb = new StringBuffer(node.getDisplayName());
        for (Node parent = node.getParentNode(); null != parent; parent = parent.getParentNode()) {
            sb.insert(0, " > ");
            sb.insert(0, parent.getDisplayName());
        }
        if (sb.length() > 60) {
            int idx = -1;
            int nextIdx = sb.length();
            while (sb.length() - nextIdx < 60 && nextIdx > 0) {
                idx = nextIdx;
                nextIdx = sb.lastIndexOf(">", idx - 1);
            }
            if (idx < 0) {
                idx = sb.length() - 60;
            }
            sb.replace(0, idx + 1, "...");
        }
        this.setName(sb.toString());
    }

    private void updateDetailView(DetailViewProvider dvp, Node[] selection, TopComponent topComponent) {
        ConsoleFrame.getINSTANCE().hideObjectDetails();
        this.detachDetailView();
        if (null == dvp || 0 == selection.length) {
            return;
        }
        this.currentDetailViewProvider = dvp;
        try {
            DetailView detailView = dvp.getDetailView();
            detailView.init(selection, topComponent);
            if (dvp instanceof Node) {
                ((Node)dvp).addNodeListener((NodeListener)this.listener);
            }
            this.reloadDetailView(detailView);
        }
        catch (RuntimeException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    private void detachDetailView() {
        if (null != this.currentDetailViewProvider && this.currentDetailViewProvider instanceof Node) {
            ((Node)this.currentDetailViewProvider).removeNodeListener((NodeListener)this.listener);
        }
        this.currentDetailViewProvider = null;
        this.removeAll();
    }

    private void reloadDetailView(DetailView detailView) {
        JComponent footerComponent;
        JComponent mainComponent;
        this.removeAll();
        JComponent headerComponent = detailView.getHeaderComponent();
        if (null != headerComponent) {
            JXPanel p = new JXPanel((LayoutManager)new BorderLayout());
            BasicGradientPainter gradient = new BasicGradientPainter(BasicGradientPainter.GRAY);
            p.setBackgroundPainter((Painter)gradient);
            p.setBorder((Border)BorderFactory.createMatteBorder(0, 0, 1, 0, this.getBackground().darker()));
            headerComponent.setOpaque(false);
            p.add((Component)headerComponent, (Object)"Center");
            this.add((Component)p, "North");
        }
        if (null != (mainComponent = detailView.getMainComponent())) {
            this.add(mainComponent, "Center");
        }
        if ((footerComponent = detailView.getFooterComponent()) != null) {
            this.add(footerComponent, "South");
        }
        this.revalidate();
        this.repaint();
    }

    public static synchronized DetailViewTopObject getDefault() {
        if (instance == null) {
            instance = new DetailViewTopObject();
        }
        return instance;
    }

    public int getPersistenceType() {
        return 0;
    }

    protected String preferredID() {
        return "MainTreeTopComponent";
    }

    protected Object writeReplace() {
        return new ResolvableHelper();
    }

    public boolean canClose() {
        return false;
    }

    private static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        private ResolvableHelper() {
        }

        public Object readResolve() {
            return DetailViewTopComponent.getDefault();
        }
    }

    private class MyNodeListener
    implements NodeListener {
        private MyNodeListener() {
        }

        public void childrenAdded(NodeMemberEvent arg0) {
            DetailViewTopObject.this.updateDetailView(DetailViewTopObject.this.currentDetailViewProvider, DetailViewTopObject.this.lastTopComponent.getActivatedNodes(), DetailViewTopObject.this.lastTopComponent);
        }

        public void childrenRemoved(NodeMemberEvent arg0) {
            DetailViewTopObject.this.updateDetailView(DetailViewTopObject.this.currentDetailViewProvider, DetailViewTopObject.this.lastTopComponent.getActivatedNodes(), DetailViewTopObject.this.lastTopComponent);
        }

        public void childrenReordered(NodeReorderEvent arg0) {
            DetailViewTopObject.this.updateDetailView(DetailViewTopObject.this.currentDetailViewProvider, DetailViewTopObject.this.lastTopComponent.getActivatedNodes(), DetailViewTopObject.this.lastTopComponent);
        }

        public void nodeDestroyed(NodeEvent arg0) {
            DetailViewTopObject.this.detachDetailView();
            DetailViewTopObject.this.revalidate();
            DetailViewTopObject.this.repaint();
        }

        public void propertyChange(PropertyChangeEvent evt) {
            DetailViewTopObject.this.updateDetailView(DetailViewTopObject.this.currentDetailViewProvider, DetailViewTopObject.this.lastTopComponent.getActivatedNodes(), DetailViewTopObject.this.lastTopComponent);
        }
    }
}

