/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console;

import javax.swing.SwingUtilities;
import org.openide.ErrorManager;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.common.model.Realm;
import org.openthinclient.common.model.UnrecognizedClient;
import org.openthinclient.console.DetailView;
import org.openthinclient.console.EditorProvider;
import org.openthinclient.console.MainTreeTopComponent;
import org.openthinclient.console.Messages;
import org.openthinclient.console.Refreshable;
import org.openthinclient.console.nodes.DirObjectNode;
import org.openthinclient.console.ui.DirObjectEditPanel;
import org.openthinclient.ldap.DirectoryException;

public class EditAction
extends NodeAction {
    protected boolean asynchronous() {
        return true;
    }

    protected void performAction(final Node[] nodes) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                block4: for (Node node : nodes) {
                    if (!(node instanceof EditorProvider)) continue;
                    DirectoryObject dirObject = (DirectoryObject)node.getLookup().lookup(DirectoryObject.class);
                    Realm realm = (Realm)node.getLookup().lookup(Realm.class);
                    DirectoryObject copy = null;
                    try {
                        copy = (DirectoryObject)realm.getDirectory().load(dirObject.getClass(), dirObject.getDn(), true);
                        if (dirObject instanceof Realm) {
                            ((Realm)copy).setConnectionDescriptor(((Realm)dirObject).getConnectionDescriptor());
                        }
                        DetailView editor = ((EditorProvider)node).getEditor();
                        editor.init(new Node[]{new DirObjectNode(node.getParentNode(), copy)}, MainTreeTopComponent.getDefault());
                        Node parentNode = node.getParentNode();
                        if (dirObject.getClass().equals(UnrecognizedClient.class)) {
                            Node[] parentParentNodeList;
                            new DirObjectEditPanel(editor);
                            if (null != parentNode && parentNode instanceof Refreshable) {
                                ((Refreshable)parentNode).refresh();
                            }
                            for (Node topNode : parentParentNodeList = parentNode.getParentNode().getChildren().getNodes()) {
                                if (!topNode.getName().equalsIgnoreCase(Messages.getString("types.plural.Client"))) continue;
                                ((Refreshable)topNode).refresh();
                                continue block4;
                            }
                            continue;
                        }
                        if (!new DirObjectEditPanel(editor).doEdit(copy, node)) continue;
                        try {
                            realm.getDirectory().save((Object)copy);
                            if (!dirObject.getDn().equals(copy.getDn()) && !(dirObject instanceof Realm)) {
                                if (null == parentNode || !(parentNode instanceof Refreshable)) continue;
                                ((Refreshable)parentNode).refresh();
                                continue;
                            }
                            if (node == null || !(node instanceof Refreshable)) continue;
                            ((Refreshable)node).refresh();
                        }
                        catch (DirectoryException e) {
                            ErrorManager.getDefault().notify((Throwable)e);
                        }
                    }
                    catch (DirectoryException e) {
                        ErrorManager.getDefault().notify((Throwable)e);
                    }
                }
            }
        });
    }

    protected boolean enable(Node[] arg0) {
        return true;
    }

    public String getName() {
        return Messages.getString("action." + ((Object)((Object)this)).getClass().getSimpleName());
    }

    public HelpCtx getHelpCtx() {
        return null;
    }
}

