/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.openide.ErrorManager;
import org.openide.nodes.Node;
import org.openide.windows.TopComponent;
import org.openthinclient.common.model.Client;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.common.model.Realm;
import org.openthinclient.console.AbstractDetailView;
import org.openthinclient.console.Messages;
import org.openthinclient.console.nodes.DirObjectListNode;
import org.openthinclient.console.nodes.DirObjectNode;
import org.openthinclient.console.nodes.RealmNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogDetailView
extends AbstractDetailView {
    private static LogDetailView detailView;
    private boolean isClient;
    private static String fileName;
    private String macAdress;
    private JTextField queryField;
    private static JComponent mainComponent;
    private Node node;

    public static LogDetailView getInstance() {
        if (detailView == null) {
            detailView = new LogDetailView();
        }
        return detailView;
    }

    @Override
    public JComponent getHeaderComponent() {
        this.getFooterComponent();
        DefaultFormBuilder dfb = new DefaultFormBuilder(new FormLayout("p,100dlu,f:p:g", "f:p"));
        this.queryField = new JTextField();
        JButton searchButton = new JButton(Messages.getString("Search"));
        searchButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LogDetailView.this.macAdress = LogDetailView.this.queryField.getText();
                LogDetailView.this.isClient = true;
                mainComponent = LogDetailView.this.getFooterComponent();
                mainComponent.repaint();
            }
        });
        dfb.append((Component)new JLabel(Messages.getString("DirObjectListNode.filter")), (Component)this.queryField, (Component)searchButton);
        return dfb.getPanel();
    }

    @Override
    public JComponent getMainComponent() {
        JPanel jpl = new JPanel();
        CellConstraints cc = new CellConstraints();
        jpl.setLayout((LayoutManager)new FormLayout("f:p:g", "p,f:p:g"));
        jpl.add((Component)detailView.getHeaderComponent(), cc.xy(1, 1));
        jpl.add((Component)mainComponent, cc.xy(1, 2));
        return jpl;
    }

    @Override
    public JComponent getFooterComponent() {
        JTextArea ta = new JTextArea();
        ta.setEditable(false);
        for (String str : this.getLogFile()) {
            ta.append(str + "\n");
        }
        mainComponent = new JScrollPane(ta);
        mainComponent.setBackground(UIManager.getColor("TextField.background"));
        return mainComponent;
    }

    @Override
    public void init(Node[] selection, TopComponent tc) {
        mainComponent = null;
        for (Node node : selection) {
            if (node instanceof RealmNode) {
                this.isClient = false;
                this.node = node;
                fileName = "/openthinclient/files/var/log/server.log";
                break;
            }
            if (node instanceof DirObjectListNode) {
                this.isClient = false;
                this.node = node;
                fileName = "/openthinclient/files/var/log/syslog.log";
                break;
            }
            if (!(node instanceof DirObjectNode)) continue;
            this.macAdress = ((Client)((DirectoryObject)node.getLookup().lookup(DirectoryObject.class))).getMacAddress();
            this.isClient = true;
            this.node = node;
            fileName = "/openthinclient/files/var/log/syslog.log";
            break;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<String> getLogFile() {
        String homeServer = "";
        if (null == this.node) {
            if (null == System.getProperty("ThinClientManager.server.Codebase")) throw new IllegalStateException(Messages.getString("LogDetailView.getLogFile.NoRealm"));
            try {
                homeServer = new URL(System.getProperty("ThinClientManager.server.Codebase")).getHost();
            }
            catch (MalformedURLException e1) {
                e1.printStackTrace();
            }
        } else {
            Realm realm = (Realm)this.node.getLookup().lookup(Realm.class);
            if (null == realm) {
                throw new IllegalStateException(Messages.getString("LogDetailView.getLogFile.NoRealm"));
            }
            if (null != realm.getSchemaProviderName()) {
                homeServer = realm.getSchemaProviderName();
            } else if (null != realm.getConnectionDescriptor().getHostname()) {
                homeServer = realm.getConnectionDescriptor().getHostname();
            }
            if (homeServer.length() == 0) {
                homeServer = "localhost";
            }
        }
        try {
            URL url = new URL("http", homeServer, 8080, fileName);
            BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream()));
            ArrayList<String> lines = new ArrayList<String>();
            if (this.isClient) {
                String line;
                while ((line = br.readLine()) != null) {
                    if (!line.contains(this.macAdress)) continue;
                    lines.add(line);
                }
                if (lines.size() == 0) {
                    lines.add(Messages.getString("LogDetailView.getLogFile.NoEntrysForTC", this.macAdress));
                }
            } else {
                String line;
                while ((line = br.readLine()) != null) {
                    lines.add(line);
                }
            }
            br.close();
            if (lines.size() != 0) return lines;
            lines.add(Messages.getString("LogDetailView.getLogFile.NoEntrys"));
            return lines;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            ErrorManager.getDefault().notify((Throwable)e);
            return Collections.EMPTY_LIST;
        }
        catch (IOException e) {
            e.printStackTrace();
            ErrorManager.getDefault().notify((Throwable)e);
        }
        return Collections.EMPTY_LIST;
    }
}

