/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.nodes.Node;
import org.openide.windows.TopComponent;
import org.openthinclient.common.model.Client;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.common.model.Realm;
import org.openthinclient.console.AbstractDetailView;
import org.openthinclient.console.Messages;
import org.openthinclient.console.nodes.DirObjectListNode;
import org.openthinclient.console.nodes.DirObjectNode;
import org.openthinclient.console.nodes.RealmNode;

public class LogEditorPanel
extends JPanel {
    private static LogEditorPanel logeditorPanel;
    private LogDetailView logdetailview;
    private JScrollPane jsp = new JScrollPane();

    public static LogEditorPanel getInstance() {
        logeditorPanel = new LogEditorPanel();
        return logeditorPanel;
    }

    public void init(Collection collection, TopComponent tc) {
        this.logdetailview = LogDetailView.getInstance();
        this.logdetailview.init(collection.toArray(new Node[collection.size()]), tc);
    }

    public void initForToolbar(Node[] selection, TopComponent tc, int who) {
        this.logdetailview = LogDetailView.getInstance();
        this.logdetailview.initForToolbar(selection, tc, who);
    }

    public void doEdit() {
        this.setSize(new Dimension(640, 480));
        this.setLayout((LayoutManager)new FormLayout("f:m:g", "50dlu,f:min(200dlu;pref):g"));
        CellConstraints cc = new CellConstraints();
        this.jsp = new JScrollPane();
        this.jsp.add(this.logdetailview.getMainComponent());
        this.jsp.setMinimumSize(new Dimension(500, 400));
        this.add((Component)this.logdetailview.getHeaderComponent(), cc.xy(1, 1));
        this.add((Component)this.jsp, cc.xy(1, 2));
        this.refreshMain();
        DialogDisplayer.getDefault().createDialog(new DialogDescriptor((Object)this, this.getName(), true, new Object[]{DialogDescriptor.OK_OPTION}, (Object)this, 0, null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LogEditorPanel.this.logdetailview.bsearch = false;
            }
        })).setVisible(true);
    }

    public void refreshMain() {
        this.remove(this.jsp);
        this.jsp = new JScrollPane(this.logdetailview.getMainComponent());
        this.add((Component)this.jsp, new CellConstraints().xy(1, 2));
        this.repaint();
        this.validate();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LogDetailView
    extends AbstractDetailView {
        private static LogDetailView detailView;
        private static boolean isClient;
        private static String fileName;
        private String macAdress;
        private JTextField queryField;
        private static JComponent mainComponent;
        private boolean bsearch;
        private String searchValue;
        private static List<String> logFile;
        public static final int SYS_LOG_FILE = 1;
        public static final int SERVER_LOG_FILE = 2;
        private Node node;

        LogDetailView() {
        }

        public static LogDetailView getInstance() {
            if (detailView == null) {
                detailView = new LogDetailView();
            }
            return detailView;
        }

        public void initForToolbar(Node[] selection, TopComponent tc, int who) {
            mainComponent = null;
            if (who == 1) {
                fileName = "/openthinclient/files/var/log/syslog.log";
            }
            if (who == 2) {
                fileName = "/openthinclient/files/var/log/server.log";
            }
            isClient = false;
            logFile = new ArrayList<String>(this.getLogFile());
        }

        @Override
        public JComponent getHeaderComponent() {
            this.getFooterComponent();
            DefaultFormBuilder dfb = new DefaultFormBuilder(new FormLayout("p,  5dlu,100dlu,10dlu,p,10dlu,p,10dlu,p,10dlu,p", "f:p"));
            dfb.setDefaultDialogBorder();
            this.queryField = new JTextField();
            JButton searchButton = new JButton(Messages.getString("Search"));
            searchButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    LogDetailView.this.searchValue = LogDetailView.this.queryField.getText();
                    LogDetailView.this.bsearch = true;
                    logeditorPanel.refreshMain();
                }
            });
            JButton clearSearchButton = new JButton(Messages.getString("ClearSearch"));
            clearSearchButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    LogDetailView.this.bsearch = false;
                    LogDetailView.this.searchValue = "";
                    LogDetailView.this.queryField.setText("");
                    logeditorPanel.refreshMain();
                }
            });
            JButton updateButton = new JButton(Messages.getString("update"));
            updateButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    LogDetailView.this.bsearch = false;
                    LogDetailView.this.searchValue = "";
                    LogDetailView.this.queryField.setText("");
                    logFile = new ArrayList(LogDetailView.this.getLogFile());
                    logeditorPanel.refreshMain();
                }
            });
            JButton saveButton = new JButton(Messages.getString("save"));
            saveButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    LogDetailView.this.saveParsedLogFile();
                }
            });
            dfb.append(Messages.getString("DirObjectListNode.filter"), (Component)this.queryField, (Component)searchButton, (Component)clearSearchButton, (Component)updateButton);
            dfb.append((Component)saveButton);
            dfb.nextLine();
            return dfb.getPanel();
        }

        @Override
        public JComponent getMainComponent() {
            JTextArea ta = new JTextArea();
            ta.setEditable(false);
            for (String str : this.parseList()) {
                ta.append(str + "\n");
            }
            mainComponent = ta;
            mainComponent.setBackground(UIManager.getColor("TextField.background"));
            return mainComponent;
        }

        @Override
        public void init(Node[] selection, TopComponent tc) {
            mainComponent = null;
            for (Node node : selection) {
                if (node instanceof RealmNode) {
                    isClient = false;
                    this.node = node;
                    fileName = "/openthinclient/files/var/log/server.log";
                    break;
                }
                if (node instanceof DirObjectListNode) {
                    isClient = false;
                    this.node = node;
                    fileName = "/openthinclient/files/var/log/syslog.log";
                    break;
                }
                if (!(node instanceof DirObjectNode)) continue;
                this.macAdress = ((Client)((DirectoryObject)node.getLookup().lookup(DirectoryObject.class))).getMacAddress();
                isClient = true;
                this.node = node;
                fileName = "/openthinclient/files/var/log/syslog.log";
                break;
            }
            logFile = new ArrayList<String>(this.getLogFile());
        }

        private List<String> getLogFile() {
            String homeServer = "";
            Realm realm = null;
            if (null == this.node) {
                if (null != System.getProperty("ThinClientManager.server.Codebase")) {
                    try {
                        homeServer = new URL(System.getProperty("ThinClientManager.server.Codebase")).getHost();
                    }
                    catch (MalformedURLException e1) {
                        e1.printStackTrace();
                    }
                }
            } else {
                realm = (Realm)this.node.getLookup().lookup(Realm.class);
                if (null != realm.getSchemaProviderName()) {
                    homeServer = realm.getSchemaProviderName();
                } else if (null != realm.getConnectionDescriptor().getHostname()) {
                    homeServer = realm.getConnectionDescriptor().getHostname();
                }
            }
            if (homeServer.length() == 0) {
                homeServer = "localhost";
            }
            try {
                URL url = new URL("http", homeServer, 8080, fileName);
                BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream()));
                ArrayList<String> lines = new ArrayList<String>();
                if (isClient) {
                    String line;
                    while ((line = br.readLine()) != null) {
                        if (!line.contains(this.macAdress)) continue;
                        lines.add(line);
                    }
                    if (lines.size() == 0) {
                        lines.add(Messages.getString("LogDetailView.getLogFile.NoEntrysForTC", this.macAdress));
                    }
                } else {
                    String line;
                    while ((line = br.readLine()) != null) {
                        lines.add(line);
                    }
                }
                br.close();
                if (lines.size() == 0) {
                    lines.add(Messages.getString("LogDetailView.getLogFile.NoEntrys"));
                }
                return lines;
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                ErrorManager.getDefault().notify((Throwable)e);
            }
            catch (IOException e) {
                e.printStackTrace();
                ErrorManager.getDefault().notify((Throwable)e);
            }
            return Collections.EMPTY_LIST;
        }

        private List<String> parseList() {
            if (this.bsearch) {
                ArrayList<String> tmp = new ArrayList<String>();
                for (String str : logFile) {
                    if (!str.contains(this.searchValue)) continue;
                    tmp.add(str);
                }
                return tmp;
            }
            return logFile;
        }

        public void saveParsedLogFile() {
            JFileChooser chooser = new JFileChooser();
            chooser.setDialogTitle("LogFile");
            chooser.addChoosableFileFilter(new FileFilter(){

                public String getDescription() {
                    return "Log files";
                }

                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().endsWith(".log");
                }
            });
            try {
                int returnVal = chooser.showSaveDialog(chooser.getParent());
                if (returnVal == 0) {
                    String path = chooser.getSelectedFile().getCanonicalPath();
                    if (!path.endsWith(".log")) {
                        path = path + ".log";
                    }
                    this.save(path);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public void save(String path) {
            try {
                ArrayList<String> tmp = new ArrayList<String>(this.parseList());
                StringBuffer sb = new StringBuffer();
                for (String str : tmp) {
                    sb.append(str);
                }
                BufferedWriter writer = new BufferedWriter(new FileWriter(new File(path)));
                writer.write(sb.toString());
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

