/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console;

import com.levigo.util.swing.action.AbstractCommand;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Properties;
import javax.management.InstanceNotFoundException;
import javax.naming.InitialContext;
import javax.naming.directory.DirContext;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.LdapName;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.util.Utilities;
import org.openthinclient.common.directory.ACLUtils;
import org.openthinclient.common.directory.LDAPDirectory;
import org.openthinclient.common.model.HardwareType;
import org.openthinclient.common.model.Location;
import org.openthinclient.common.model.OrganizationalUnit;
import org.openthinclient.common.model.Realm;
import org.openthinclient.common.model.User;
import org.openthinclient.common.model.UserGroup;
import org.openthinclient.common.model.schema.provider.SchemaLoadingException;
import org.openthinclient.console.HTTPLdifImportAction;
import org.openthinclient.console.Messages;
import org.openthinclient.console.RealmManager;
import org.openthinclient.console.wizards.initrealm.NewRealmInitWizardIterator;
import org.openthinclient.ldap.DirectoryException;
import org.openthinclient.ldap.LDAPConnectionDescriptor;
import org.openthinclient.ldap.Mapping;
import org.openthinclient.ldap.TypeMapping;
import org.openthinclient.remoted.Remoted;

public class NewRealmInitCommand
extends AbstractCommand {
    private void initHwtype(LDAPDirectory dir, Realm realm) throws DirectoryException {
        HardwareType type = new HardwareType();
        type.setName(Messages.getString("NewRealmInitAction.defaultHardware.name"));
        type.setDescription(Messages.getString("NewRealmInitAction.defaultHardware.description"));
        try {
            type.setSchema(realm.getSchemaProvider().getSchema(type.getClass(), "hardware type"));
        }
        catch (SchemaLoadingException e) {
            e.printStackTrace();
        }
        dir.save((Object)type);
    }

    private void initLocation(LDAPDirectory dir) throws DirectoryException {
        Location location = new Location();
        location.setName(Messages.getString("NewRealmInitAction.defaultLocation.name"));
        location.setDescription(Messages.getString("NewRealmInitAction.defaultLocation.description"));
        dir.save((Object)location);
    }

    public static void initAdmin(LDAPDirectory dir, Realm realm, String name, String baseDN) throws DirectoryException {
        baseDN = "cn=" + name + "," + baseDN;
        User admin = new User();
        admin.setName(name);
        admin.setDescription(Messages.getString("NewRealmInitAction.adminUser.description"));
        admin.setNewPassword(Messages.getString("NewRealmInitAction.adminUser.initialPassword"));
        admin.setSn("Admin");
        admin.setGivenName("Joe");
        UserGroup administrators = realm.getAdministrators();
        dir.save((Object)admin);
        administrators.getMembers().add(admin);
        realm.setAdministrators(administrators);
        dir.save((Object)administrators);
        dir.save((Object)realm);
    }

    private boolean isBooleanOptionSet(WizardDescriptor wizardDescriptor, String name) {
        Object property = wizardDescriptor.getProperty(name);
        return property != null && (Boolean)property != false;
    }

    public void createOU(String newFolderName, LDAPDirectory directory) {
        try {
            OrganizationalUnit ou = new OrganizationalUnit();
            ou.setName(newFolderName);
            ou.setDescription("openthinclient.org Console");
            directory.save((Object)ou, "");
        }
        catch (DirectoryException e1) {
            ErrorManager.getDefault().notify((Throwable)e1);
        }
    }

    public static Realm initRealm(LDAPDirectory dir, String description) throws DirectoryException {
        try {
            Realm realm = new Realm();
            realm.setDescription(description);
            UserGroup admins = new UserGroup();
            admins.setName("administrators");
            realm.setAdministrators(admins);
            String date = new Date().toString();
            realm.setValue("invisibleObjects.initialized", date);
            User roPrincipal = new User();
            roPrincipal.setName("roPrincipal");
            roPrincipal.setSn("Read Only User");
            roPrincipal.setNewPassword("secret");
            realm.setReadOnlyPrincipal(roPrincipal);
            dir.save((Object)realm, "");
            return realm;
        }
        catch (Exception e) {
            throw new DirectoryException(Messages.getString("NewRealmInitAction.error.cantSetup"), (Throwable)e);
        }
    }

    public static void initOUs(DirContext ctx, LDAPDirectory dir) throws DirectoryException {
        try {
            Mapping rootMapping = dir.getMapping();
            Collection typeMappers = rootMapping.getTypes().values();
            for (TypeMapping mapping : typeMappers) {
                OrganizationalUnit ou = new OrganizationalUnit();
                String baseDN = mapping.getBaseRDN();
                if (null == baseDN) continue;
                ou.setName(baseDN.substring(baseDN.indexOf("=") + 1));
                dir.save((Object)ou, "");
            }
        }
        catch (Exception e) {
            throw new DirectoryException(Messages.getString("NewRealmInitAction.error.cantInitOuStructure"), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(Collection args) {
        NewRealmInitWizardIterator iterator = new NewRealmInitWizardIterator();
        WizardDescriptor wizardDescriptor = new WizardDescriptor((WizardDescriptor.Iterator)iterator);
        iterator.setWizardDescriptor(wizardDescriptor);
        wizardDescriptor.setTitleFormat(new MessageFormat("{0} ({1})"));
        wizardDescriptor.setTitle(Messages.getString("action.NewRealmInitAction"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)wizardDescriptor);
        dialog.setIconImage(Utilities.loadImage((String)"org/openthinclient/console/icon.png", (boolean)true));
        dialog.setSize(830, 600);
        dialog.setPreferredSize(new Dimension(830, 600));
        dialog.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        dialog.setLocation((screenSize.width - dialog.getWidth()) / 2, (screenSize.height - dialog.getHeight()) / 2);
        dialog.setVisible(true);
        dialog.toFront();
        if (wizardDescriptor.getValue() == WizardDescriptor.FINISH_OPTION) {
            String baseDN = (String)wizardDescriptor.getProperty("oldSelectedBaseDN");
            LDAPConnectionDescriptor lcd = (LDAPConnectionDescriptor)wizardDescriptor.getProperty("connectionDescriptor");
            try {
                if (!baseDN.equals("")) {
                    String newLcdBaseDN = new LdapName(lcd.getBaseDN()).addAll(new LdapName(baseDN)).toString();
                    lcd.setBaseDN(newLcdBaseDN);
                }
                Object reg = wizardDescriptor.getProperty("registration");
                boolean register = (Boolean)reg;
                String description = (String)wizardDescriptor.getProperty("description");
                String newFolderName = (String)wizardDescriptor.getProperty("newFolderName");
                Object newOU = wizardDescriptor.getProperty("newFolderBox");
                boolean createNewOU = (Boolean)newOU;
                if (createNewOU) {
                    try {
                        this.createOU(newFolderName, LDAPDirectory.openEnv((LDAPConnectionDescriptor)lcd));
                    }
                    catch (DirectoryException e1) {
                        e1.printStackTrace();
                    }
                }
                if (newFolderName != null) {
                    lcd.setBaseDN(new LdapName(lcd.getBaseDN()).addAll(new LdapName("ou=" + newFolderName)).toString());
                }
                LdapContext ctx = lcd.createDirectoryFacade().createDirContext();
                try {
                    LDAPDirectory dir = LDAPDirectory.openEnv((LDAPConnectionDescriptor)lcd);
                    Realm realm = NewRealmInitCommand.initRealm(dir, description);
                    realm.setConnectionDescriptor(lcd);
                    realm.setValue("Serversettings.Hostname", realm.getConnectionDescriptor().getHostname());
                    Short s = new Short(realm.getConnectionDescriptor().getPortNumber());
                    realm.setValue("Serversettings.Portnumber", s.toString());
                    String schemaProviderName = wizardDescriptor.getProperty("schemaProviderName").toString();
                    if (schemaProviderName.equals("")) {
                        schemaProviderName = realm.getConnectionDescriptor().getHostname();
                    }
                    realm.setValue("Serversettings.SchemaProviderName", schemaProviderName);
                    dir = LDAPDirectory.openRealm((Realm)realm);
                    if (this.isBooleanOptionSet(wizardDescriptor, "initOUs")) {
                        NewRealmInitCommand.initOUs(ctx, dir);
                        if (this.isBooleanOptionSet(wizardDescriptor, "initAdmin")) {
                            NewRealmInitCommand.initAdmin(dir, realm, (String)wizardDescriptor.getProperty("adminName"), wizardDescriptor.getProperty("adminBaseDN").toString());
                        }
                    }
                    HTTPLdifImportAction.setEnableAsk(false);
                    HashSet<String> ldifs = new HashSet<String>();
                    if (this.isBooleanOptionSet(wizardDescriptor, "initLocation")) {
                        ldifs.add("locations");
                        this.initLocation(dir);
                    }
                    if (this.isBooleanOptionSet(wizardDescriptor, "initHwtypeAndDevices")) {
                        ldifs.add("hwtypes");
                        ldifs.add("devices");
                        this.initHwtype(dir, realm);
                    }
                    if (ldifs.size() > 0) {
                        HTTPLdifImportAction action = new HTTPLdifImportAction(lcd.getHostname());
                        action.importAllLdifList(ldifs, realm);
                    }
                    if (this.isBooleanOptionSet(wizardDescriptor, "createADSACIs")) {
                        ACLUtils aclUtils = new ACLUtils(ctx);
                        aclUtils.makeACSA("");
                        if (this.isBooleanOptionSet(wizardDescriptor, "enableSearchForAll")) {
                            aclUtils.enableSearchForAllUsers("");
                        }
                        if (this.isBooleanOptionSet(wizardDescriptor, "enableAdminAccess")) {
                            aclUtils.enableAdminUsers("");
                        }
                    }
                    Properties p = new Properties();
                    p.setProperty("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
                    p.setProperty("java.naming.provider.url", "jnp://" + schemaProviderName + ":1099");
                    InitialContext initialContext = new InitialContext(p);
                    try {
                        Remoted remoted = (Remoted)initialContext.lookup("RemotedBean/remote");
                        if (!remoted.dhcpReloadRealms()) {
                            ErrorManager.getDefault().notify(new Throwable("remoted.dhcpReloadRealms() failed"));
                        }
                    }
                    catch (InstanceNotFoundException e) {
                        ErrorManager.getDefault().notify((Throwable)e);
                    }
                    if (register) {
                        RealmManager.registerRealm(realm);
                    }
                }
                finally {
                    ctx.close();
                }
            }
            catch (Exception f) {
                String msg = Messages.getString("NewRealmInit.error.setup_realm_failed_error", f);
                ErrorManager.getDefault().annotate((Throwable)f, msg);
                ErrorManager.getDefault().notify((Throwable)f);
            }
        }
    }

    public boolean checkDeeply(Collection args) {
        return true;
    }
}

