/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console;

import org.openthinclient.console.Messages;

public class ValidateNames {
    public String validate(String name, Class className) {
        if (name.length() > 0) {
            switch (classEnum.valueOf(className.getSimpleName())) {
                case Client: {
                    return this.validateClientName(name);
                }
                case User: {
                    return this.validateUserName(name);
                }
            }
            return this.validateRest(name);
        }
        return Messages.getString("ValidateName.name.mandatory");
    }

    private String validateClientName(String name) {
        if (String.valueOf(name.charAt(0)).matches("[^a-zA-Z]")) {
            return Messages.getString("ValidateName.name.start");
        }
        if (name.matches(".*[^\\w|^.|^-].*")) {
            return Messages.getString("ValidateName.name.illegal");
        }
        if (name.matches(".*[.|-]{2}.*")) {
            return Messages.getString("ValidateName.name.symbol");
        }
        if (String.valueOf(name.charAt(name.length() - 1)).matches("[^\\w]")) {
            return Messages.getString("ValidateName.name.end");
        }
        if (name.length() < 2) {
            return Messages.getString("ValidateName.name.length.min");
        }
        if (name.length() > 64) {
            return Messages.getString("ValidateName.name.length.max");
        }
        return null;
    }

    private String validateUserName(String name) {
        if (!name.matches("[a-zA-Z_][a-zA-Z0-9._-]*[$]?")) {
            return Messages.getString("ValidateName.name.illegal");
        }
        if (name.length() > 32) {
            return Messages.getString("ValidateName.name.length.max");
        }
        return null;
    }

    private String validateRest(String name) {
        if (String.valueOf(name.charAt(0)).matches("[ #]")) {
            return Messages.getString("ValidateName.name.start");
        }
        if (!name.matches("[a-zA-Z0-9  {}\\[\\]/()#.:*&`'~|?@$\\^%_-]+")) {
            return Messages.getString("ValidateName.name.illegal");
        }
        if (String.valueOf(name.charAt(name.length() - 1)).matches("[ #]")) {
            return Messages.getString("ValidateName.name.end");
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum classEnum {
        Realm,
        Client,
        User,
        UserGroup,
        Application,
        ApplicationGroup,
        Device,
        Location,
        Printer,
        HardwareType;

    }
}

