/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console.nodes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.SwingUtilities;
import org.openide.ErrorManager;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openthinclient.console.Messages;
import org.openthinclient.console.nodes.OperationPendingNode;
import org.openthinclient.console.nodes.pkgmgr.PackageListNode;

public abstract class AbstractAsyncArrayChildren
extends Children.Keys {
    ChildRefresherThread crt;

    protected void addNotify() {
        this.refreshChildren();
    }

    public void refreshChildren() {
        if (null != this.crt && this.crt.isAlive()) {
            this.crt.setRefreshAgain(true);
        }
        this.crt = new ChildRefresherThread("Directory operation: " + this.getNode().getName());
        this.crt.start();
    }

    protected String getPendingMessage() {
        return Messages.getString("AbstractAsyncArrayChildren.loading");
    }

    protected abstract Collection asyncInitChildren();

    private final class ChildRefresherThread
    extends Thread {
        private boolean refreshAgain;

        ChildRefresherThread(String name) {
            super(name);
            ChildRefresherThread.yield();
            this.setPriority(1);
            this.refreshAgain = false;
        }

        public void setRefreshAgain(boolean stop) {
            this.refreshAgain = true;
        }

        public void run() {
            final Node[] pn = new Node[]{new OperationPendingNode(AbstractAsyncArrayChildren.this.getPendingMessage())};
            final CopyOnWriteArrayList tmpKeys = new CopyOnWriteArrayList();
            boolean isBadNode = AbstractAsyncArrayChildren.this.getNode() instanceof PackageListNode;
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        tmpKeys.add(pn);
                        AbstractAsyncArrayChildren.this.setKeys(tmpKeys);
                    }
                });
                Collection keys = Collections.EMPTY_LIST;
                if (!this.refreshAgain) {
                    keys = AbstractAsyncArrayChildren.this.asyncInitChildren();
                }
                int bufferSize = 4;
                Iterator i = keys.iterator();
                while (i.hasNext() && !this.refreshAgain) {
                    Object key = i.next();
                    tmpKeys.add(key);
                    int modu = keys.size() % 4;
                    if (tmpKeys.size() > modu && tmpKeys.size() % 4 != modu || isBadNode) continue;
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            AbstractAsyncArrayChildren.this.setKeys(tmpKeys);
                        }
                    });
                }
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        if (ChildRefresherThread.this.refreshAgain) {
                            ArrayList<Node[]> pnList = new ArrayList<Node[]>();
                            pnList.add(pn);
                            AbstractAsyncArrayChildren.this.setKeys(pnList);
                        } else {
                            tmpKeys.remove(pn);
                            AbstractAsyncArrayChildren.this.setKeys(tmpKeys);
                        }
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
    }
}

