/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console.nodes;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.levigo.util.swing.IconManager;
import com.levigo.util.swing.table.SunTableSorter;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.openide.ErrorManager;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.TopComponent;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.common.model.Realm;
import org.openthinclient.console.AbstractDetailView;
import org.openthinclient.console.ConsoleFrame;
import org.openthinclient.console.DetailViewProvider;
import org.openthinclient.console.DetailViewTopObject;
import org.openthinclient.console.Messages;
import org.openthinclient.console.NewAction;
import org.openthinclient.console.RefreshAction;
import org.openthinclient.console.Refreshable;
import org.openthinclient.console.SysLogAction;
import org.openthinclient.console.nodes.AbstractAsyncArrayChildren;
import org.openthinclient.console.nodes.DirObjectNode;
import org.openthinclient.console.nodes.ErrorNode;
import org.openthinclient.console.nodes.MyAbstractNode;
import org.openthinclient.console.util.GenericDirectoryObjectComparator;
import org.openthinclient.console.util.StringFilterTableModel;

public class DirObjectListNode
extends MyAbstractNode
implements DetailViewProvider,
Refreshable {
    public DirObjectListNode(Node node, Class key) {
        super((org.openide.nodes.Children)new Children(), (Lookup)new ProxyLookup(new Lookup[]{Lookups.fixed((Object[])new Object[]{key}), node.getLookup()}));
    }

    public Action[] getActions(boolean context) {
        if (this.getName().equalsIgnoreCase(Messages.getString("types.plural.Client"))) {
            if (this.isWritable()) {
                return new Action[]{SystemAction.get(NewAction.class), SystemAction.get(SysLogAction.class), null, SystemAction.get(RefreshAction.class)};
            }
            return new Action[]{SystemAction.get(SysLogAction.class), null, SystemAction.get(RefreshAction.class)};
        }
        if (this.getName().equalsIgnoreCase(Messages.getString("types.plural.UnrecognizedClient"))) {
            return new Action[]{SystemAction.get(RefreshAction.class)};
        }
        if (this.isWritable()) {
            return new Action[]{SystemAction.get(NewAction.class), null, SystemAction.get(RefreshAction.class)};
        }
        return new Action[]{SystemAction.get(RefreshAction.class)};
    }

    public boolean canCopy() {
        return false;
    }

    public boolean canDestroy() {
        return false;
    }

    public boolean canRename() {
        return false;
    }

    public Image getOpenedIcon(int type) {
        Class typeClass = (Class)this.getLookup().lookup(Class.class);
        return IconManager.getInstance(DetailViewProvider.class, (String)"icons").getImage("tree.list." + typeClass.getSimpleName());
    }

    public String getName() {
        Class typeClass = (Class)this.getLookup().lookup(Class.class);
        return Messages.getString("types.plural." + typeClass.getSimpleName());
    }

    public DetailView getDetailView() {
        return DetailView.getInstance();
    }

    public void refresh() {
        ((AbstractAsyncArrayChildren)this.getChildren()).refreshChildren();
    }

    static class DetailView
    extends AbstractDetailView {
        private static DetailView detailView;
        private JTextField queryField;
        private JTable objectsTable;
        private MouseAdapter listener;
        private JComponent mainComponent;
        private StringFilterTableModel tableModel;
        private SunTableSorter sts;
        private boolean readonly;
        private Class objectClass;
        private static List<DirObjectListNode> plns;

        DetailView() {
        }

        public static DetailView getInstance() {
            if (null == detailView) {
                detailView = new DetailView();
            }
            return detailView;
        }

        public JComponent getHeaderComponent() {
            this.getMainComponent();
            DefaultFormBuilder dfb = new DefaultFormBuilder(new FormLayout("p, 10dlu, r:p, 3dlu, f:p:g"));
            dfb.setDefaultDialogBorder();
            dfb.setLeadingColumnOffset(2);
            dfb.setColumn(3);
            this.queryField = new JTextField();
            dfb.append(Messages.getString("DirObjectListNode.filter"), (Component)this.queryField);
            dfb.nextLine();
            this.queryField.getDocument().addDocumentListener(new DocumentListener(){

                public void changedUpdate(DocumentEvent e) {
                    DetailView.this.tableModel.setFilter(DetailView.this.queryField.getText());
                }

                public void removeUpdate(DocumentEvent e) {
                    DetailView.this.tableModel.setFilter(DetailView.this.queryField.getText());
                }

                public void insertUpdate(DocumentEvent e) {
                    DetailView.this.tableModel.setFilter(DetailView.this.queryField.getText());
                }
            });
            dfb.add((Component)new JLabel(IconManager.getInstance(DetailViewProvider.class, (String)"icons").getIcon("tree." + this.objectClass.getSimpleName())), new CellConstraints(1, 1, 1, dfb.getRowCount(), CellConstraints.CENTER, CellConstraints.TOP));
            return dfb.getPanel();
        }

        public JComponent getMainComponent() {
            if (null == this.mainComponent) {
                this.objectsTable = new JTable();
                this.tableModel = new StringFilterTableModel();
                this.sts = new SunTableSorter((TableModel)this.tableModel);
                this.sts.setTableHeader(this.objectsTable.getTableHeader());
                this.objectsTable.setModel((TableModel)this.sts);
                this.objectsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                    public void valueChanged(ListSelectionEvent e) {
                        if (!e.getValueIsAdjusting()) {
                            DetailView.this.scrollToSelectedCell();
                        }
                    }
                });
                this.objectsTable.addComponentListener(new ComponentAdapter(){

                    public void componentResized(ComponentEvent e) {
                        DetailView.this.scrollToSelectedCell();
                    }

                    public void componentShown(ComponentEvent e) {
                        DetailView.this.scrollToSelectedCell();
                    }
                });
                this.mainComponent = new JScrollPane(this.objectsTable);
                this.mainComponent.setBackground(UIManager.getColor("TextField.background"));
                this.mainComponent.setBorder(BorderFactory.createEmptyBorder());
            }
            return this.mainComponent;
        }

        protected void scrollToSelectedCell() {
            if (!this.objectsTable.getSelectionModel().isSelectionEmpty()) {
                Rectangle cellRect = this.objectsTable.getCellRect(this.objectsTable.getSelectedRow(), this.objectsTable.getSelectedColumn(), true);
                this.objectsTable.scrollRectToVisible(cellRect);
            }
        }

        public void init(Node[] selection, TopComponent tc) {
            if (null != this.queryField) {
                this.queryField.setText("");
            }
            if (null != selection) {
                for (Node node : selection) {
                    if (!(node instanceof DirObjectListNode)) continue;
                    this.setDirObjectList((DirObjectListNode)node, tc);
                    break;
                }
            }
        }

        private void setDirObjectList(final DirObjectListNode dol, TopComponent tc) {
            this.getMainComponent();
            this.objectClass = (Class)dol.getLookup().lookup(Class.class);
            this.tableModel.setTableModel(new DirObjectTableModel(dol, this.objectClass));
            this.sts.setSortingStatus(0, 1);
            boolean isIn = false;
            for (DirObjectListNode ref : plns) {
                if (!ref.getName().equalsIgnoreCase(dol.getName())) continue;
                isIn = true;
            }
            if (!isIn) {
                if (plns.size() > 0) {
                    this.objectsTable.removeMouseListener(this.objectsTable.getMouseListeners()[this.objectsTable.getMouseListeners().length - 1]);
                    plns.remove(plns.size() - 1);
                }
                if (null != tc && tc instanceof ExplorerManager.Provider) {
                    this.listener = new MouseAdapter(){

                        public void mouseClicked(MouseEvent e) {
                            DetailView.this.objectsTable.setComponentPopupMenu(null);
                            if (DetailView.this.objectsTable.getSelectedRow() < 0) {
                                return;
                            }
                            if (e.getButton() == 1 && e.getClickCount() > 1) {
                                DetailView.this.handleMultipleClicks();
                            }
                        }

                        public void mouseReleased(MouseEvent e) {
                            DetailView.this.objectsTable.setComponentPopupMenu(null);
                            if (DetailView.this.objectsTable.getSelectedRow() < 0) {
                                return;
                            }
                            DetailView.this.addPopupMenu(e, dol);
                            if (e.getButton() == 1) {
                                DetailView.this.organizeViews(dol);
                            }
                        }
                    };
                    plns.add(dol);
                    this.objectsTable.addMouseListener((MouseListener)WeakListeners.create(MouseListener.class, (EventListener)this.listener, (Object)this.objectsTable));
                }
            }
        }

        private void organizeViews(DirObjectListNode dol) {
            if (this.objectsTable.getSelectedRows().length > 1) {
                ConsoleFrame.getINSTANCE().hideObjectDetails();
            } else {
                this.showDetails((Node)this.objectsTable.getModel().getValueAt(this.objectsTable.getSelectedRow(), -1), dol.getChildren().getNodes().length);
            }
        }

        private void openDefaultAction(final Node nodeAtRow) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (null != nodeAtRow.getPreferredAction()) {
                        nodeAtRow.getPreferredAction().actionPerformed(new ActionEvent(nodeAtRow, 1, "open"));
                    }
                }
            });
        }

        private void handleMultipleClicks() {
            Node nodeAtRow = (Node)this.objectsTable.getModel().getValueAt(this.objectsTable.getSelectedRow(), -1);
            if (null != nodeAtRow) {
                this.openDefaultAction(nodeAtRow);
            }
        }

        public void addPopupMenu(MouseEvent e, DirObjectListNode dol) {
            if (this.objectsTable.getSelectedRows().length == 1 && e.getButton() == 3) {
                this.handleSingle(e, dol);
            }
            if (this.objectsTable.getSelectedRows().length > 1) {
                this.handleList(e);
            }
        }

        public void handleSingle(MouseEvent e, DirObjectListNode dol) {
            int dataRow = this.objectsTable.rowAtPoint(e.getPoint());
            if (dataRow < 0) {
                return;
            }
            Node nodeAtRow = (Node)this.objectsTable.getModel().getValueAt(dataRow, -1);
            int row = this.objectsTable.rowAtPoint(e.getPoint());
            this.objectsTable.setRowSelectionInterval(row, row);
            this.objectsTable.setComponentPopupMenu(null);
            this.addNewPopUpMenu(nodeAtRow);
            if (null != this.objectsTable.getComponentPopupMenu()) {
                this.objectsTable.getComponentPopupMenu().show(this.objectsTable, e.getX(), e.getY());
            }
            if (null != nodeAtRow) {
                this.showDetails(nodeAtRow, dol.getChildren().getNodes().length);
            }
        }

        public void handleList(MouseEvent e) {
            this.objectsTable.setComponentPopupMenu(null);
            Object[] selectedNodes = new Node[this.objectsTable.getSelectedRows().length];
            int n = 0;
            for (int i : this.objectsTable.getSelectedRows()) {
                selectedNodes[n] = (Node)this.objectsTable.getModel().getValueAt(i, -1);
                ++n;
            }
            Node nodeAtRow = selectedNodes[0];
            if (null == nodeAtRow) {
                return;
            }
            JPopupMenu popupMenu = Utilities.actionsToPopup((Action[])nodeAtRow.getActions(false), (Lookup)Lookups.fixed((Object[])selectedNodes));
            this.objectsTable.setComponentPopupMenu(popupMenu);
        }

        private void addNewPopUpMenu(Node nodeAtRow) {
            Action[] actions = nodeAtRow.getActions(false);
            JPopupMenu popupMenu = Utilities.actionsToPopup((Action[])actions, (Lookup)Lookups.singleton((Object)nodeAtRow));
            this.objectsTable.setComponentPopupMenu(popupMenu);
        }

        private void showDetails(final Node nodeAtRow, final int nodeLength) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Node[] activate = new Node[]{nodeAtRow};
                    TopComponent newComp = new TopComponent();
                    newComp.setActivatedNodes(activate);
                    DetailViewTopObject.getDefault().nodeSelectionChanged(null, newComp);
                    ConsoleFrame.getINSTANCE().showObjectDetails(nodeLength);
                }
            });
        }

        public void setReadonly(boolean readonly) {
            this.readonly = readonly;
        }

        public boolean isReadonly() {
            return this.readonly;
        }

        public String getTitle() {
            return null;
        }

        static {
            plns = new ArrayList<DirObjectListNode>();
        }

        private static class DirObjectTableModel
        extends AbstractTableModel
        implements NodeListener {
            private static final Pattern SPLIT_PATTERN = Pattern.compile("\\s*,\\s*");
            private final Class objectClass;
            private final Map<String, Method> getters = new HashMap<String, Method>();
            private final String[] columnNames;
            private final String[] getterNames;
            private final DirObjectListNode dol;

            public DirObjectTableModel(DirObjectListNode dol, Class objectClass) {
                this.dol = dol;
                this.objectClass = objectClass;
                String tableDesc = Messages.getString("table." + objectClass.getSimpleName());
                String[] splitDesc = SPLIT_PATTERN.split(tableDesc);
                if (splitDesc.length % 2 != 0) {
                    ErrorManager.getDefault().log(16, "Table description for " + objectClass + " is malformed");
                }
                this.columnNames = new String[splitDesc.length / 2];
                this.getterNames = new String[splitDesc.length / 2];
                int i = 0;
                int j = 0;
                while (i < splitDesc.length - 1) {
                    this.columnNames[j] = splitDesc[i++];
                    this.getterNames[j++] = splitDesc[i++];
                }
                dol.addNodeListener((NodeListener)WeakListeners.create(NodeListener.class, (EventListener)((Object)this), (Object)dol));
            }

            public Object getValueAt(int row, int column) {
                Node[] nodes = this.dol.getChildren().getNodes();
                if (nodes.length <= row) {
                    return "";
                }
                DirectoryObject o = (DirectoryObject)nodes[row].getLookup().lookup(DirectoryObject.class);
                if (column == -1) {
                    return nodes[row];
                }
                if (null == o) {
                    return "...";
                }
                String getterName = this.getterNames[column];
                Method getter = this.getters.get(getterName);
                if (null == getter) {
                    try {
                        getter = this.objectClass.getMethod(getterName, new Class[0]);
                        this.getters.put(getterName, getter);
                    }
                    catch (Exception e) {
                        ErrorManager.getDefault().notify((Throwable)e);
                        return "<" + e.getLocalizedMessage() + ">";
                    }
                }
                try {
                    return getter.invoke((Object)o, new Object[0]);
                }
                catch (Exception e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                    return "<" + e.getLocalizedMessage() + ">";
                }
            }

            Node getNodeAtRow(int row) {
                Node[] nodes = this.dol.getChildren().getNodes();
                if (nodes.length <= row) {
                    return null;
                }
                return nodes[row];
            }

            public int getColumnCount() {
                return this.columnNames.length;
            }

            public String getColumnName(int columnIndex) {
                return this.columnNames[columnIndex];
            }

            public int getRowCount() {
                return this.dol.getChildren().getNodes().length;
            }

            public void childrenAdded(NodeMemberEvent ev) {
                this.propagateChangeOnEDT();
            }

            public void childrenRemoved(NodeMemberEvent ev) {
                this.propagateChangeOnEDT();
            }

            public void childrenReordered(NodeReorderEvent ev) {
                this.propagateChangeOnEDT();
            }

            public void nodeDestroyed(NodeEvent ev) {
                this.propagateChangeOnEDT();
            }

            public void propertyChange(PropertyChangeEvent evt) {
                this.propagateChangeOnEDT();
            }

            private void propagateChangeOnEDT() {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        DirObjectTableModel.this.fireTableDataChanged();
                    }
                });
            }
        }
    }

    static class Children
    extends AbstractAsyncArrayChildren {
        Children() {
        }

        protected Collection asyncInitChildren() {
            try {
                Realm realm = (Realm)this.getNode().getLookup().lookup(Realm.class);
                Class typeClass = (Class)this.getNode().getLookup().lookup(Class.class);
                ArrayList list = new ArrayList(realm.getDirectory().list(typeClass));
                Collections.sort(list, GenericDirectoryObjectComparator.getInstance());
                return list;
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify((Throwable)e);
                this.add(new Node[]{new ErrorNode(Messages.getString("DirObjectListNode.cantDisplay"), e)});
                return Collections.EMPTY_LIST;
            }
        }

        protected Node[] createNodes(Object key) {
            if (key instanceof Node[]) {
                return (Node[])key;
            }
            return new Node[]{new DirObjectNode(this.getNode(), (DirectoryObject)key)};
        }
    }
}

