/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console.nodes;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.loaders.DataFolder;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Utilities;
import org.openthinclient.common.model.Application;
import org.openthinclient.common.model.ApplicationGroup;
import org.openthinclient.common.model.Client;
import org.openthinclient.common.model.Device;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.common.model.HardwareType;
import org.openthinclient.common.model.Location;
import org.openthinclient.common.model.Printer;
import org.openthinclient.common.model.Realm;
import org.openthinclient.common.model.UnrecognizedClient;
import org.openthinclient.common.model.User;
import org.openthinclient.common.model.UserGroup;
import org.openthinclient.console.MainTreeTopComponent;
import org.openthinclient.console.Messages;
import org.openthinclient.console.Refreshable;
import org.openthinclient.console.nodes.DirObjectListNode;
import org.openthinclient.console.nodes.MyAbstractNode;
import org.openthinclient.console.wizards.newdirobject.NewDirObjectWizardIterator;
import org.openthinclient.ldap.DirectoryException;

class DirObjectsNode
extends MyAbstractNode {
    public static Class[] OBJECT_CLASSES = new Class[]{Client.class, User.class, UserGroup.class, Application.class, ApplicationGroup.class, Device.class, Location.class, Printer.class, HardwareType.class, UnrecognizedClient.class};

    public DirObjectsNode(Node parent) {
        super((Children)new Children.Array(), parent.getLookup());
    }

    public static Node[] createChildren(Node parent) {
        Node[] children = new Node[OBJECT_CLASSES.length];
        for (int i = 0; i < OBJECT_CLASSES.length; ++i) {
            children[i] = new DirObjectListNode(parent, OBJECT_CLASSES[i]);
        }
        return children;
    }

    public static class AddDirObjectAction
    extends AbstractAction {
        public AddDirObjectAction() {
            super(Messages.getString("action." + AddDirObjectAction.class.getSimpleName()));
        }

        public AddDirObjectAction(DataFolder df) {
            super(Messages.getString("action." + AddDirObjectAction.class.getSimpleName()));
        }

        public void actionPerformed(ActionEvent e) {
            Node[] nodes;
            NewDirObjectWizardIterator iterator = new NewDirObjectWizardIterator();
            WizardDescriptor wizardDescriptor = new WizardDescriptor((WizardDescriptor.Iterator)iterator);
            wizardDescriptor.setTitleFormat(new MessageFormat("{0} ({1})"));
            wizardDescriptor.setTitle(Messages.getString("action." + AddDirObjectAction.class.getSimpleName()));
            Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)wizardDescriptor);
            dialog.setIconImage(Utilities.loadImage((String)"org/openthinclient/console/icon.png", (boolean)true));
            dialog.setVisible(true);
            dialog.toFront();
            if (wizardDescriptor.getValue() == WizardDescriptor.FINISH_OPTION) {
                DirectoryObject dirObject = (DirectoryObject)wizardDescriptor.getProperty("dirObject");
                Realm realm = (Realm)wizardDescriptor.getProperty("realm");
                try {
                    realm.getDirectory().save((Object)dirObject);
                }
                catch (DirectoryException e1) {
                    ErrorManager.getDefault().annotate((Throwable)e1, 4096, Messages.getString("error.AddDirObjectFailed"), null, null, null);
                    ErrorManager.getDefault().notify((Throwable)e1);
                }
            }
            for (Node node : nodes = MainTreeTopComponent.getDefault().getActivatedNodes()) {
                if (!(node instanceof Refreshable)) continue;
                ((Refreshable)node).refresh();
            }
        }
    }
}

