/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console.nodes;

import com.levigo.util.swing.IconManager;
import java.awt.Dialog;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Utilities;
import org.openthinclient.console.DetailViewProvider;
import org.openthinclient.console.Messages;
import org.openthinclient.console.nodes.DirectoryNode;
import org.openthinclient.console.nodes.ErrorNode;
import org.openthinclient.console.wizards.registerdirectory.RegisterDirectoryWizardIterator;
import org.openthinclient.ldap.DirectoryException;
import org.openthinclient.ldap.LDAPConnectionDescriptor;

public class DirectoriesNode
extends FilterNode {
    private static LDAPConnectionDescriptor getConnectionDescriptor(Node node) throws IOException, ClassNotFoundException, DirectoryException {
        InstanceCookie ck = (InstanceCookie)node.getCookie(InstanceCookie.class);
        if (ck == null) {
            throw new IllegalStateException(Messages.getString("DirectoriesNode.bogus") + node.getLookup().lookup(FileObject.class));
        }
        return (LDAPConnectionDescriptor)ck.instanceCreate();
    }

    public DirectoriesNode() throws DataObjectNotFoundException {
        super(DataObject.find((FileObject)Repository.getDefault().getDefaultFileSystem().getRoot().getFileObject("Directories")).getNodeDelegate());
        this.setChildren((Children)new RootChildren(this.getOriginal()));
        this.disableDelegation(8);
    }

    public Action[] getActions(boolean popup) {
        DataFolder df = (DataFolder)this.getLookup().lookup(DataFolder.class);
        return new Action[]{new RegisterDirectoryAction(df)};
    }

    public String getName() {
        return Messages.getString("node." + ((Object)((Object)this)).getClass().getSimpleName());
    }

    public Image getIcon(int type) {
        return this.getOpenedIcon(type);
    }

    public Image getOpenedIcon(int type) {
        return IconManager.getInstance(DetailViewProvider.class, (String)"icons").getImage("tree." + ((Object)((Object)this)).getClass().getSimpleName());
    }

    public static class RegisterDirectoryAction
    extends AbstractAction {
        private DataFolder folder;

        public RegisterDirectoryAction() {
            super(Messages.getString("action." + RegisterDirectoryAction.class.getSimpleName()));
        }

        public RegisterDirectoryAction(DataFolder df) {
            super(Messages.getString("action." + RegisterDirectoryAction.class.getSimpleName()));
            this.folder = df;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent ae) {
            RegisterDirectoryWizardIterator iterator = new RegisterDirectoryWizardIterator();
            WizardDescriptor wizardDescriptor = new WizardDescriptor((WizardDescriptor.Iterator)iterator);
            wizardDescriptor.setTitleFormat(new MessageFormat("{0} ({1})"));
            wizardDescriptor.setTitle(Messages.getString("action." + RegisterDirectoryAction.class.getSimpleName()));
            Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)wizardDescriptor);
            dialog.setIconImage(Utilities.loadImage((String)"org/openthinclient/console/icon.png", (boolean)true));
            dialog.setVisible(true);
            dialog.toFront();
            if (wizardDescriptor.getValue() == WizardDescriptor.FINISH_OPTION) {
                String baseName;
                LDAPConnectionDescriptor cd = (LDAPConnectionDescriptor)wizardDescriptor.getProperty("connectionDescriptor");
                assert (null != cd);
                FileObject fld = this.folder.getPrimaryFile();
                if (fld.getFileObject(baseName = "DirectoryEnv-" + cd.hashCode(), "ser") != null) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)Messages.getString("DirectoriesNode.alreadyRegistered"), 2));
                    return;
                }
                try {
                    FileObject writeTo = fld.createData(baseName, "ser");
                    FileLock lock = writeTo.lock();
                    try {
                        ObjectOutputStream str = new ObjectOutputStream(writeTo.getOutputStream(lock));
                        try {
                            str.writeObject(cd);
                        }
                        finally {
                            str.close();
                        }
                    }
                    finally {
                        lock.releaseLock();
                    }
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().notify((Throwable)ioe);
                }
            }
        }
    }

    private static class RootChildren
    extends FilterNode.Children {
        RootChildren(Node folderNode) {
            super(folderNode);
        }

        protected Node[] createNodes(Object key) {
            Node n = (Node)key;
            try {
                LDAPConnectionDescriptor cd = DirectoriesNode.getConnectionDescriptor(n);
                return new Node[]{new DirectoryNode(n, this.getNode(), cd)};
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify((Throwable)e);
                return new Node[]{new ErrorNode(Messages.getString("error.OpenRealmFailed"), e)};
            }
        }
    }
}

