/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console.nodes;

import com.levigo.util.swing.IconManager;
import java.awt.Image;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.ldap.LdapContext;
import javax.swing.Action;
import org.openide.ErrorManager;
import org.openide.actions.DeleteAction;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openthinclient.console.DetailView;
import org.openthinclient.console.DetailViewProvider;
import org.openthinclient.console.EditAction;
import org.openthinclient.console.Messages;
import org.openthinclient.console.nodes.AbstractAsyncArrayChildren;
import org.openthinclient.console.nodes.ErrorNode;
import org.openthinclient.console.nodes.PartitionNode;
import org.openthinclient.console.nodes.views.DirectoryEntryDetailView;
import org.openthinclient.ldap.LDAPConnectionDescriptor;

public class DirectoryNode
extends FilterNode
implements DetailViewProvider {
    public DirectoryNode(Node dataNode, Node parent, LDAPConnectionDescriptor cd) {
        super(dataNode, (org.openide.nodes.Children)new Children(), (Lookup)new ProxyLookup(new Lookup[]{Lookups.fixed((Object[])new Object[]{cd}), parent.getLookup()}));
        this.disableDelegation(8);
    }

    public DirectoryNode(LDAPConnectionDescriptor connectionDescriptor) {
        this(Node.EMPTY, Node.EMPTY, connectionDescriptor);
    }

    protected PartitionNode createChild(LDAPConnectionDescriptor lcd, String rdn) {
        return new PartitionNode((Node)this, lcd, rdn);
    }

    public String getName() {
        LDAPConnectionDescriptor cd = (LDAPConnectionDescriptor)this.getLookup().lookup(LDAPConnectionDescriptor.class);
        return cd.getLDAPUrl();
    }

    public String getShortDescription() {
        return ((LDAPConnectionDescriptor)this.getLookup().lookup(LDAPConnectionDescriptor.class)).getLDAPUrl();
    }

    public Action[] getActions(boolean context) {
        return new Action[]{SystemAction.get(DeleteAction.class)};
    }

    public DetailView getDetailView() {
        return new DirectoryEntryDetailView();
    }

    public Image getIcon(int type) {
        return this.getOpenedIcon(type);
    }

    public Image getOpenedIcon(int type) {
        return IconManager.getInstance(DetailViewProvider.class, (String)"icons").getImage("tree." + this.getClass().getSimpleName());
    }

    public SystemAction getDefaultAction() {
        return SystemAction.get(EditAction.class);
    }

    public LDAPConnectionDescriptor getConnectionDescriptor() {
        return (LDAPConnectionDescriptor)this.getLookup().lookup(LDAPConnectionDescriptor.class);
    }

    static class Children
    extends AbstractAsyncArrayChildren {
        Children() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Collection asyncInitChildren() {
            try {
                LDAPConnectionDescriptor lcd = ((DirectoryNode)this.getNode()).getConnectionDescriptor();
                ArrayList<String> partitions = new ArrayList<String>();
                LdapContext ctx = lcd.createDirectoryFacade().createDirContext();
                try {
                    Attributes a = ctx.getAttributes("", new String[]{"namingContexts"});
                    Attribute namingContexts = a.get("namingContexts");
                    if (null == namingContexts) {
                        throw new NamingException(Messages.getString("DirectoryNode.noPartitionList"));
                    }
                    NamingEnumeration<?> allAttributes = namingContexts.getAll();
                    while (allAttributes.hasMore()) {
                        partitions.add(allAttributes.next().toString());
                    }
                }
                finally {
                    if (null != ctx) {
                        ctx.close();
                    }
                }
                return partitions;
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify((Throwable)e);
                this.add(new Node[]{new ErrorNode(Messages.getString("DirectoryNode.cantDisplay"), e)});
                return Collections.EMPTY_LIST;
            }
        }

        protected Node[] createNodes(Object key) {
            LDAPConnectionDescriptor lcd = ((DirectoryNode)this.getNode()).getConnectionDescriptor();
            return new Node[]{((DirectoryNode)this.getNode()).createChild(lcd, (String)key)};
        }
    }
}

