/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console.nodes;

import com.levigo.util.swing.IconManager;
import java.awt.Image;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import javax.swing.Action;
import org.apache.log4j.Logger;
import org.openide.ErrorManager;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openthinclient.common.model.Realm;
import org.openthinclient.console.DeleteRealmAction;
import org.openthinclient.console.DetailView;
import org.openthinclient.console.DetailViewProvider;
import org.openthinclient.console.DisconnectEnvironmentAction;
import org.openthinclient.console.EditAction;
import org.openthinclient.console.EditorProvider;
import org.openthinclient.console.HTTPLdifImportAction;
import org.openthinclient.console.Messages;
import org.openthinclient.console.RefreshAction;
import org.openthinclient.console.Refreshable;
import org.openthinclient.console.ServerLogAction;
import org.openthinclient.console.nodes.DirObjectsNode;
import org.openthinclient.console.nodes.DirectoryViewNode;
import org.openthinclient.console.nodes.ErrorNode;
import org.openthinclient.console.nodes.MyAbstractNode;
import org.openthinclient.console.nodes.pkgmgr.PackageManagementNode;
import org.openthinclient.console.nodes.views.DirObjectDetailView;
import org.openthinclient.console.nodes.views.DirObjectEditor;
import org.openthinclient.ldap.DirectoryException;
import org.openthinclient.ldap.TypeMapping;

public class RealmNode
extends MyAbstractNode
implements DetailViewProvider,
EditorProvider,
Refreshable {
    public static Class[] CHILD_NODE_CLASSES = new Class[]{DirObjectsNode.class};
    private static final Logger logger = Logger.getLogger(TypeMapping.class);

    public RealmNode(Realm realm, boolean hideChildren) {
        super((Children)(hideChildren ? Children.LEAF : new Children.Array()), Lookups.fixed((Object[])new Object[]{realm}));
        if (!hideChildren) {
            this.createChildren(Node.EMPTY, realm);
        }
    }

    public RealmNode(Node parent, Realm realm) {
        super((Children)new Children.Array(), (Lookup)new ProxyLookup(new Lookup[]{Lookups.fixed((Object[])new Object[]{realm}), parent.getLookup()}));
        this.createChildren(parent, realm);
        RealmNode.updateOnLdifs(realm);
    }

    private void createChildren(Node parent, Realm realm) {
        ArrayList<Object> children = new ArrayList<Object>();
        try {
            for (Node node : DirObjectsNode.createChildren((Node)this)) {
                children.add(node);
            }
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify((Throwable)e);
            children.add((Object)new ErrorNode(Messages.getString("error.ChildCreationFailed.dirObjects"), e));
        }
        try {
            children.add(new DirectoryViewNode(parent, realm.getConnectionDescriptor(), ""));
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify((Throwable)e);
            children.add((Object)new ErrorNode(Messages.getString("error.ChildCreationFailed.dirView"), e));
        }
        try {
            children.add(new PackageManagementNode((Node)this));
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify((Throwable)e);
            children.add((Object)new ErrorNode(Messages.getString("error.ChildCreationFailed.pkgMgr"), e));
        }
        Children.Array c = new Children.Array();
        c.add(children.toArray(new Node[children.size()]));
        this.setChildren((Children)c);
    }

    public String getName() {
        Realm realm = (Realm)this.getLookup().lookup(Realm.class);
        if (null != realm.getDescription()) {
            return realm.getDescription();
        }
        String base = realm.getConnectionDescriptor().getBaseDN();
        int idx = base.indexOf(44);
        if (idx > 0) {
            base = base.substring(0, idx);
        }
        if ((idx = base.lastIndexOf(61)) < 0) {
            return "???";
        }
        return base.substring(idx + 1);
    }

    public String getShortDescription() {
        return ((Realm)this.getLookup().lookup(Realm.class)).getDn();
    }

    public Action[] getActions(boolean context) {
        if (this.isAdmin()) {
            return new Action[]{SystemAction.get(EditAction.class), SystemAction.get(ServerLogAction.class), SystemAction.get(DisconnectEnvironmentAction.class), SystemAction.get(DeleteRealmAction.class), null, SystemAction.get(RefreshAction.class)};
        }
        if (this.isWritable()) {
            return new Action[]{SystemAction.get(EditAction.class), SystemAction.get(ServerLogAction.class), SystemAction.get(DisconnectEnvironmentAction.class), null, SystemAction.get(RefreshAction.class)};
        }
        return new Action[]{SystemAction.get(ServerLogAction.class), SystemAction.get(DisconnectEnvironmentAction.class), null, SystemAction.get(RefreshAction.class)};
    }

    public DetailView getDetailView() {
        return new DirObjectDetailView();
    }

    public Image getIcon(int type) {
        return this.getOpenedIcon(type);
    }

    public Image getOpenedIcon(int type) {
        return IconManager.getInstance(DetailViewProvider.class, (String)"icons").getImage("tree." + this.getClass().getSimpleName());
    }

    public SystemAction getDefaultAction() {
        return SystemAction.get(EditAction.class);
    }

    public DetailView getEditor() {
        return new DirObjectEditor();
    }

    public void refresh() {
        Realm realm = (Realm)this.getLookup().lookup(Realm.class);
        try {
            realm.refresh();
            for (Node node : this.getChildren().getNodes()) {
                if (!(node instanceof Refreshable)) continue;
                ((Refreshable)node).refresh();
            }
            this.fireCookieChange();
        }
        catch (DirectoryException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    public static void updateOnLdifs(Realm realm) {
        try {
            realm.getDirectory().refresh((Object)realm);
        }
        catch (DirectoryException e) {
            logger.error((Object)"Could not import", (Throwable)e);
            ErrorManager.getDefault().annotate((Throwable)e, "Could not import");
            ErrorManager.getDefault().notify((Throwable)e);
            e.printStackTrace();
        }
        try {
            HTTPLdifImportAction action = new HTTPLdifImportAction(realm.getConnectionDescriptor().getHostname());
            if (HTTPLdifImportAction.isEnableAsk()) {
                action.importAllLdifFolder(null, realm);
            }
            HTTPLdifImportAction.setEnableAsk(true);
        }
        catch (MalformedURLException e) {
            logger.error((Object)"Could not import", (Throwable)e);
            ErrorManager.getDefault().annotate((Throwable)e, "Could not import");
            ErrorManager.getDefault().notify((Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)"Could not import", (Throwable)e);
            ErrorManager.getDefault().annotate((Throwable)e, "Could not import");
            ErrorManager.getDefault().notify((Throwable)e);
            e.printStackTrace();
        }
    }
}

