/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console.nodes;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.levigo.util.swing.IconManager;
import com.levigo.util.swing.table.SunTableSorter;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import java.util.regex.Pattern;
import javax.naming.CommunicationException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;
import org.openide.ErrorManager;
import org.openide.explorer.ExplorerManager;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;
import org.openthinclient.common.directory.LDAPDirectory;
import org.openthinclient.common.model.Realm;
import org.openthinclient.console.AbstractDetailView;
import org.openthinclient.console.AddRealmAction;
import org.openthinclient.console.DetailViewProvider;
import org.openthinclient.console.HTTPLdifImportAction;
import org.openthinclient.console.Messages;
import org.openthinclient.console.NewRealmInitAction;
import org.openthinclient.console.RealmManager;
import org.openthinclient.console.nodes.AbstractAsyncArrayChildren;
import org.openthinclient.console.nodes.ErrorNode;
import org.openthinclient.console.nodes.MyAbstractNode;
import org.openthinclient.console.nodes.RealmNode;
import org.openthinclient.console.util.GenericDirectoryObjectComparator;
import org.openthinclient.console.util.StringFilterTableModel;
import org.openthinclient.ldap.DirectoryException;
import org.openthinclient.ldap.LDAPConnectionDescriptor;

public class RealmsNode
extends MyAbstractNode {
    private static final Logger logger = Logger.getLogger(RealmsNode.class);

    public RealmsNode() throws DataObjectNotFoundException {
        super((org.openide.nodes.Children)new Children());
        RealmManager.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeevent) {
                ((AbstractAsyncArrayChildren)RealmsNode.this.getChildren()).refreshChildren();
            }
        });
    }

    public Action[] getActions(boolean popup) {
        return new Action[]{new NewRealmInitAction(), new AddRealmAction()};
    }

    public String getName() {
        return Messages.getString("node." + ((Object)((Object)this)).getClass().getSimpleName());
    }

    public boolean canRename() {
        return false;
    }

    public Image getIcon(int type) {
        return this.getOpenedIcon(type);
    }

    public Image getOpenedIcon(int type) {
        return IconManager.getInstance(DetailViewProvider.class, (String)"icons").getImage("tree." + ((Object)((Object)this)).getClass().getSimpleName());
    }

    public static void updateOnLdifs(Realm realm) throws IOException {
        HTTPLdifImportAction action = new HTTPLdifImportAction(realm.getConnectionDescriptor().getHostname());
        if (HTTPLdifImportAction.isEnableAsk()) {
            action.importAllLdifFolder(null, realm);
        }
        HTTPLdifImportAction.setEnableAsk(true);
    }

    public DetailView getDetailView() {
        return DetailView.getInstance();
    }

    public static class DetailView
    extends AbstractDetailView {
        private static DetailView detailView;
        private JTextField queryField;
        private JTable objectsTable;
        private MouseAdapter listener;
        private JComponent mainComponent;
        private StringFilterTableModel tableModel;
        private SunTableSorter sts;
        private boolean readonly;
        private Class objectClass;
        private static List<RealmsNode> realmsList;

        public static DetailView getInstance() {
            if (null == detailView) {
                detailView = new DetailView();
            }
            return detailView;
        }

        public JComponent getHeaderComponent() {
            this.getMainComponent();
            DefaultFormBuilder dfb = new DefaultFormBuilder(new FormLayout("p, 10dlu, r:p, 3dlu, f:p:g"));
            dfb.setDefaultDialogBorder();
            dfb.setLeadingColumnOffset(2);
            dfb.setColumn(3);
            this.queryField = new JTextField();
            dfb.append(Messages.getString("DirObjectListNode.filter"), (Component)this.queryField);
            dfb.nextLine();
            this.queryField.getDocument().addDocumentListener(new DocumentListener(){

                public void changedUpdate(DocumentEvent e) {
                    DetailView.this.tableModel.setFilter(DetailView.this.queryField.getText());
                }

                public void removeUpdate(DocumentEvent e) {
                    DetailView.this.tableModel.setFilter(DetailView.this.queryField.getText());
                }

                public void insertUpdate(DocumentEvent e) {
                    DetailView.this.tableModel.setFilter(DetailView.this.queryField.getText());
                }
            });
            dfb.add((Component)new JLabel(IconManager.getInstance(DetailViewProvider.class, (String)"icons").getIcon("tree.RealmNode")), new CellConstraints(1, 1, 1, dfb.getRowCount(), CellConstraints.CENTER, CellConstraints.TOP));
            return dfb.getPanel();
        }

        public JComponent getMainComponent() {
            if (null == this.mainComponent) {
                this.objectsTable = new JTable();
                this.tableModel = new StringFilterTableModel();
                this.sts = new SunTableSorter((TableModel)this.tableModel);
                this.sts.setTableHeader(this.objectsTable.getTableHeader());
                this.objectsTable.setModel((TableModel)this.sts);
                this.mainComponent = new JScrollPane(this.objectsTable);
                this.mainComponent.setBackground(UIManager.getColor("TextField.background"));
                this.mainComponent.setBorder(BorderFactory.createEmptyBorder());
            }
            return this.mainComponent;
        }

        public void init(Node[] selection, TopComponent tc) {
            if (null != this.queryField) {
                this.queryField.setText("");
            }
            if (null != selection) {
                for (Node node : selection) {
                    if (!(node instanceof RealmsNode)) continue;
                    this.setDirObjectList((RealmsNode)node, tc);
                    break;
                }
            }
        }

        private void setDirObjectList(RealmsNode rnode, final TopComponent tc) {
            this.getMainComponent();
            this.objectClass = Realm.class;
            this.tableModel.setTableModel(new DirObjectTableModel(rnode, this.objectClass));
            this.sts.setSortingStatus(0, 1);
            boolean isIn = false;
            for (RealmsNode ref : realmsList) {
                if (!ref.getName().equalsIgnoreCase(rnode.getName())) continue;
                isIn = true;
            }
            if (!isIn) {
                if (realmsList.size() > 0) {
                    this.objectsTable.removeMouseListener(this.objectsTable.getMouseListeners()[this.objectsTable.getMouseListeners().length - 1]);
                    realmsList.remove(realmsList.size() - 1);
                }
                if (null != tc && tc instanceof ExplorerManager.Provider) {
                    this.listener = new MouseAdapter(){

                        public void mouseClicked(MouseEvent e) {
                            if (e.getClickCount() > 1) {
                                int selectedRow = DetailView.this.objectsTable.getSelectedRow();
                                if (selectedRow < 0) {
                                    return;
                                }
                                final RealmNode nodeAtRow = (RealmNode)DetailView.this.objectsTable.getModel().getValueAt(selectedRow, -1);
                                if (null != nodeAtRow) {
                                    try {
                                        ((ExplorerManager.Provider)tc).getExplorerManager().setSelectedNodes(new Node[]{nodeAtRow});
                                        if (e.getClickCount() > 1) {
                                            SwingUtilities.invokeLater(new Runnable(){

                                                public void run() {
                                                    nodeAtRow.getPreferredAction().actionPerformed(new ActionEvent(nodeAtRow, 1, "open"));
                                                }
                                            });
                                        }
                                    }
                                    catch (PropertyVetoException e1) {
                                        ErrorManager.getDefault().notify((Throwable)e1);
                                    }
                                }
                            }
                        }
                    };
                    realmsList.add(rnode);
                    this.objectsTable.addMouseListener((MouseListener)WeakListeners.create(MouseListener.class, (EventListener)this.listener, (Object)this.objectsTable));
                }
            }
        }

        public void setReadonly(boolean readonly) {
            this.readonly = readonly;
        }

        public boolean isReadonly() {
            return this.readonly;
        }

        public String getTitle() {
            return null;
        }

        static {
            realmsList = new ArrayList<RealmsNode>();
        }

        private static class DirObjectTableModel
        extends AbstractTableModel
        implements NodeListener {
            private static final long serialVersionUID = 1L;
            private static final Pattern SPLIT_PATTERN = Pattern.compile("\\s*,\\s*");
            private final Class objectClass;
            private final Map<String, Method> getters = new HashMap<String, Method>();
            private final String[] columnNames;
            private final String[] getterNames;
            private final RealmsNode rnode;

            public DirObjectTableModel(RealmsNode dol, Class objectClass) {
                this.rnode = dol;
                this.objectClass = objectClass;
                String tableDesc = Messages.getString("table.RealmsNode");
                String[] splitDesc = SPLIT_PATTERN.split(tableDesc);
                if (splitDesc.length % 2 != 0) {
                    ErrorManager.getDefault().log(16, "Table description for " + objectClass + " is malformed");
                }
                this.columnNames = new String[splitDesc.length / 2];
                this.getterNames = new String[splitDesc.length / 2];
                int i = 0;
                int j = 0;
                while (i < splitDesc.length - 1) {
                    this.columnNames[j] = splitDesc[i++];
                    this.getterNames[j++] = splitDesc[i++];
                }
                dol.addNodeListener((NodeListener)WeakListeners.create(NodeListener.class, (EventListener)((Object)this), (Object)((Object)dol)));
            }

            public Object getValueAt(int row, int column) {
                Node[] nodes = this.rnode.getChildren().getNodes();
                if (nodes.length <= row) {
                    return "";
                }
                Realm realm = (Realm)nodes[row].getLookup().lookup(Realm.class);
                if (column == -1) {
                    return nodes[row];
                }
                if (null == realm) {
                    return "...";
                }
                String getterName = this.getterNames[column];
                Method getter = this.getters.get(getterName);
                if (null == getter) {
                    try {
                        getter = this.objectClass.getMethod(getterName, new Class[0]);
                        this.getters.put(getterName, getter);
                    }
                    catch (Exception e) {
                        ErrorManager.getDefault().notify((Throwable)e);
                        return "<" + e.getLocalizedMessage() + ">";
                    }
                }
                try {
                    Object obj = getter.invoke((Object)realm, new Object[0]);
                    if (obj == null) {
                        return "";
                    }
                    if (obj.equals("RealmConfiguration")) {
                        String dn = realm.getConnectionDescriptor().getBaseDN();
                        dn = dn.replace("\\,", "#%COMMA%#");
                        String[] s = dn.split(",");
                        String nameRealm = "";
                        if (s.length > 0) {
                            nameRealm = s[0].replace("ou=", "").trim();
                            nameRealm = nameRealm.replace("#%COMMA%#", "\\,").trim();
                        }
                        return nameRealm;
                    }
                    return obj;
                }
                catch (Exception e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                    return "<" + e.getLocalizedMessage() + ">";
                }
            }

            Node getNodeAtRow(int row) {
                Node[] nodes = this.rnode.getChildren().getNodes();
                if (nodes.length <= row) {
                    return null;
                }
                return nodes[row];
            }

            public int getColumnCount() {
                return this.columnNames.length;
            }

            public String getColumnName(int columnIndex) {
                return this.columnNames[columnIndex];
            }

            public int getRowCount() {
                return this.rnode.getChildren().getNodes().length;
            }

            public void childrenAdded(NodeMemberEvent ev) {
                this.propagateChangeOnEDT();
            }

            public void childrenRemoved(NodeMemberEvent ev) {
                this.propagateChangeOnEDT();
            }

            public void childrenReordered(NodeReorderEvent ev) {
                this.propagateChangeOnEDT();
            }

            public void nodeDestroyed(NodeEvent ev) {
                this.propagateChangeOnEDT();
            }

            public void propertyChange(PropertyChangeEvent evt) {
                this.propagateChangeOnEDT();
            }

            private void propagateChangeOnEDT() {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        DirObjectTableModel.this.fireTableDataChanged();
                    }
                });
            }
        }
    }

    static class Children
    extends AbstractAsyncArrayChildren {
        Children() {
        }

        protected Collection asyncInitChildren() {
            ArrayList<Object> results = new ArrayList<Object>();
            try {
                for (final String realmName : RealmManager.getRegisteredRealmNames()) {
                    try {
                        Realm realm = RealmManager.loadRealm(realmName);
                        realm.getDirectory().refresh((Object)realm);
                        try {
                            LDAPDirectory.assertBaseDNReachable((LDAPConnectionDescriptor)realm.getConnectionDescriptor());
                        }
                        catch (CommunicationException e) {
                            throw new DirectoryException(realm.getConnectionDescriptor().getLDAPUrl());
                        }
                        results.add(realm);
                    }
                    catch (Exception e) {
                        logger.error((Object)"Can't load Realm", (Throwable)e);
                        results.add(new Node[]{new ErrorNode(Messages.getString("RealmsNode.cantDisplay"), e){

                            public Action[] getActions(boolean b) {
                                return new Action[]{new AbstractAction(Messages.getString("RealmsNode.deregister")){
                                    private static final long serialVersionUID = 1L;

                                    public void actionPerformed(ActionEvent actionevent) {
                                        try {
                                            RealmManager.deregisterRealm(realmName);
                                        }
                                        catch (BackingStoreException e) {
                                            logger.error((Object)e);
                                        }
                                    }
                                }};
                            }
                        }});
                    }
                }
                Collections.sort(results, GenericDirectoryObjectComparator.getInstance());
            }
            catch (Exception e) {
                logger.error((Object)e);
                results.add(new Node[]{new ErrorNode(Messages.getString("RealmsNode.cantDisplay"), e)});
            }
            return results;
        }

        protected Node[] createNodes(Object key) {
            if (key instanceof Node[]) {
                return (Node[])key;
            }
            return new Node[]{new RealmNode(this.getNode(), (Realm)key)};
        }
    }
}

