/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console.nodes.pkgmgr;

import com.levigo.util.swing.IconManager;
import java.util.ArrayList;
import java.util.Collection;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;
import org.openthinclient.console.Messages;
import org.openthinclient.console.nodes.pkgmgr.ModifyDialog;
import org.openthinclient.console.nodes.pkgmgr.PackageManagerJobQueue;
import org.openthinclient.console.nodes.pkgmgr.PackageNode;
import org.openthinclient.pkgmgr.PackageManagerException;
import org.openthinclient.util.dpkg.Package;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebianPackagesDeleteAction
extends NodeAction {
    private static final long serialVersionUID = -7820754447069438794L;
    private Node[] nodes;

    public DebianPackagesDeleteAction() {
        this.setIcon(IconManager.getInstance(((Object)((Object)this)).getClass(), (String)"icons").getIcon("Refresh"));
    }

    protected void performAction(Node[] activatedNodes) {
        ArrayList<Package> deleteList = new ArrayList<Package>();
        Node node2 = null;
        for (Node node : activatedNodes) {
            if (!(node instanceof PackageNode)) continue;
            Package pkg = (Package)((PackageNode)node).getLookup().lookup(Package.class);
            deleteList.add(pkg);
            if (node2 != null) continue;
            node2 = node.getParentNode();
        }
        DebianPackagesDeleteAction.deleteDebianPackages(deleteList, node2);
        deleteList.removeAll(deleteList);
    }

    public static void deleteDebianPackages(Collection<Package> deleteList, Node node) {
        PackageManagerJobQueue.Job job = new PackageManagerJobQueue.Job(node, (Collection)deleteList){

            void doJob() {
                ModifyDialog mody = new ModifyDialog();
                if (mody.shouldPackagesBeUsed(this.packageList, this.node.getName())) {
                    this.loadDialog(this.pkgmgr);
                } else {
                    this.dontWantToInstall();
                }
            }

            Object doPMJob() throws PackageManagerException {
                if (!this.pkgmgr.deleteDebianPackages(this.packageList)) {
                    throw new PackageManagerException(Messages.getString("error.DebianPackagesDeleteAction"));
                }
                this.createInformationOptionPane(false);
                this.packageList.removeAll(this.packageList);
                return null;
            }
        };
        PackageManagerJobQueue.getInstance().addPackageManagerJob(job);
    }

    protected boolean enable(Node[] activatedNodes) {
        this.nodes = activatedNodes;
        for (Node node : activatedNodes) {
            if (!(node instanceof PackageNode)) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        for (Node node : this.nodes) {
            if (!node.getClass().equals(PackageNode.class)) continue;
            return Messages.getString("realyDeleteAction.getName");
        }
        return null;
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    protected boolean asynchronous() {
        return true;
    }
}

