/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console.nodes.pkgmgr;

import com.levigo.util.swing.IconManager;
import java.util.ArrayList;
import java.util.Collection;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;
import org.openthinclient.console.Messages;
import org.openthinclient.console.nodes.pkgmgr.ModifyDialog;
import org.openthinclient.console.nodes.pkgmgr.PackageListNode;
import org.openthinclient.console.nodes.pkgmgr.PackageManagerJobQueue;
import org.openthinclient.console.nodes.pkgmgr.PackageNode;
import org.openthinclient.pkgmgr.PackageManagerException;
import org.openthinclient.util.dpkg.Package;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteAction
extends NodeAction {
    private static final long serialVersionUID = 3089422954495094295L;
    private Node[] nodes;

    public DeleteAction() {
        this.setIcon(IconManager.getInstance(((Object)((Object)this)).getClass(), (String)"icons").getIcon("Refresh"));
    }

    protected void performAction(Node[] activatedNodes) {
        ArrayList<Package> deleteList = new ArrayList<Package>();
        Node node2 = null;
        for (Node node : activatedNodes) {
            if (!(node instanceof PackageNode)) continue;
            Package pkg = (Package)((PackageNode)node).getLookup().lookup(Package.class);
            deleteList.add(pkg);
            if (node2 != null) continue;
            node2 = node.getParentNode();
        }
        DeleteAction.deletePackages(deleteList, node2);
        deleteList.removeAll(deleteList);
        Node[] arr$ = activatedNodes;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            for (Node node = arr$[i$]; node != null; node = node.getParentNode()) {
                if (!(node instanceof PackageNode)) continue;
                ((PackageNode)node).refresh();
            }
        }
    }

    public static void deletePackages(Collection<Package> deleteList, Node node) {
        PackageManagerJobQueue.Job job = new PackageManagerJobQueue.Job(node, (Collection)deleteList){

            void doJob() {
                ModifyDialog mody = new ModifyDialog();
                this.packageList = this.pkgmgr.isDependencyOf(this.packageList);
                this.packageList = new ArrayList<Package>(this.pkgmgr.checkIfPackageMangerIsIn(this.packageList));
                mody.setVisible(true);
                if (mody.shouldPackagesBeUsed(this.packageList, this.node.getName()) && this.checkIfApplicationsLinkToPackages()) {
                    this.loadDialog(this.pkgmgr);
                } else {
                    this.dontWantToInstall();
                }
            }

            Object doPMJob() throws PackageManagerException {
                if (!this.pkgmgr.delete(this.packageList)) {
                    throw new PackageManagerException(Messages.getString("error.DeleteAction"));
                }
                this.createInformationOptionPane(true);
                this.packageList.removeAll(this.packageList);
                return null;
            }
        };
        PackageManagerJobQueue.getInstance().addPackageManagerJob(job);
        ((PackageListNode)node).refresh();
    }

    protected boolean enable(Node[] activatedNodes) {
        this.nodes = activatedNodes;
        for (Node node : activatedNodes) {
            if (!(node instanceof PackageNode)) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        for (Node node : this.nodes) {
            if (!node.getClass().equals(PackageNode.class)) continue;
            return Messages.getString("deleteAction.getName");
        }
        return null;
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    protected boolean asynchronous() {
        return true;
    }
}

