/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console.nodes.pkgmgr;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.levigo.util.swing.IconManager;
import com.levigo.util.swing.table.SunTableSorter;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.util.Collection;
import java.util.EventListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableModel;
import org.openide.ErrorManager;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;
import org.openthinclient.console.AbstractDetailView;
import org.openthinclient.console.DetailView;
import org.openthinclient.console.DetailViewProvider;
import org.openthinclient.console.Messages;
import org.openthinclient.console.nodes.pkgmgr.PackageListNode;
import org.openthinclient.console.nodes.pkgmgr.PackageListTableModel;
import org.openthinclient.console.nodes.pkgmgr.PackageManagementNode;
import org.openthinclient.console.nodes.pkgmgr.PackageManagerDelegation;
import org.openthinclient.console.nodes.pkgmgr.PackageNode;
import org.openthinclient.console.util.StringFilterTableModel;
import org.openthinclient.pkgmgr.PackageManagerException;
import org.openthinclient.util.dpkg.Package;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DialogPackageDetailView
extends AbstractDetailView {
    private static DialogPackageDetailView detailView;
    private int rowSelectedInTable = -1;
    private JTextField queryField;
    public JTable packagesTable;
    private MouseAdapter listener;
    private boolean showDebFile;
    private JComponent mainComponent;
    private StringFilterTableModel tableModel;
    private SunTableSorter sts;
    private Node packnode;
    private Node[] selection;
    private TopComponent tc;
    public static final int INSTALL = 0;
    public static final int CACHE = 1;
    public static final int BOTH = 2;
    private boolean allowSelection = false;
    private PackageManagerDelegation pkgmgr;

    public static DialogPackageDetailView getInstance() {
        if (null == detailView) {
            detailView = new DialogPackageDetailView();
        }
        return detailView;
    }

    @Override
    public JComponent getHeaderComponent() {
        this.getMainComponent();
        DefaultFormBuilder dfb = new DefaultFormBuilder(new FormLayout("p, 10dlu, r:p, 3dlu, f:p:g"));
        dfb.setDefaultDialogBorder();
        dfb.setLeadingColumnOffset(2);
        dfb.setColumn(3);
        this.queryField = new JTextField();
        dfb.append(Messages.getString("DirObjectListNode.filter"), (Component)this.queryField);
        dfb.nextLine();
        this.queryField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                DialogPackageDetailView.this.tableModel.setFilter(DialogPackageDetailView.this.queryField.getText());
            }

            public void removeUpdate(DocumentEvent e) {
                DialogPackageDetailView.this.tableModel.setFilter(DialogPackageDetailView.this.queryField.getText());
            }

            public void insertUpdate(DocumentEvent e) {
                DialogPackageDetailView.this.tableModel.setFilter(DialogPackageDetailView.this.queryField.getText());
            }

            protected void finalize() throws Throwable {
                DialogPackageDetailView.this.tableModel.setFilter("");
                DialogPackageDetailView.this.packagesTable.clearSelection();
                super.finalize();
            }
        });
        dfb.add((Component)new JLabel(IconManager.getInstance(DetailViewProvider.class, (String)"icons").getIcon("tree.PackageListQuery")), new CellConstraints(1, 1, 1, dfb.getRowCount(), CellConstraints.CENTER, CellConstraints.TOP));
        return dfb.getPanel();
    }

    @Override
    public JComponent getMainComponent() {
        if (null == this.mainComponent) {
            this.packagesTable = new JTable();
            this.tableModel = new StringFilterTableModel();
            this.sts = new SunTableSorter((TableModel)this.tableModel);
            this.sts.setTableHeader(this.packagesTable.getTableHeader());
            this.packagesTable.setModel((TableModel)this.sts);
            this.mainComponent = new JScrollPane(this.packagesTable);
            this.mainComponent.setBackground(UIManager.getColor("TextField.background"));
        }
        return this.mainComponent;
    }

    @Override
    public void init(Node[] selection, TopComponent tc) {
        this.selection = selection;
        this.tc = tc;
        for (Node node : selection) {
            if (!(node instanceof PackageListNode)) continue;
            this.packnode = node;
            this.setPackageList((PackageListNode)node, tc, null);
            break;
        }
    }

    private void setPackageList(PackageListNode pln, final TopComponent tc, Node node) {
        this.showDebFile = false;
        if (pln.getName().equalsIgnoreCase(Messages.getString("node.AvailablePackagesNode"))) {
            this.showDebFile = true;
        }
        this.getMainComponent();
        this.tableModel.setTableModel(new PackageListTableModel(pln, this.allowSelection, this.showDebFile));
        this.sts.setSortingStatus(1, 1);
        if (null != tc && tc instanceof ExplorerManager.Provider) {
            this.listener = new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() > 1) {
                        int selectedRow = DialogPackageDetailView.this.packagesTable.getSelectedRow();
                        if (selectedRow < 0) {
                            return;
                        }
                        final Node nodeAtRow = (Node)DialogPackageDetailView.this.packagesTable.getModel().getValueAt(selectedRow, -1);
                        if (null != nodeAtRow) {
                            try {
                                ((ExplorerManager.Provider)tc).getExplorerManager().setSelectedNodes(new Node[]{nodeAtRow});
                                if (e.getClickCount() > 1) {
                                    SwingUtilities.invokeLater(new Runnable(){

                                        public void run() {
                                            nodeAtRow.getPreferredAction().actionPerformed(new ActionEvent(nodeAtRow, 1, "open"));
                                        }
                                    });
                                }
                            }
                            catch (PropertyVetoException e1) {
                                e1.printStackTrace();
                                ErrorManager.getDefault().notify((Throwable)e1);
                            }
                        }
                    }
                }
            };
            this.packagesTable.addMouseListener((MouseListener)WeakListeners.create(MouseListener.class, (EventListener)this.listener, (Object)this.packagesTable));
        }
    }

    @Override
    public JComponent getFooterComponent() {
        if (this.tableModel.getTableModel().getClass() == PackageListTableModel.class) {
            if (this.rowSelectedInTable > -1 && this.rowSelectedInTable < this.packagesTable.getRowCount()) {
                boolean isSet = false;
                Node[] droehnung = new Node[1];
                for (Node nodele : this.selection) {
                    if (null == nodele) continue;
                    for (Node nodelele : nodele.getChildren().getNodes()) {
                        if (null == nodelele || !nodelele.getName().equalsIgnoreCase((String)this.packagesTable.getValueAt(this.rowSelectedInTable, 1))) continue;
                        droehnung[0] = nodelele;
                        isSet = true;
                    }
                }
                if (isSet) {
                    Package pkg = null;
                    for (int i = 0; i < this.packagesTable.getRowCount(); ++i) {
                        if (!droehnung[0].getName().equalsIgnoreCase((String)((PackageListTableModel)this.tableModel.getTableModel()).getValueAt(i, 1))) continue;
                        pkg = ((PackageListTableModel)this.tableModel.getTableModel()).getPackageAtRow(i);
                    }
                    DetailView detail = new PackageNode(this.packnode, pkg).getDetailView();
                    detail.init(droehnung, this.tc);
                    JComponent jco = detail.getMainComponent();
                    return jco;
                }
                return new JLabel(Messages.getString("PackageDetailView.noRowSelected"));
            }
            return new JLabel(Messages.getString("PackageDetailView.noRowSelected"));
        }
        return new JLabel(Messages.getString("PackageDetailView.noRowSelected"));
    }

    public JComponent infoFooter() throws PackageManagerException {
        CellConstraints cc = new CellConstraints();
        JPanel jpl = new JPanel();
        jpl.setLayout((LayoutManager)new FormLayout("f:p:g", "30dlu"));
        try {
            if (this.packnode.getName().equalsIgnoreCase(Messages.getString("node.AvailablePackagesNode"))) {
                jpl.add((Component)this.getInstallSize(2), cc.xy(1, 1));
            } else if (this.packnode.getName().equalsIgnoreCase(Messages.getString("node.DebianFilePackagesNode"))) {
                jpl.add((Component)this.getInstallSize(1), cc.xy(1, 1));
            } else {
                jpl.add((Component)this.getInstallSize(0), cc.xy(1, 1));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            ErrorManager.getDefault().notify((Throwable)e);
        }
        return jpl;
    }

    public String getTitle() {
        return null;
    }

    public boolean isAllowSelection() {
        return this.allowSelection;
    }

    public void setAllowSelection(boolean allowSelection) {
        this.allowSelection = allowSelection;
    }

    public Collection<Package> getSlecetedItems() {
        return ((PackageListTableModel)this.tableModel.getTableModel()).getSelectedPackages();
    }

    public JComponent getInstallSize(int i) throws IOException, PackageManagerException {
        CellConstraints cc = new CellConstraints();
        JPanel jpl = new JPanel();
        if (i == 2) {
            jpl.setLayout((LayoutManager)new FormLayout("85dlu,60dlu,85dlu,60dlu", "15dlu,15dlu"));
            jpl.add((Component)new JLabel(Messages.getString("size.InstalledSize")), cc.xy(1, 1));
            jpl.add((Component)new JLabel(((PackageListTableModel)this.tableModel.getTableModel()).getUsedInstallSpace()), cc.xy(2, 1));
            jpl.add((Component)new JLabel(Messages.getString("size.CacheSize")), cc.xy(3, 1));
            jpl.add((Component)new JLabel(((PackageListTableModel)this.tableModel.getTableModel()).getUsedCacheSpace()), cc.xy(4, 1));
        } else {
            jpl.setLayout((LayoutManager)new FormLayout("85dlu,60dlu", "15dlu,15dlu"));
            if (i == 0) {
                jpl.add((Component)new JLabel(Messages.getString("size.InstalledSize")), cc.xy(1, 1));
                jpl.add((Component)new JLabel(((PackageListTableModel)this.tableModel.getTableModel()).getUsedInstallSpace()), cc.xy(2, 1));
            } else if (i == 1) {
                jpl.add((Component)new JLabel(Messages.getString("size.CacheSize")), cc.xy(1, 1));
                jpl.add((Component)new JLabel(((PackageListTableModel)this.tableModel.getTableModel()).getUsedCacheSpace()), cc.xy(2, 1));
            }
        }
        jpl.add((Component)new JLabel(Messages.getString("size.freeDiskSpace")), cc.xy(1, 2));
        this.pkgmgr = ((PackageManagementNode)this.packnode.getParentNode().getParentNode()).getPackageManagerDelegation();
        jpl.add((Component)new JLabel(String.valueOf((float)Math.round((float)this.pkgmgr.getFreeDiskSpace() / 1024.0f)) + " " + Messages.getString("size.unit")), cc.xy(2, 2));
        return jpl;
    }

    public void setRowSelectedInTable(int rowSelectedInTable) {
        this.rowSelectedInTable = rowSelectedInTable;
    }

    public int getTableHight() {
        return this.packagesTable.getRowHeight() * (this.packagesTable.getRowCount() + 1);
    }

    public void setValueAt(int i) {
        this.tableModel.setValueAt(true, i, 0);
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }
}

