/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console.nodes.pkgmgr;

import com.levigo.util.swing.IconManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.openide.ErrorManager;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;
import org.openthinclient.console.Messages;
import org.openthinclient.console.nodes.pkgmgr.ModifyDialog;
import org.openthinclient.console.nodes.pkgmgr.PackageManagerJobQueue;
import org.openthinclient.console.nodes.pkgmgr.PackageNode;
import org.openthinclient.pkgmgr.PackageManagerException;
import org.openthinclient.util.dpkg.Package;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstallAction
extends NodeAction {
    private static final long serialVersionUID = -4290156364765308004L;

    public InstallAction() {
        this.setIcon(IconManager.getInstance(((Object)((Object)this)).getClass(), (String)"icons").getIcon("Refresh"));
    }

    protected void performAction(Node[] activatedNodes) {
        ArrayList<Package> installList = new ArrayList<Package>();
        Node node2 = null;
        for (Node node : activatedNodes) {
            if (!(node instanceof PackageNode)) continue;
            Package pkg = (Package)((PackageNode)node).getLookup().lookup(Package.class);
            if (node2 == null) {
                node2 = node.getParentNode();
            }
            installList.add(pkg);
        }
        InstallAction.installPackages(node2, installList);
        installList.removeAll(installList);
        Node[] arr$ = activatedNodes;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            for (Node node = arr$[i$]; node != null; node = node.getParentNode()) {
                if (!(node instanceof PackageNode)) continue;
                ((PackageNode)node).refresh();
            }
        }
    }

    public static void installPackages(Node node, Collection<Package> installCollection) {
        PackageManagerJobQueue.Job job = new PackageManagerJobQueue.Job(node, (Collection)installCollection){

            Object doPMJob() throws PackageManagerException {
                if (!this.pkgmgr.install(this.packageList)) {
                    throw new PackageManagerException(Messages.getString("error.InstallAction"));
                }
                this.createInformationOptionPane(true);
                this.packageList.removeAll(this.packageList);
                return null;
            }

            void doJob() {
                block9: {
                    String conflicts = "";
                    conflicts = this.pkgmgr.checkForAlreadyInstalled(this.packageList);
                    ModifyDialog mody = new ModifyDialog();
                    try {
                        if (conflicts.length() == 0) {
                            this.packageList = this.pkgmgr.solveDependencies(this.packageList);
                            if (this.packageList.size() > 0 && (conflicts = this.pkgmgr.findConflicts(this.packageList)).length() == 0) {
                                conflicts = this.pkgmgr.checkForAlreadyInstalled(this.packageList);
                                if (conflicts.length() != 0) {
                                    this.packageList = new ArrayList<Package>(this.pkgmgr.solveConflicts(this.packageList));
                                }
                                if (mody.shouldPackagesBeUsed(this.packageList, this.node.getName())) {
                                    Iterator i = this.packageList.iterator();
                                    while (i.hasNext()) {
                                        Package pkg = (Package)i.next();
                                        String licenseText = pkg.getLicense();
                                        if (null == licenseText || this.accepptLicenseDialog(pkg.getName(), licenseText)) continue;
                                        i.remove();
                                    }
                                    if (!this.packageList.isEmpty()) {
                                        this.loadDialog(this.pkgmgr);
                                    }
                                } else {
                                    this.dontWantToInstall();
                                }
                            }
                            break block9;
                        }
                        throw new PackageManagerException(Messages.getString("conflictExisting.InstallAction"));
                    }
                    catch (PackageManagerException e) {
                        e.printStackTrace();
                        ErrorManager.getDefault().notify((Throwable)e);
                    }
                }
                this.pkgmgr.removeConflicts();
                this.pkgmgr.refreshSolveDependencies();
            }
        };
        PackageManagerJobQueue.getInstance().addPackageManagerJob(job);
        installCollection.removeAll(installCollection);
    }

    protected boolean enable(Node[] activatedNodes) {
        for (Node node : activatedNodes) {
            if (!(node instanceof PackageNode)) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return Messages.getString("installAction.getName");
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    protected boolean asynchronous() {
        return true;
    }
}

