/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console.nodes.pkgmgr;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.geom.AffineTransform;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.Utilities;
import org.openthinclient.console.Messages;
import org.openthinclient.console.ui.CollapsibleTitlePanel;
import org.openthinclient.console.util.DetailViewFormBuilder;
import org.openthinclient.util.dpkg.Package;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyDialog
extends JPanel {
    private static final long serialVersionUID = 4900661111130191583L;
    String action = "";

    public boolean shouldPackagesBeUsed(Collection<Package> packages, String name) {
        CellConstraints cc = new CellConstraints();
        this.setLayout((LayoutManager)new FormLayout("f:p:g", "f:p:g,f:p:g"));
        DetailViewFormBuilder dfb = new DetailViewFormBuilder(new FormLayout("f:p:g", "p,f:p:g"));
        LinkedList<JComponent> sections = new LinkedList<JComponent>();
        for (Package pkg : packages) {
            sections.add(this.createPackageInfos(pkg));
        }
        JComponent headerComponent = this.createNameLabel(name);
        headerComponent.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, this.getBackground().darker()), headerComponent.getBorder()));
        dfb.append(headerComponent);
        dfb.append(this.makeScrollPain(sections));
        this.add((Component)dfb.getPanel(), cc.xy(1, 1));
        JButton cancelButton = new JButton(Messages.getString("Cancel"));
        JButton okButton = new JButton(Messages.getString("OK"));
        JLabel label = new JLabel(Messages.getString("ModifyDialog.question", this.action));
        this.setVisible(true);
        DialogDescriptor descriptor = new DialogDescriptor((Object)this, name, true, new Object[]{label, cancelButton, okButton}, (Object)okButton, 0, null, null);
        descriptor.setClosingOptions(new Object[]{cancelButton, okButton});
        Dialog dialog = DialogDisplayer.getDefault().createDialog(descriptor);
        dialog.setIconImage(Utilities.loadImage((String)"org/openthinclient/console/icon.png", (boolean)true));
        dialog.setVisible(true);
        return descriptor.getValue() == okButton;
    }

    public JComponent createPackageInfos(Package pkg) {
        DetailViewFormBuilder dfb = new DetailViewFormBuilder(new FormLayout("p"));
        String versTemp = pkg.getVersion().toString().startsWith("0:") ? pkg.getVersion().toString().substring(2, pkg.getVersion().toString().length()) : pkg.getVersion().toString();
        dfb.append(new JLabel(Messages.getString("node.PackageNode.PackageDetailView.Version") + ": " + versTemp));
        dfb.append(new JLabel(Messages.getString("node.PackageNode.PackageDetailView.Section") + " : " + pkg.getSection()));
        dfb.append(new JLabel(Messages.getString("node.PackageNode.PackageDetailView.Priority") + " : " + pkg.getPriority()));
        if (pkg.getDescription() == null) {
            dfb.append(new JLabel(Messages.getString("node.PackageNode.PackageDetailView.createDescriptionPanel.noDescriptionAvailable")));
            dfb.getPanel().setName(pkg.getName());
            return dfb.getPanel();
        }
        String descript = pkg.getDescription();
        while (descript.length() > 80) {
            String temp = (descript = descript.trim()).substring(0, 80);
            if (temp.contains("\n")) {
                dfb.append(new JLabel(temp.substring(0, temp.indexOf("\n"))));
                dfb.append(new JLabel(""));
                descript = descript.substring(temp.indexOf("\n") + 2);
                continue;
            }
            dfb.append(new JLabel(descript.substring(0, temp.lastIndexOf(" "))));
            descript = descript.substring(temp.lastIndexOf(" "));
        }
        descript = descript.trim();
        while (descript.contains("\n")) {
            descript = descript.trim();
            dfb.append(new JLabel(descript.substring(0, descript.indexOf("\n"))));
            dfb.append(new JLabel(""));
            descript = descript.substring(descript.indexOf("\n") + 2);
        }
        descript = descript.trim();
        dfb.append(new JLabel(descript));
        dfb.getPanel().setName(pkg.getName());
        return dfb.getPanel();
    }

    public JComponent makeScrollPain(List<JComponent> sections) {
        DetailViewFormBuilder dfb = new DetailViewFormBuilder(new FormLayout("f:p:g", "p"));
        for (JComponent component : sections) {
            dfb.append(new CollapsibleTitlePanel(component.getName(), component, true));
        }
        JScrollPane scrollPane = new JScrollPane(dfb.getPanel());
        scrollPane.getVerticalScrollBar().setUnitIncrement(50);
        scrollPane.setPreferredSize(new Dimension(800, 550));
        scrollPane.setBorder(null);
        return scrollPane;
    }

    public JComponent createNameLabel(String name) {
        Font f = UIManager.getFont("TitledBorder.font");
        f = f.deriveFont(1, AffineTransform.getScaleInstance(1.5, 1.5));
        String nameAction = "";
        if (name.equalsIgnoreCase(Messages.getString("node.AvailablePackagesNode"))) {
            nameAction = Messages.getString("ModifyDialog.createNameLabel.AvailablePackagesNode");
            this.action = Messages.getString("ModifyDialog.action.install");
        } else if (name.equalsIgnoreCase(Messages.getString("node.InstalledPackagesNode"))) {
            nameAction = Messages.getString("ModifyDialog.createNameLabel.InstalledPackagesNode");
            this.action = Messages.getString("ModifyDialog.action.delete");
        } else if (name.equalsIgnoreCase(Messages.getString("node.UpdatablePackagesNode"))) {
            nameAction = Messages.getString("ModifyDialog.createNameLabel.UpdatablePackagesNode");
            this.action = Messages.getString("ModifyDialog.action.update");
        } else if (name.equalsIgnoreCase(Messages.getString("node.AlreadyDeletedPackagesNode"))) {
            nameAction = Messages.getString("ModifyDialog.createNameLabel.AlreadyDeletedPackagesNode");
            this.action = Messages.getString("ModifyDialog.action.delete");
        } else if (name.equalsIgnoreCase(Messages.getString("node.DebianFilePackagesNode"))) {
            nameAction = Messages.getString("ModifyDialog.createNameLabel.deleteDebianPackagesNode");
            this.action = Messages.getString("ModifyDialog.action.debianDelete");
        } else {
            nameAction = Messages.getString("node.unknown");
        }
        DetailViewFormBuilder dfb = new DetailViewFormBuilder(new FormLayout("f:p:g"), Messages.getBundle());
        JLabel nameLabel = new JLabel(nameAction);
        nameLabel.setForeground(new Color(50, 50, 200));
        nameLabel.setFont(f);
        dfb.append(nameLabel);
        return dfb.getPanel();
    }
}

