/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console.nodes.pkgmgr;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.levigo.util.swing.IconManager;
import com.levigo.util.swing.table.SunTableSorter;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableModel;
import org.openide.ErrorManager;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;
import org.openthinclient.console.AbstractDetailView;
import org.openthinclient.console.DetailViewProvider;
import org.openthinclient.console.Messages;
import org.openthinclient.console.nodes.pkgmgr.PackageListNode;
import org.openthinclient.console.nodes.pkgmgr.PackageListTableModel;
import org.openthinclient.console.util.StringFilterTableModel;

public class PackageDetailView
extends AbstractDetailView {
    private static PackageDetailView detailView;
    private static List<PackageListNode> plns;
    private JTextField queryField;
    private JTable packagesTable;
    private MouseAdapter listener;
    private JComponent mainComponent;
    private StringFilterTableModel tableModel;
    private SunTableSorter sts;
    private final boolean allowSelection = false;

    public static PackageDetailView getInstance() {
        if (null == detailView) {
            detailView = new PackageDetailView();
        }
        return detailView;
    }

    public JComponent getHeaderComponent() {
        this.getMainComponent();
        DefaultFormBuilder dfb = new DefaultFormBuilder(new FormLayout("p, 10dlu, r:p, 3dlu, f:p:g"));
        dfb.setDefaultDialogBorder();
        dfb.setLeadingColumnOffset(2);
        dfb.setColumn(3);
        this.queryField = new JTextField();
        dfb.append(Messages.getString("DirObjectListNode.filter"), (Component)this.queryField);
        dfb.nextLine();
        this.queryField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                PackageDetailView.this.tableModel.setFilter(PackageDetailView.this.queryField.getText());
            }

            public void removeUpdate(DocumentEvent e) {
                PackageDetailView.this.tableModel.setFilter(PackageDetailView.this.queryField.getText());
            }

            public void insertUpdate(DocumentEvent e) {
                PackageDetailView.this.tableModel.setFilter(PackageDetailView.this.queryField.getText());
            }

            protected void finalize() throws Throwable {
                PackageDetailView.this.tableModel.setFilter("");
                super.finalize();
            }
        });
        dfb.add((Component)new JLabel(IconManager.getInstance(DetailViewProvider.class, (String)"icons").getIcon("tree.PackageListQuery")), new CellConstraints(1, 1, 1, dfb.getRowCount(), CellConstraints.CENTER, CellConstraints.TOP));
        return dfb.getPanel();
    }

    public JComponent getMainComponent() {
        if (null == this.mainComponent) {
            this.packagesTable = new JTable();
            this.tableModel = new StringFilterTableModel();
            this.sts = new SunTableSorter((TableModel)this.tableModel);
            this.sts.setTableHeader(this.packagesTable.getTableHeader());
            this.packagesTable.setModel((TableModel)this.sts);
            this.mainComponent = new JScrollPane(this.packagesTable);
            this.mainComponent.setBackground(UIManager.getColor("TextField.background"));
        }
        return this.mainComponent;
    }

    public void init(Node[] selection, TopComponent tc) {
        if (null != this.queryField) {
            this.queryField.setText(" ");
        }
        for (Node node : selection) {
            if (!(node instanceof PackageListNode)) continue;
            this.setPackageList((PackageListNode)node, tc, null);
            break;
        }
    }

    private void setPackageList(PackageListNode pln, final TopComponent tc, Node node) {
        this.getMainComponent();
        this.tableModel.setTableModel(new PackageListTableModel(pln, false, false));
        this.sts.setSortingStatus(0, 1);
        boolean isIn = false;
        for (PackageListNode ref : plns) {
            if (!ref.getName().equalsIgnoreCase(pln.getName())) continue;
            isIn = true;
        }
        if (!isIn) {
            if (plns.size() > 0) {
                this.packagesTable.removeMouseListener(this.packagesTable.getMouseListeners()[this.packagesTable.getMouseListeners().length - 1]);
                plns.remove(plns.size() - 1);
            }
            if (null != tc && tc instanceof ExplorerManager.Provider) {
                this.listener = new MouseAdapter(){

                    public void mouseClicked(MouseEvent e) {
                        if (e.getClickCount() > 1) {
                            int selectedRow = PackageDetailView.this.packagesTable.getSelectedRow();
                            if (selectedRow < 0) {
                                return;
                            }
                            final Node nodeAtRow = (Node)PackageDetailView.this.packagesTable.getModel().getValueAt(selectedRow, -1);
                            if (null != nodeAtRow) {
                                try {
                                    ((ExplorerManager.Provider)tc).getExplorerManager().setSelectedNodes(new Node[]{nodeAtRow});
                                    if (e.getClickCount() > 1) {
                                        SwingUtilities.invokeLater(new Runnable(){

                                            public void run() {
                                                if (null != nodeAtRow.getPreferredAction()) {
                                                    nodeAtRow.getPreferredAction().actionPerformed(new ActionEvent(nodeAtRow, 1, "open"));
                                                }
                                            }
                                        });
                                    }
                                }
                                catch (PropertyVetoException e1) {
                                    e1.printStackTrace();
                                    ErrorManager.getDefault().notify((Throwable)e1);
                                }
                            }
                        }
                    }
                };
                plns.add(pln);
                this.packagesTable.addMouseListener((MouseListener)WeakListeners.create(MouseListener.class, (EventListener)this.listener, (Object)this.packagesTable));
            }
        }
    }

    public String getTitle() {
        return null;
    }

    public JTable getpackagesTable() {
        return this.packagesTable;
    }

    static {
        plns = new ArrayList<PackageListNode>();
    }
}

