/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console.nodes.pkgmgr;

import com.levigo.util.swing.IconManager;
import java.awt.Image;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.openide.ErrorManager;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.lookup.ProxyLookup;
import org.openthinclient.console.DetailView;
import org.openthinclient.console.DetailViewProvider;
import org.openthinclient.console.Messages;
import org.openthinclient.console.Refreshable;
import org.openthinclient.console.nodes.AbstractAsyncArrayChildren;
import org.openthinclient.console.nodes.ErrorNode;
import org.openthinclient.console.nodes.MyAbstractNode;
import org.openthinclient.console.nodes.pkgmgr.PackageDetailView;
import org.openthinclient.console.nodes.pkgmgr.PackageManagementNode;
import org.openthinclient.console.nodes.pkgmgr.PackageManagerDelegation;
import org.openthinclient.console.nodes.pkgmgr.PackageNode;
import org.openthinclient.util.dpkg.Package;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PackageListNode
extends MyAbstractNode
implements DetailViewProvider,
Refreshable {
    private PackageManagerDelegation pkgmgr;

    public PackageListNode(Node parent) {
        super(Children.LEAF, (Lookup)new ProxyLookup(new Lookup[]{parent.getLookup()}));
        this.setChildren((org.openide.nodes.Children)new Children());
    }

    protected abstract Collection<Package> getPackageList(PackageManagerDelegation var1);

    public boolean canCopy() {
        return false;
    }

    public boolean canDestroy() {
        return false;
    }

    public boolean canRename() {
        return false;
    }

    @Override
    public Image getIcon(int type) {
        return this.getOpenedIcon(type);
    }

    @Override
    public Image getOpenedIcon(int type) {
        return IconManager.getInstance(DetailViewProvider.class, (String)"icons").getImage("tree." + this.getClass().getSimpleName());
    }

    @Override
    public DetailView getDetailView() {
        return PackageDetailView.getInstance();
    }

    @Override
    public void refresh() {
        ((AbstractAsyncArrayChildren)this.getChildren()).refreshChildren();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Children
    extends AbstractAsyncArrayChildren {
        private PackageManagerDelegation pkgmgr;

        private Children() {
        }

        @Override
        protected Collection<Package> asyncInitChildren() {
            try {
                this.pkgmgr = ((PackageManagementNode)PackageListNode.this.getParentNode()).getPackageManagerDelegation();
                ArrayList<Package> sorted = PackageListNode.this.getPackageList(this.pkgmgr).size() > 0 ? new ArrayList<Package>(PackageListNode.this.getPackageList(this.pkgmgr)) : Collections.EMPTY_LIST;
                Collections.sort(sorted);
                return sorted;
            }
            catch (Exception e) {
                e.printStackTrace();
                ErrorManager.getDefault().notify((Throwable)e);
                this.add(new Node[]{new ErrorNode(Messages.getString("DirObjectListNode.cantDisplay"), e)});
                return Collections.EMPTY_LIST;
            }
        }

        protected Node[] createNodes(Object key) {
            if (key instanceof Node[]) {
                return (Node[])key;
            }
            return new Node[]{new PackageNode(this.getNode(), (Package)key)};
        }
    }
}

