/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console.nodes.pkgmgr;

import com.levigo.util.swing.IconManager;
import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.table.AbstractTableModel;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.WeakListeners;
import org.openthinclient.console.DetailViewProvider;
import org.openthinclient.console.Messages;
import org.openthinclient.console.nodes.pkgmgr.PackageListNode;
import org.openthinclient.console.nodes.pkgmgr.PackageManagementNode;
import org.openthinclient.console.nodes.pkgmgr.PackageManagerDelegation;
import org.openthinclient.util.dpkg.Package;
import org.openthinclient.util.dpkg.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PackageListTableModel
extends AbstractTableModel
implements NodeListener {
    private static final long serialVersionUID = 1L;
    private final PackageListNode pln;
    private final Set<Package> toBeSelectable = new HashSet<Package>();
    private final Set<Package> toBeSelectableDEB = new HashSet<Package>();
    private final boolean allowSelection;
    private final boolean existsaDebFile;
    private PackageManagerDelegation pkgmgr;
    private static final int IN_BYTE = 0;
    private static final int IN_KBYTE = 1;

    public PackageListTableModel(PackageListNode dol, boolean allowSelection, boolean existsaDebFile) {
        this.pln = dol;
        this.allowSelection = allowSelection;
        this.existsaDebFile = existsaDebFile;
        dol.addNodeListener((NodeListener)WeakListeners.create(NodeListener.class, (EventListener)((Object)this), (Object)dol));
        if (existsaDebFile) {
            this.pkgmgr = ((PackageManagementNode)this.pln.getParentNode()).getPackageManagerDelegation();
        }
    }

    @Override
    public Object getValueAt(int row, int column) {
        Node[] nodes = this.pln.getChildren().getNodes();
        if (nodes.length <= row || null == nodes[row]) {
            return "";
        }
        Package p = (Package)nodes[row].getLookup().lookup(Package.class);
        if (null == p) {
            return "...";
        }
        if (column != -1 && !this.allowSelection) {
            ++column;
        }
        switch (column) {
            case -1: {
                return nodes[row];
            }
            case 0: {
                return this.toBeSelectable.contains(p);
            }
            case 1: {
                return p.getName();
            }
            case 2: {
                return p.getShortDescription();
            }
            case 3: {
                if (!p.getVersion().toString().startsWith("0:")) {
                    return p.getVersion();
                }
                String temp = p.getVersion().toString().substring(2, p.getVersion().toString().length());
                return temp;
            }
            case 4: {
                return this.unitDescriber(p.getSize(), 0);
            }
            case 5: {
                return this.unitDescriber(p.getInstalledSize(), 1);
            }
            case 6: {
                if (this.existsaDebFile) {
                    for (Package pkg : this.pkgmgr.getDebianFilePackages()) {
                        if (!pkg.getName().equalsIgnoreCase(p.getFilename()) || !pkg.getVersion().equals((Object)p.getVersion())) continue;
                        return true;
                    }
                }
                return false;
            }
            case 7: {
                if (!this.existsaDebFile) break;
                if (((Boolean)this.getValueAt(row, 6)).booleanValue()) {
                    return new ImageIcon(IconManager.getInstance(DetailViewProvider.class, (String)"icons").getImage("tree.greenCheck"));
                }
                return new ImageIcon(IconManager.getInstance(DetailViewProvider.class, (String)"icons").getImage("tree.redX"));
            }
        }
        return "";
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex == 0 && this.allowSelection) {
            return true;
        }
        return super.isCellEditable(rowIndex, columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int row, int columnIndex) {
        if (columnIndex == 0) {
            Node[] nodes = this.pln.getChildren().getNodes();
            if (nodes.length <= row || null == nodes[row]) {
                return;
            }
            Package p = (Package)nodes[row].getLookup().lookup(Package.class);
            if (null == p) {
                return;
            }
            if (columnIndex == 0 && ((Boolean)aValue).booleanValue()) {
                this.toBeSelectable.add(p);
                if (!((Boolean)this.getValueAt(row, 6)).booleanValue()) {
                    this.toBeSelectableDEB.add(p);
                }
            } else {
                this.toBeSelectable.remove(p);
                if (!((Boolean)this.getValueAt(row, 6)).booleanValue()) {
                    this.toBeSelectableDEB.remove(p);
                }
            }
            this.fireTableCellUpdated(row, columnIndex);
        }
    }

    Node getNodeAtRow(int row) {
        Node[] nodes = this.pln.getChildren().getNodes();
        if (nodes.length <= row) {
            return null;
        }
        return nodes[row];
    }

    @Override
    public int getColumnCount() {
        if (this.existsaDebFile) {
            return 8;
        }
        return this.allowSelection ? 6 : 5;
    }

    @Override
    public String getColumnName(int column) {
        if (!this.allowSelection) {
            ++column;
        }
        switch (column) {
            case 0: {
                return Messages.getString("node.PackageListNode.getColumnName.tagged");
            }
            case 1: {
                return Messages.getString("node.PackageListNode.getColumnName.name");
            }
            case 2: {
                return Messages.getString("node.PackageListNode.getColumnName.description");
            }
            case 3: {
                return Messages.getString("node.PackageListNode.getColumnName.version");
            }
            case 4: {
                return Messages.getString("node.PackageListNode.getColumnName.size");
            }
            case 5: {
                return Messages.getString("node.PackageListNode.getColumnName.installedsize");
            }
            case 6: {
                return Messages.getString("node.PackageListNode.getColumnName.isDebLocal.DontShow");
            }
            case 7: {
                return Messages.getString("node.PackageListNode.getColumnName.isDebLocal");
            }
        }
        return Messages.getString("node.unknown");
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0 && this.allowSelection) {
            return Boolean.class;
        }
        if (columnIndex == 4 || columnIndex == 3 && !this.allowSelection || columnIndex == 5 && this.allowSelection) {
            return Integer.class;
        }
        if (columnIndex == 3 && this.allowSelection || columnIndex == 2 && !this.allowSelection) {
            return Version.class;
        }
        if (columnIndex == 6) {
            return Boolean.class;
        }
        if (columnIndex == 7) {
            return ImageIcon.class;
        }
        return super.getColumnClass(columnIndex);
    }

    @Override
    public int getRowCount() {
        return this.pln.getChildren().getNodes().length;
    }

    public void childrenAdded(NodeMemberEvent ev) {
        this.propagateChangeOnEDT();
    }

    public void childrenRemoved(NodeMemberEvent ev) {
        this.propagateChangeOnEDT();
    }

    public void childrenReordered(NodeReorderEvent ev) {
        this.propagateChangeOnEDT();
    }

    public void nodeDestroyed(NodeEvent ev) {
        this.propagateChangeOnEDT();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.propagateChangeOnEDT();
    }

    private void propagateChangeOnEDT() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                PackageListTableModel.this.fireTableDataChanged();
            }
        });
    }

    public Collection<Package> getSelectedPackages() {
        return this.toBeSelectable;
    }

    public Package getPackageAtRow(int row) {
        Node[] nodes = this.pln.getChildren().getNodes();
        if (nodes.length <= row || null == nodes[row]) {
            return null;
        }
        return (Package)nodes[row].getLookup().lookup(Package.class);
    }

    public String getUsedInstallSpace() {
        if (this.toBeSelectable == null || this.toBeSelectable.size() == 0) {
            return "0";
        }
        float neededSpace = 0.0f;
        for (Package pkg : this.toBeSelectable) {
            neededSpace += (float)pkg.getInstalledSize();
        }
        return this.unitDescriber(neededSpace, 1);
    }

    public String getUsedCacheSpace() {
        if (this.toBeSelectableDEB == null || this.toBeSelectableDEB.size() == 0) {
            return "0";
        }
        float neededSpace = 0.0f;
        for (Package pkg : this.toBeSelectableDEB) {
            neededSpace += (float)pkg.getSize();
        }
        return this.unitDescriber(neededSpace, 0);
    }

    public String unitDescriber(float value, int counter) {
        boolean greaterThanOne = true;
        while (greaterThanOne) {
            if (counter < 4) {
                if (value > 1024.0f) {
                    value /= 1024.0f;
                    ++counter;
                    continue;
                }
                greaterThanOne = false;
                continue;
            }
            greaterThanOne = false;
        }
        value *= 10.0f;
        value = (float)Math.round(value) / 10.0f;
        String ret = "";
        switch (counter) {
            case 0: {
                ret = " Byte";
                break;
            }
            case 1: {
                ret = " KB";
                break;
            }
            case 2: {
                ret = " MB";
                break;
            }
            case 3: {
                ret = " GB";
            }
        }
        return Float.toString(value) + ret;
    }
}

