/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console.nodes.pkgmgr;

import com.levigo.util.swing.IconManager;
import java.awt.Image;
import java.io.IOException;
import java.util.Properties;
import javax.swing.Action;
import org.openide.ErrorManager;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.actions.SystemAction;
import org.openthinclient.common.model.Realm;
import org.openthinclient.console.DetailView;
import org.openthinclient.console.DetailViewProvider;
import org.openthinclient.console.Refreshable;
import org.openthinclient.console.nodes.MyAbstractNode;
import org.openthinclient.console.nodes.pkgmgr.AlreadyDeletedPackagesNode;
import org.openthinclient.console.nodes.pkgmgr.AvailablePackagesNode;
import org.openthinclient.console.nodes.pkgmgr.DebianFilePackagesNode;
import org.openthinclient.console.nodes.pkgmgr.InstalledPackagesNode;
import org.openthinclient.console.nodes.pkgmgr.PackageListNode;
import org.openthinclient.console.nodes.pkgmgr.PackageManagementView;
import org.openthinclient.console.nodes.pkgmgr.PackageManagerDelegation;
import org.openthinclient.console.nodes.pkgmgr.RefreshPackageManagerValuesAction;
import org.openthinclient.console.nodes.pkgmgr.ReloadAction;
import org.openthinclient.console.nodes.pkgmgr.UpdatablePackagesNode;

public class PackageManagementNode
extends MyAbstractNode
implements Refreshable,
DetailViewProvider {
    private PackageManagerDelegation packageManagerDelegation;

    public PackageManagementNode(Node parent) {
        super((Children)new Children.Array(), parent.getLookup());
        this.getChildren().add(new Node[]{new InstalledPackagesNode((Node)this), new AvailablePackagesNode((Node)this), new UpdatablePackagesNode((Node)this), new AlreadyDeletedPackagesNode((Node)this), new DebianFilePackagesNode((Node)this)});
    }

    public PackageManagerDelegation getPackageManagerDelegation() {
        if (null == this.packageManagerDelegation) {
            String homeServer = null;
            try {
                Properties p = new Properties();
                Realm realm = (Realm)this.getLookup().lookup(Realm.class);
                homeServer = null != realm.getSchemaProviderName() ? realm.getSchemaProviderName() : (null != realm.getConnectionDescriptor().getHostname() ? realm.getConnectionDescriptor().getHostname() : "localhost");
                p.setProperty("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
                p.setProperty("java.naming.provider.url", "jnp://" + homeServer + ":1099");
                this.packageManagerDelegation = new PackageManagerDelegation(p);
                return this.packageManagerDelegation;
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify((Throwable)e);
                return null;
            }
        }
        return this.packageManagerDelegation;
    }

    public void refresh() {
        for (Node n : this.getChildren().getNodes()) {
            if (!(n instanceof Refreshable)) continue;
            ((PackageListNode)n).refresh();
        }
    }

    public void refresh(String type) {
    }

    public Image getIcon(int type) {
        return this.getOpenedIcon(type);
    }

    public Image getOpenedIcon(int type) {
        return IconManager.getInstance(DetailViewProvider.class, (String)"icons").getImage("tree." + this.getClass().getSimpleName());
    }

    public DetailView getDetailView() {
        return PackageManagementView.getInstance();
    }

    public Action[] getActions(boolean arg0) {
        if (this.isWritable()) {
            return new Action[]{SystemAction.get(ReloadAction.class), null, SystemAction.get(RefreshPackageManagerValuesAction.class)};
        }
        return new Action[]{SystemAction.get(RefreshPackageManagerValuesAction.class)};
    }

    public void destroy() throws IOException {
        super.destroy();
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }
}

