/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console.nodes.pkgmgr;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.geom.AffineTransform;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import org.openide.nodes.Node;
import org.openide.windows.TopComponent;
import org.openthinclient.console.AbstractDetailView;
import org.openthinclient.console.nodes.pkgmgr.PackageDetailView;
import org.openthinclient.console.nodes.pkgmgr.PackageListNode;
import org.openthinclient.console.nodes.pkgmgr.PackageListTableModel;
import org.openthinclient.console.nodes.pkgmgr.PackageManagementNode;

public class PackageManagementView
extends AbstractDetailView {
    private static PackageManagementView detailView;
    private Node[] nodes;
    private TopComponent tc;

    public static PackageManagementView getInstance() {
        if (null == detailView) {
            detailView = new PackageManagementView();
        }
        return detailView;
    }

    public JComponent getMainComponent() {
        Font f = UIManager.getFont("TitledBorder.font");
        f = f.deriveFont(1, AffineTransform.getScaleInstance(1.5, 1.5));
        DefaultFormBuilder dfb = new DefaultFormBuilder(new FormLayout("f:p:g"));
        for (Node node : this.nodes) {
            PackageDetailView pdv = PackageDetailView.getInstance();
            pdv.init(node.getChildren().getNodes(), this.tc);
            JLabel jlb = new JLabel(node.getDisplayName() + ":");
            jlb.setFont(f);
            dfb.append((Component)jlb);
            JTable otherTable = new JTable();
            otherTable.setModel(new PackageListTableModel((PackageListNode)node, false, false));
            dfb.append((Component)otherTable);
        }
        JScrollPane jsp = new JScrollPane(dfb.getPanel());
        return jsp;
    }

    public void init(Node[] selection, TopComponent tc) {
        this.tc = tc;
        for (Node node : selection) {
            if (!(node instanceof PackageManagementNode)) continue;
            this.nodes = node.getChildren().getNodes();
        }
    }
}

