/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console.nodes.pkgmgr;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.openide.ErrorManager;
import org.openthinclient.console.Messages;
import org.openthinclient.pkgmgr.PackageManager;
import org.openthinclient.pkgmgr.PackageManagerException;
import org.openthinclient.util.dpkg.Package;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageManagerDelegation
implements PackageManager {
    private PackageManager pkgmgr;
    private List<Package> installedPackages;
    private List<Package> installablePackages;
    private List<Package> updateablePackages;
    private List<Package> removedPackages;
    private List<Package> debianPackages;
    private long freeDiskSpace;
    private HashMap<Package, List<String>> changelog;

    public PackageManagerDelegation(Properties p) {
        try {
            this.pkgmgr = (PackageManager)new InitialContext(p).lookup("PackageManagerBean/remote");
            this.installablePackages = new ArrayList<Package>(this.pkgmgr.getInstallablePackages());
            this.installedPackages = new ArrayList<Package>(this.pkgmgr.getInstalledPackages());
            this.updateablePackages = new ArrayList<Package>(this.pkgmgr.getUpdateablePackages());
            this.removedPackages = new ArrayList<Package>(this.pkgmgr.getAlreadyDeletedPackages());
            this.debianPackages = new ArrayList<Package>(this.pkgmgr.getDebianFilePackages());
            this.changelog = new HashMap();
        }
        catch (NamingException e) {
            e.printStackTrace();
            ErrorManager.getDefault().notify((Throwable)e);
        }
        catch (PackageManagerException e) {
            e.printStackTrace();
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    public PackageManagerDelegation getPackageManagerDelegation() {
        return this;
    }

    public String checkForAlreadyInstalled(List<Package> installList) {
        String ret = this.pkgmgr.checkForAlreadyInstalled(installList);
        this.checkForWarnings();
        return ret;
    }

    public Collection<Package> checkIfPackageMangerIsIn(Collection<Package> deleteList) {
        Package packageManager = null;
        for (Package pkg : deleteList) {
            if (!pkg.isPackageManager()) continue;
            packageManager = pkg;
        }
        if (packageManager != null) {
            deleteList.remove(packageManager);
        }
        this.checkForWarnings();
        return deleteList;
    }

    public void close() {
        try {
            this.pkgmgr.close();
        }
        catch (PackageManagerException e) {
            e.printStackTrace();
            ErrorManager.getDefault().notify((Throwable)e);
        }
        this.checkForWarnings();
    }

    public boolean delete(Collection<Package> collection) {
        try {
            if (this.pkgmgr.delete(collection)) {
                this.removedPackages = new ArrayList<Package>(this.pkgmgr.getAlreadyDeletedPackages());
                this.installablePackages = new ArrayList<Package>(this.pkgmgr.getInstallablePackages());
                this.installedPackages = new ArrayList<Package>(this.pkgmgr.getInstalledPackages());
                this.setNewFreeDiskSpace();
                this.checkForWarnings();
                return true;
            }
        }
        catch (PackageManagerException e) {
            e.printStackTrace();
            ErrorManager.getDefault().notify((Throwable)e);
        }
        catch (IOException e) {
            e.printStackTrace();
            ErrorManager.getDefault().notify((Throwable)e);
        }
        return false;
    }

    public boolean deleteDebianPackages(Collection<Package> collection) {
        if (this.pkgmgr.deleteDebianPackages(collection)) {
            this.debianPackages = new ArrayList<Package>(this.pkgmgr.getDebianFilePackages());
            this.checkForWarnings();
            this.setNewFreeDiskSpace();
            return true;
        }
        this.checkForWarnings();
        return false;
    }

    public boolean deleteOldPackages(Collection<Package> collection) {
        try {
            if (this.pkgmgr.deleteOldPackages(collection)) {
                this.removedPackages = new ArrayList<Package>(this.pkgmgr.getAlreadyDeletedPackages());
                this.checkForWarnings();
                this.setNewFreeDiskSpace();
                return true;
            }
        }
        catch (PackageManagerException e) {
            e.printStackTrace();
            ErrorManager.getDefault().notify((Throwable)e);
        }
        this.checkForWarnings();
        return false;
    }

    public String findConflicts(List<Package> list) {
        String ret = this.pkgmgr.findConflicts(list);
        this.checkForWarnings();
        return ret;
    }

    public int[] getActMaxFileSize() {
        int[] ret = this.pkgmgr.getActMaxFileSize();
        this.checkForWarnings();
        return ret;
    }

    public String getActPackName() {
        String ret = this.pkgmgr.getActPackName();
        this.checkForWarnings();
        return ret;
    }

    public int getActprogress() {
        int ret = this.pkgmgr.getActprogress();
        this.checkForWarnings();
        return ret;
    }

    public Collection<Package> getAlreadyDeletedPackages() {
        return this.removedPackages;
    }

    public Collection<String> getChangelogFile(Package package1) {
        if (this.changelog != null && this.changelog.containsKey(package1)) {
            return this.changelog.get(package1);
        }
        try {
            ArrayList<String> tmp = new ArrayList<String>(this.pkgmgr.getChangelogFile(package1));
            if (null == tmp || tmp == Collections.EMPTY_LIST || tmp.size() == 0) {
                tmp.add(Messages.getString("node.PackageNode.PackageDetailView.createChangelogPanel.noChangeLogFile"));
            }
            this.changelog.put(package1, tmp);
            this.checkForWarnings();
            return tmp;
        }
        catch (IOException e) {
            e.printStackTrace();
            ErrorManager.getDefault().notify((Throwable)e);
            return Collections.EMPTY_LIST;
        }
    }

    public Collection<Package> getDebianFilePackages() {
        return this.debianPackages;
    }

    public long getFreeDiskSpace() {
        if (this.freeDiskSpace == 0L) {
            try {
                this.freeDiskSpace = this.pkgmgr.getFreeDiskSpace();
            }
            catch (PackageManagerException e) {
                e.printStackTrace();
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
        this.checkForWarnings();
        return this.freeDiskSpace;
    }

    private void setNewFreeDiskSpace() {
        try {
            this.freeDiskSpace = this.pkgmgr.getFreeDiskSpace();
        }
        catch (PackageManagerException e) {
            e.printStackTrace();
            ErrorManager.getDefault().notify((Throwable)e);
        }
        this.checkForWarnings();
    }

    public Collection<Package> getInstallablePackages() throws PackageManagerException {
        return this.installablePackages;
    }

    public Collection<Package> getInstalledPackages() {
        return this.installedPackages;
    }

    public int getMaxProgress() {
        int ret = this.pkgmgr.getMaxProgress();
        this.checkForWarnings();
        return ret;
    }

    public Collection<Package> getUpdateablePackages() {
        return this.updateablePackages;
    }

    public boolean install(Collection<Package> collection) {
        try {
            if (this.pkgmgr.install(collection)) {
                this.installablePackages = new ArrayList<Package>(this.pkgmgr.getInstallablePackages());
                this.installedPackages = new ArrayList<Package>(this.pkgmgr.getInstalledPackages());
                this.debianPackages = new ArrayList<Package>(this.pkgmgr.getDebianFilePackages());
                this.setNewFreeDiskSpace();
                this.checkForWarnings();
                return true;
            }
        }
        catch (PackageManagerException e) {
            e.printStackTrace();
            ErrorManager.getDefault().notify((Throwable)e);
        }
        this.checkForWarnings();
        return false;
    }

    public List<Package> isDependencyOf(Collection<Package> collection) {
        List ret = this.pkgmgr.isDependencyOf(collection);
        this.checkForWarnings();
        return ret;
    }

    public boolean isDone() {
        boolean ret = this.pkgmgr.isDone();
        this.checkForWarnings();
        return ret;
    }

    public void refreshIsDone() {
        this.pkgmgr.refreshIsDone();
        this.checkForWarnings();
    }

    public void refreshSolveDependencies() {
        this.pkgmgr.refreshSolveDependencies();
        this.checkForWarnings();
    }

    public boolean removeConflicts() {
        boolean ret = this.pkgmgr.removeConflicts();
        this.checkForWarnings();
        return ret;
    }

    public void resetValuesForDisplaying() {
        this.pkgmgr.resetValuesForDisplaying();
        this.checkForWarnings();
    }

    public void setActprogress(int actprogress) {
        this.pkgmgr.setActprogress(actprogress);
        this.checkForWarnings();
    }

    public Collection<Package> solveConflicts(Collection<Package> selectedList) {
        Collection ret = this.pkgmgr.solveConflicts(selectedList);
        this.checkForWarnings();
        return ret;
    }

    public List<Package> solveDependencies(Collection<Package> collection) {
        List ret = this.pkgmgr.solveDependencies(collection);
        this.checkForWarnings();
        return ret;
    }

    public boolean update(Collection<Package> collection) {
        try {
            if (this.pkgmgr.update(collection)) {
                this.setIsDoneTrue();
                this.installedPackages = new ArrayList<Package>(this.pkgmgr.getInstalledPackages());
                this.updateablePackages = new ArrayList<Package>(this.pkgmgr.getUpdateablePackages());
                this.debianPackages = new ArrayList<Package>(this.pkgmgr.getDebianFilePackages());
                this.removedPackages = new ArrayList<Package>(this.pkgmgr.getAlreadyDeletedPackages());
                this.checkForWarnings();
                return true;
            }
        }
        catch (PackageManagerException e) {
            ErrorManager.getDefault().notify((Throwable)e);
            e.printStackTrace();
        }
        this.checkForWarnings();
        return false;
    }

    public boolean updateCacheDB() throws PackageManagerException {
        if (this.pkgmgr.updateCacheDB()) {
            this.installablePackages = new ArrayList<Package>(this.pkgmgr.getInstallablePackages());
            this.updateablePackages = new ArrayList<Package>(this.pkgmgr.getUpdateablePackages());
            this.checkForWarnings();
            return true;
        }
        return false;
    }

    public void refresh(int what) {
        this.setActprogress(new Double((double)this.getMaxProgress() * 0.95).intValue());
        try {
            switch (what) {
                case 0: {
                    this.installedPackages = new ArrayList<Package>(this.pkgmgr.getInstalledPackages());
                    this.updateablePackages = new ArrayList<Package>(this.pkgmgr.getUpdateablePackages());
                    this.installablePackages = new ArrayList<Package>(this.pkgmgr.getInstallablePackages());
                    this.removedPackages = new ArrayList<Package>(this.pkgmgr.getAlreadyDeletedPackages());
                    this.debianPackages = new ArrayList<Package>(this.pkgmgr.getDebianFilePackages());
                    break;
                }
                case 1: {
                    this.installedPackages = new ArrayList<Package>(this.pkgmgr.getInstalledPackages());
                    break;
                }
                case 2: {
                    this.installablePackages = new ArrayList<Package>(this.pkgmgr.getInstallablePackages());
                    break;
                }
                case 3: {
                    this.updateablePackages = new ArrayList<Package>(this.pkgmgr.getUpdateablePackages());
                    break;
                }
                case 4: {
                    this.removedPackages = new ArrayList<Package>(this.pkgmgr.getAlreadyDeletedPackages());
                    break;
                }
                case 5: {
                    this.debianPackages = new ArrayList<Package>(this.pkgmgr.getDebianFilePackages());
                }
            }
        }
        catch (PackageManagerException e) {
            e.printStackTrace();
            ErrorManager.getDefault().notify((Throwable)e);
        }
        this.setActprogress(this.getMaxProgress());
        this.setIsDoneTrue();
        this.checkForWarnings();
    }

    public void setIsDoneTrue() {
        this.pkgmgr.setIsDoneTrue();
        this.checkForWarnings();
    }

    public boolean addWarning(String warning) {
        boolean ret = this.pkgmgr.addWarning(warning);
        this.checkForWarnings();
        return ret;
    }

    public List<String> getWarnings() {
        List ret = this.pkgmgr.getWarnings();
        this.checkForWarnings();
        return ret;
    }

    public void invokeDeploymentScan() {
        this.pkgmgr.invokeDeploymentScan();
        this.checkForWarnings();
    }

    private void checkForWarnings() {
        List warningsList = this.pkgmgr.getWarnings();
        if (warningsList.size() != 0) {
            for (String warning : warningsList) {
                ErrorManager.getDefault().notify(new Throwable(warning));
            }
        }
    }
}

