/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console.nodes.pkgmgr;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.levigo.util.swing.IconManager;
import com.levigo.util.swing.table.SunTableSorter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.nodes.Node;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;
import org.openthinclient.console.AbstractDetailView;
import org.openthinclient.console.DetailView;
import org.openthinclient.console.DetailViewProvider;
import org.openthinclient.console.Messages;
import org.openthinclient.console.nodes.pkgmgr.DebianPackagesDeleteAction;
import org.openthinclient.console.nodes.pkgmgr.DeleteAction;
import org.openthinclient.console.nodes.pkgmgr.InstallAction;
import org.openthinclient.console.nodes.pkgmgr.PackageListNode;
import org.openthinclient.console.nodes.pkgmgr.PackageListTableModel;
import org.openthinclient.console.nodes.pkgmgr.PackageManagementNode;
import org.openthinclient.console.nodes.pkgmgr.PackageManagerDelegation;
import org.openthinclient.console.nodes.pkgmgr.PackageNode;
import org.openthinclient.console.nodes.pkgmgr.RealyDeleteAction;
import org.openthinclient.console.nodes.pkgmgr.UpdateAction;
import org.openthinclient.console.util.StringFilterTableModel;
import org.openthinclient.pkgmgr.PackageManagerException;
import org.openthinclient.util.dpkg.Package;

public class PackageManagerEditPanel
extends JPanel {
    private static PackageManagerEditPanel packManEdPa;
    private static final long serialVersionUID = 1L;
    private Node node;
    private JComponent footerComponent = null;
    private DialogPackageDetailViewEditorPanel detView;
    private JComponent mainComponent = null;
    private JComponent headerComponent = null;
    private JSplitPane splity = null;
    private CellConstraints cc = new CellConstraints();
    private JComponent infoFooter = null;
    private Node[] selectedPackage;
    private boolean fromPackageNode = false;
    private Node[] selection;
    private TopComponent tc;
    private int tmpselection;

    public static PackageManagerEditPanel getInstance() {
        packManEdPa = new PackageManagerEditPanel();
        return packManEdPa;
    }

    public void init(Node node, Node[] selectedPackage, Node[] selection, TopComponent tc) throws PackageManagerException {
        this.fromPackageNode = null != selectedPackage;
        this.selectedPackage = selectedPackage;
        this.node = node;
        this.detView = DialogPackageDetailViewEditorPanel.getInstance();
        this.selection = selection;
        this.tc = tc;
        this.footerComponent = null;
        this.mainComponent = null;
        this.headerComponent = null;
        this.splity = new JSplitPane();
        this.cc = new CellConstraints();
        this.infoFooter = null;
        this.tmpselection = -1;
        this.dataInput();
    }

    public void dataInput() throws PackageManagerException {
        this.detView.setAllowSelection(Boolean.TRUE);
        this.detView.init(this.selection, this.tc);
        this.setLayout((LayoutManager)new FormLayout("f:p:g", "15dlu,30dlu,f:p:g,30dlu"));
        Font f = UIManager.getFont("TitledBorder.font");
        f = f.deriveFont(1, AffineTransform.getScaleInstance(1.5, 1.5));
        if (this.fromPackageNode) {
            for (int i = 0; i < this.detView.packagesTable.getRowCount(); ++i) {
                for (int n = 0; n < this.selectedPackage.length; ++n) {
                    if (!((String)this.detView.packagesTable.getValueAt(i, this.detView.packagesTable.getColumnModel().getColumnIndex(Messages.getString("node.PackageListNode.getColumnName.name")))).equalsIgnoreCase(this.selectedPackage[n].getName())) continue;
                    this.detView.setValueAt(i);
                    this.detView.setRowSelectedInTable(i);
                }
            }
        }
        JLabel nameLabel = new JLabel(this.node.getName() != null ? this.node.getName() : " ");
        nameLabel.setForeground(new Color(50, 50, 200));
        nameLabel.setFont(f);
        this.add((Component)nameLabel, this.cc.xy(1, 1));
        this.headerComponent = this.detView.getHeaderComponent();
        if (null != this.headerComponent) {
            this.headerComponent.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, this.getBackground().darker()), this.headerComponent.getBorder()));
            this.add((Component)this.headerComponent, this.cc.xy(1, 2));
        }
        this.mainComponent = this.detView.getMainComponent();
        this.mainComponent.setSize(800, this.detView.packagesTable.getRowCount() * this.detView.packagesTable.getRowHeight());
        this.detView.setRowSelectedInTable(this.detView.packagesTable.getSelectedRow());
        this.refreshFooter();
        this.detView.packagesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int previousSelectedRow = PackageManagerEditPanel.this.detView.getRowSelectedInTable();
                if (PackageManagerEditPanel.this.tmpselection > -1 && ((PackageManagerEditPanel)PackageManagerEditPanel.this).detView.packagesTable.getSelectedRow() == -1) {
                    if (PackageManagerEditPanel.this.tmpselection >= ((PackageManagerEditPanel)PackageManagerEditPanel.this).detView.packagesTable.getRowCount()) {
                        PackageManagerEditPanel.this.tmpselection = ((PackageManagerEditPanel)PackageManagerEditPanel.this).detView.packagesTable.getSelectedRow();
                    } else {
                        PackageManagerEditPanel.this.detView.setRowSelectedInTable(PackageManagerEditPanel.this.tmpselection);
                        ((PackageManagerEditPanel)PackageManagerEditPanel.this).detView.packagesTable.setRowSelectionInterval(PackageManagerEditPanel.this.tmpselection, PackageManagerEditPanel.this.tmpselection);
                    }
                } else {
                    PackageManagerEditPanel.this.tmpselection = ((PackageManagerEditPanel)PackageManagerEditPanel.this).detView.packagesTable.getSelectedRow();
                }
                PackageManagerEditPanel.this.detView.setRowSelectedInTable(((PackageManagerEditPanel)PackageManagerEditPanel.this).detView.packagesTable.getSelectedRow());
                if (PackageManagerEditPanel.this.detView.getRowSelectedInTable() != previousSelectedRow) {
                    PackageManagerEditPanel.this.refreshFooter();
                }
            }
        });
        this.footerComponent = null == this.detView.getFooterComponent() ? new JLabel(Messages.getString("PackageManagerEdit.datainput.noPackageSelected")) : this.detView.getFooterComponent();
        this.splity = new JSplitPane(0, true, this.mainComponent, this.footerComponent);
        this.splity.setDividerLocation(0.5);
        this.add((Component)this.splity, this.cc.xy(1, 3));
        this.infoFooter = this.detView.infoFooter();
        this.add((Component)this.infoFooter, this.cc.xy(1, 4));
        this.detView.packagesTable.getModel().addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                try {
                    PackageManagerEditPanel.this.refreshInfoFooter();
                }
                catch (PackageManagerException e1) {
                    e1.printStackTrace();
                    ErrorManager.getDefault().notify((Throwable)e1);
                }
                PackageManagerEditPanel.this.refreshFooter();
            }
        });
        this.setPreferredSize(new Dimension(800, 600));
    }

    public void doEdit() {
        JButton cancelButton = new JButton(Messages.getString("Cancel"));
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((PackageManagerEditPanel)PackageManagerEditPanel.this).detView.packagesTable.clearSelection();
            }
        });
        JButton doSomething = new JButton();
        String buttonDoSomthingText = "";
        doSomething.setVisible(true);
        if (this.node.getName().equalsIgnoreCase(Messages.getString("node.AvailablePackagesNode"))) {
            buttonDoSomthingText = Messages.getString("PackageManagerEditPanel.button.AvailablePackagesNode");
        } else if (this.node.getName().equalsIgnoreCase(Messages.getString("node.InstalledPackagesNode"))) {
            buttonDoSomthingText = Messages.getString("PackageManagerEditPanel.button.InstalledPackagesNode");
        } else if (this.node.getName().equalsIgnoreCase(Messages.getString("node.UpdatablePackagesNode"))) {
            buttonDoSomthingText = Messages.getString("PackageManagerEditPanel.button.UpdatablePackagesNode");
        } else if (this.node.getName().equalsIgnoreCase(Messages.getString("node.AlreadyDeletedPackagesNode"))) {
            buttonDoSomthingText = Messages.getString("PackageManagerEditPanel.button.AlreadyDeletedPackagesNode");
        } else if (this.node.getName().equalsIgnoreCase(Messages.getString("node.DebianFilePackagesNode"))) {
            buttonDoSomthingText = Messages.getString("PackageManagerEditPanel.button.DebianFilePackagesNode");
        }
        if (buttonDoSomthingText.length() > 0) {
            doSomething.setText(buttonDoSomthingText);
            doSomething.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PackageManagerEditPanel.this.doSomethingAction();
                }
            });
            doSomething.setVisible(true);
        }
        JButton selectAll = new JButton(Messages.getString("selectAll"));
        selectAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PackageManagerEditPanel.this.detView.setBooleanValueAtSearchedPackages(true);
                PackageManagerEditPanel.this.refreshMain();
            }
        });
        selectAll.setVisible(true);
        JButton deselectAll = new JButton(Messages.getString("deselectAll"));
        deselectAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PackageManagerEditPanel.this.detView.setBooleanValueAtSearchedPackages(false);
                PackageManagerEditPanel.this.refreshMain();
            }
        });
        deselectAll.setVisible(true);
        CellConstraints cc = new CellConstraints();
        JPanel jpl = new JPanel((LayoutManager)new FormLayout("l:p,c:p:g,r:p", "f:p:g"));
        ButtonBarBuilder builder1 = new ButtonBarBuilder();
        ButtonBarBuilder builder2 = new ButtonBarBuilder();
        builder1.addGridded((JComponent)selectAll);
        builder1.addGridded((JComponent)deselectAll);
        builder2.addGridded((JComponent)cancelButton);
        builder2.addGridded((JComponent)doSomething);
        jpl.add((Component)builder1.getPanel(), cc.xy(1, 1));
        jpl.add((Component)new JPanel(), cc.xy(2, 1));
        jpl.add((Component)builder2.getPanel(), cc.xy(3, 1));
        DialogDescriptor descriptor = new DialogDescriptor((Object)this, this.node.getName(), true, new Object[]{jpl}, (Object)doSomething, 0, null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
            }
        });
        descriptor.setClosingOptions(new Object[]{cancelButton, doSomething});
        final Dialog dialog = DialogDisplayer.getDefault().createDialog(descriptor);
        dialog.addWindowListener(new WindowListener(){

            public void windowOpened(WindowEvent e) {
            }

            public void windowIconified(WindowEvent e) {
            }

            public void windowDeiconified(WindowEvent e) {
            }

            public void windowDeactivated(WindowEvent e) {
            }

            public void windowClosing(WindowEvent e) {
                dialog.setVisible(false);
                dialog.dispose();
                try {
                    PackageManagerEditPanel.this.detView.finalize();
                    this.finalize();
                }
                catch (Throwable e1) {
                    e1.printStackTrace();
                    ErrorManager.getDefault().notify(e1);
                }
            }

            public void windowClosed(WindowEvent e) {
            }

            public void windowActivated(WindowEvent e) {
            }
        });
        int maxSize = dialog.getComponents()[0].getHeight() - this.getComponents()[0].getHeight() - this.getComponents()[1].getHeight();
        if ((double)maxSize * 0.9 < (double)((this.detView.packagesTable.getRowCount() + 1) * this.detView.packagesTable.getRowHeight() + 5)) {
            this.splity.setDividerLocation(0.5);
        } else {
            this.splity.setDividerLocation((this.detView.packagesTable.getRowCount() + 1) * this.detView.packagesTable.getRowHeight() + 5);
        }
        dialog.setIconImage(Utilities.loadImage((String)"org/openthinclient/console/icon.png", (boolean)true));
        dialog.setVisible(true);
    }

    public void doSomethingAction() {
        if (this.node.getName().equalsIgnoreCase(Messages.getString("node.AvailablePackagesNode"))) {
            InstallAction.installPackages(this.node, this.detView.getSlecetedItems());
        } else if (this.node.getName().equalsIgnoreCase(Messages.getString("node.InstalledPackagesNode"))) {
            DeleteAction.deletePackages(this.detView.getSlecetedItems(), this.node);
        } else if (this.node.getName().equalsIgnoreCase(Messages.getString("node.UpdatablePackagesNode"))) {
            UpdateAction.updatePackages(this.node, this.detView.getSlecetedItems());
        } else if (this.node.getName().equalsIgnoreCase(Messages.getString("node.AlreadyDeletedPackagesNode"))) {
            RealyDeleteAction.realyDeletePackages(this.detView.getSlecetedItems(), this.node);
        } else if (this.node.getName().equalsIgnoreCase(Messages.getString("node.DebianFilePackagesNode"))) {
            DebianPackagesDeleteAction.deleteDebianPackages(this.detView.getSlecetedItems(), this.node);
        }
    }

    private void refreshFooter() {
        if (null != this.splity) {
            int tempDivLoc = 0;
            tempDivLoc = this.splity.getDividerLocation();
            this.footerComponent = this.detView.getFooterComponent();
            this.splity.setBottomComponent(this.footerComponent);
            this.splity.setDividerLocation(tempDivLoc);
        } else {
            this.footerComponent = this.detView.getFooterComponent();
            this.splity.setBottomComponent(this.footerComponent);
        }
    }

    private void refreshMain() {
        if (null != this.mainComponent) {
            this.mainComponent.setSize(800, this.detView.packagesTable.getRowCount() * this.detView.packagesTable.getRowHeight());
            int tempDivLoc = 0;
            tempDivLoc = this.splity.getDividerLocation();
            this.mainComponent = this.detView.getMainComponent();
            this.mainComponent.setSize(800, this.detView.packagesTable.getRowCount() * this.detView.packagesTable.getRowHeight());
            this.splity.setTopComponent(this.mainComponent);
            this.splity.setDividerLocation(tempDivLoc);
        } else {
            this.mainComponent = this.detView.getMainComponent();
        }
    }

    private void refreshInfoFooter() throws PackageManagerException {
        if (this.getComponents().length > 3) {
            this.remove(3);
            this.infoFooter = this.detView.infoFooter();
            this.add((Component)this.infoFooter, this.cc.xy(1, 4));
            this.revalidate();
            this.validate();
            this.repaint();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DialogPackageDetailViewEditorPanel
    extends AbstractDetailView {
        private static DialogPackageDetailViewEditorPanel detailView;
        private int rowSelectedInTable = -1;
        private JTextField queryField;
        public JTable packagesTable;
        private boolean showDebFile;
        private JComponent mainComponent;
        private StringFilterTableModel tableModel;
        private SunTableSorter sts;
        private Node packnode;
        private Node[] selection;
        private TopComponent tc;
        private PackageManagerDelegation pkgmgr;
        public static final int INSTALL = 0;
        public static final int BOTH = 2;
        private boolean allowSelection = false;
        private SizeInfoPanel sip;

        DialogPackageDetailViewEditorPanel() {
        }

        public static DialogPackageDetailViewEditorPanel getInstance() {
            if (null == detailView) {
                detailView = new DialogPackageDetailViewEditorPanel();
            }
            return detailView;
        }

        public int getRowSelectedInTable() {
            return this.rowSelectedInTable;
        }

        @Override
        public JComponent getHeaderComponent() {
            this.getMainComponent();
            DefaultFormBuilder dfb = new DefaultFormBuilder(new FormLayout("p, 10dlu, r:p, 3dlu, f:p:g"));
            dfb.setDefaultDialogBorder();
            dfb.setLeadingColumnOffset(2);
            dfb.setColumn(3);
            this.queryField = new JTextField();
            dfb.append(Messages.getString("DirObjectListNode.filter"), (Component)this.queryField);
            dfb.nextLine();
            this.queryField.getDocument().addDocumentListener(new DocumentListener(){

                public void changedUpdate(DocumentEvent e) {
                    DialogPackageDetailViewEditorPanel.this.tableModel.setFilter(DialogPackageDetailViewEditorPanel.this.queryField.getText());
                }

                public void removeUpdate(DocumentEvent e) {
                    DialogPackageDetailViewEditorPanel.this.tableModel.setFilter(DialogPackageDetailViewEditorPanel.this.queryField.getText());
                }

                public void insertUpdate(DocumentEvent e) {
                    DialogPackageDetailViewEditorPanel.this.tableModel.setFilter(DialogPackageDetailViewEditorPanel.this.queryField.getText());
                }

                protected void finalize() throws Throwable {
                    DialogPackageDetailViewEditorPanel.this.tableModel.setFilter("");
                    DialogPackageDetailViewEditorPanel.this.packagesTable.clearSelection();
                    super.finalize();
                }
            });
            dfb.add((Component)new JLabel(IconManager.getInstance(DetailViewProvider.class, (String)"icons").getIcon("tree.PackageListQuery")), new CellConstraints(1, 1, 1, dfb.getRowCount(), CellConstraints.CENTER, CellConstraints.TOP));
            return dfb.getPanel();
        }

        @Override
        public JComponent getMainComponent() {
            if (null == this.mainComponent) {
                this.packagesTable = new JTable();
                this.tableModel = new StringFilterTableModel();
                this.sts = new SunTableSorter((TableModel)this.tableModel);
                this.sts.setTableHeader(this.packagesTable.getTableHeader());
                this.packagesTable.setModel((TableModel)this.sts);
                this.mainComponent = new JScrollPane(this.packagesTable);
                this.mainComponent.setBackground(UIManager.getColor("TextField.background"));
            } else {
                this.packagesTable.clearSelection();
            }
            return this.mainComponent;
        }

        @Override
        public void init(Node[] selection, TopComponent tc) {
            this.mainComponent = null;
            this.packagesTable = null;
            this.tableModel = null;
            this.queryField = null;
            this.packnode = null;
            this.selection = null;
            this.sts = null;
            this.tc = null;
            this.selection = selection;
            this.tc = tc;
            for (Node node : selection) {
                if (!(node instanceof PackageListNode)) continue;
                this.packnode = node;
                this.setPackageList((PackageListNode)node, tc, null);
                this.pkgmgr = ((PackageManagementNode)this.packnode.getParentNode()).getPackageManagerDelegation();
                break;
            }
        }

        private void setPackageList(PackageListNode pln, TopComponent tc, Node node) {
            this.showDebFile = false;
            if (pln.getName().equalsIgnoreCase(Messages.getString("node.AvailablePackagesNode"))) {
                this.showDebFile = true;
            }
            this.getMainComponent();
            this.tableModel.setTableModel(new PackageListTableModel(pln, this.allowSelection, this.showDebFile));
            if (this.showDebFile) {
                this.packagesTable.getColumn(Messages.getString("node.PackageListNode.getColumnName.isDebLocal")).setCellRenderer(new DefaultTableCellRenderer(){

                    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                        JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                        if (value != null) {
                            label.setText("");
                            label.setIcon((ImageIcon)value);
                        }
                        return label;
                    }
                });
                this.packagesTable.getColumnModel().removeColumn(this.packagesTable.getColumn(Messages.getString("node.PackageListNode.getColumnName.isDebLocal.DontShow")));
            }
            this.sts.setSortingStatus(1, 1);
        }

        public void setBooleanValueAtSearchedPackages(boolean b) {
            int columnValue = this.packagesTable.getColumnModel().getColumnIndex(Messages.getString("node.PackageListNode.getColumnName.tagged"));
            for (int i = 0; i < this.packagesTable.getRowCount(); ++i) {
                this.packagesTable.setValueAt(b, i, columnValue);
            }
        }

        @Override
        public JComponent getFooterComponent() {
            DetailView detail = null;
            if (this.tableModel.getTableModel().getClass() == PackageListTableModel.class) {
                if (this.rowSelectedInTable > -1 && this.rowSelectedInTable < this.packagesTable.getRowCount()) {
                    boolean isSet = false;
                    Node[] nodeArray = new Node[1];
                    for (Node nodele : this.selection) {
                        if (null == nodele) continue;
                        for (Node nodelele : nodele.getChildren().getNodes()) {
                            if (null == nodelele || !nodelele.getName().equalsIgnoreCase((String)this.packagesTable.getValueAt(this.rowSelectedInTable, this.packagesTable.getColumnModel().getColumnIndex(Messages.getString("node.PackageListNode.getColumnName.name"))))) continue;
                            detail = new PackageNode(this.packnode, ((PackageListTableModel)this.tableModel.getTableModel()).getPackageAtRow(this.rowSelectedInTable)).getDetailView();
                            nodeArray[0] = nodelele;
                            detail.init(nodeArray, this.tc);
                            isSet = true;
                        }
                    }
                    if (isSet) {
                        JComponent jco = detail.getMainComponent();
                        return jco;
                    }
                    return new JLabel(Messages.getString("PackageDetailView.noRowSelected"));
                }
                return new JLabel(Messages.getString("PackageDetailView.noRowSelected"));
            }
            return new JLabel(Messages.getString("PackageDetailView.noRowSelected"));
        }

        public JComponent infoFooter() throws PackageManagerException {
            CellConstraints cc = new CellConstraints();
            JPanel jpl = new JPanel();
            jpl.setLayout((LayoutManager)new FormLayout("f:p:g", "f:p:g"));
            try {
                if (this.packnode.getName().equalsIgnoreCase(Messages.getString("node.AvailablePackagesNode"))) {
                    jpl.add((Component)this.getInstallSize(2), cc.xy(1, 1));
                } else if (this.packnode.getName().equalsIgnoreCase(Messages.getString("node.DebianFilePackagesNode"))) {
                    jpl.add((Component)this.getInstallSize(0), cc.xy(1, 1));
                } else {
                    jpl.add((Component)this.getInstallSize(0), cc.xy(1, 1));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                ErrorManager.getDefault().notify((Throwable)e);
            }
            return jpl;
        }

        public String getTitle() {
            return null;
        }

        public boolean isAllowSelection() {
            return this.allowSelection;
        }

        public void setAllowSelection(boolean allowSelection) {
            this.allowSelection = allowSelection;
        }

        public Collection<Package> getSlecetedItems() {
            return ((PackageListTableModel)this.tableModel.getTableModel()).getSelectedPackages();
        }

        public JComponent getInstallSize(int what) throws IOException, PackageManagerException {
            if (null == this.sip) {
                this.sip = new SizeInfoPanel(what);
            }
            this.sip.update(what);
            return this.sip;
        }

        public void setRowSelectedInTable(int rowSelectedInTable) {
            this.rowSelectedInTable = rowSelectedInTable;
        }

        public int getTableHight() {
            return this.packagesTable.getRowHeight() * (this.packagesTable.getRowCount() + 1);
        }

        public void setValueAt(int i) {
            this.packagesTable.setValueAt(true, i, this.packagesTable.getColumnModel().getColumnIndex(Messages.getString("node.PackageListNode.getColumnName.tagged")));
        }

        protected void finalize() throws Throwable {
            super.finalize();
        }

        private class SizeInfoPanel
        extends JPanel {
            private static final long serialVersionUID = 1L;
            private final JLabel installedSize;
            private final JLabel cacheSize;
            private JLabel freeDiskLabel;
            private final JLabel installedSizeLabel;
            private final JLabel cacheSizeLabel;

            public SizeInfoPanel(int what) {
                DefaultFormBuilder dfb = new DefaultFormBuilder(new FormLayout("l:p,15dlu,l:p,15dlu,l:p,15dlu,l:p,15dlu,l:p,15dlu", "f:p:g"), (JPanel)this);
                this.installedSize = new JLabel();
                this.installedSizeLabel = dfb.append(Messages.getString("size.InstalledSize"), (Component)this.installedSize, false);
                this.cacheSize = new JLabel();
                this.cacheSizeLabel = dfb.append(Messages.getString("size.CacheSize"), (Component)this.cacheSize, false);
                dfb.nextLine();
                this.freeDiskLabel = new JLabel((float)Math.round((float)DialogPackageDetailViewEditorPanel.this.pkgmgr.getFreeDiskSpace() / 1024.0f) + " " + Messages.getString("size.unit"));
                dfb.append(Messages.getString("size.freeDiskSpace"), (Component)this.freeDiskLabel);
                this.update(what);
            }

            void update(int what) {
                this.freeDiskLabel = new JLabel((float)Math.round((float)DialogPackageDetailViewEditorPanel.this.pkgmgr.getFreeDiskSpace() / 1024.0f) + " " + Messages.getString("size.unit"));
                this.installedSize.setText(((PackageListTableModel)DialogPackageDetailViewEditorPanel.this.tableModel.getTableModel()).getUsedInstallSpace());
                this.cacheSize.setText(((PackageListTableModel)DialogPackageDetailViewEditorPanel.this.tableModel.getTableModel()).getUsedCacheSpace());
                this.installedSize.setVisible(what == 2 || what == 0);
                this.installedSizeLabel.setVisible(what == 2 || what == 0);
                this.cacheSize.setVisible(what == 2);
                this.cacheSizeLabel.setVisible(what == 2);
                this.freeDiskLabel.setVisible(true);
            }
        }
    }
}

