/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console.nodes.pkgmgr;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.levigo.util.swing.SwingWorker;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.beans.PropertyVetoException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.Timer;
import javax.swing.UIManager;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.nodes.Node;
import org.openide.util.Utilities;
import org.openthinclient.common.directory.LDAPDirectory;
import org.openthinclient.common.model.Application;
import org.openthinclient.common.model.Realm;
import org.openthinclient.common.model.schema.provider.HTTPSchemaProvider;
import org.openthinclient.common.model.schema.provider.SchemaLoadingException;
import org.openthinclient.console.ConsoleFrame;
import org.openthinclient.console.MainTreeTopComponent;
import org.openthinclient.console.Messages;
import org.openthinclient.console.nodes.DirObjectListNode;
import org.openthinclient.console.nodes.RealmNode;
import org.openthinclient.console.nodes.pkgmgr.PackageManagementNode;
import org.openthinclient.console.nodes.pkgmgr.PackageManagerDelegation;
import org.openthinclient.console.util.DetailViewFormBuilder;
import org.openthinclient.ldap.DirectoryException;
import org.openthinclient.pkgmgr.PackageManagerException;
import org.openthinclient.util.dpkg.Package;

public final class PackageManagerJobQueue {
    public static boolean errorExisting = false;
    private static final Object lock = new Object();
    private static PackageManagerJobQueue singletonInstance;
    private JobQueue jobQueue;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PackageManagerJobQueue getInstance() {
        Object object = lock;
        synchronized (object) {
            if (null == singletonInstance) {
                singletonInstance = new PackageManagerJobQueue();
            }
        }
        singletonInstance.instanceValidation();
        return singletonInstance;
    }

    private PackageManagerJobQueue() {
        this.instanceValidation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void instanceValidation() {
        Object object = lock;
        synchronized (object) {
            if (null == this.jobQueue || !this.jobQueue.isAlive()) {
                this.createJobQueue();
            }
        }
    }

    private void createJobQueue() {
        this.jobQueue = new JobQueue();
        this.jobQueue.setPriority(1);
        this.jobQueue.setDaemon(true);
        this.jobQueue.start();
    }

    public void addPackageManagerJob(Job job) {
        this.instanceValidation();
        this.jobQueue.addJob(job);
    }

    private void destroyJobQueue() {
        if (null != this.jobQueue || this.jobQueue.isAlive()) {
            this.jobQueue.interrupt();
        }
    }

    private final class JobQueue
    extends Thread {
        private LinkedList<Job> queue;

        private JobQueue() {
            super("JobQueue");
            this.queue = new LinkedList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (!Thread.currentThread().isInterrupted()) {
                    Job nextJob = null;
                    JobQueue jobQueue = this;
                    synchronized (jobQueue) {
                        while (this.queue.size() == 0) {
                            try {
                                this.wait();
                            }
                            catch (InterruptedException e) {
                                PackageManagerJobQueue.this.jobQueue = null;
                                ErrorManager.getDefault().notify((Throwable)e);
                                this.notify();
                            }
                        }
                        nextJob = this.queue.removeFirst();
                    }
                    if (nextJob == null) continue;
                    nextJob.doJob();
                }
                PackageManagerJobQueue.this.jobQueue = null;
                this.queue = null;
            }
            catch (ThreadDeath td) {
                ErrorManager.getDefault().notify((Throwable)td);
                PackageManagerJobQueue.this.jobQueue = null;
                throw td;
            }
            catch (OutOfMemoryError ooe) {
                ErrorManager.getDefault().notify((Throwable)ooe);
                PackageManagerJobQueue.this.jobQueue = null;
                throw ooe;
            }
        }

        synchronized void addJob(Job job) {
            this.queue.addLast(job);
            this.notify();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Job {
        Node node;
        Collection<Package> packageCollection;
        List<Package> packageList;
        PackageManagerDelegation pkgmgr;
        Timer timer;
        public static final int ONE_SECOND = 200;
        private JProgressBar progressBar;
        private JLabel jLInfo;
        private boolean moreInformation = false;
        ProgressbarWorker pgw;
        public static final int REFRESH_ALL_PACKAGES = 0;
        public static final int REFRESH_INSTALLED_PACKAGES = 1;
        public static final int REFRESH_INSTALLABLE_PACKAGES = 2;
        public static final int REFRESH_UPDATEABLE_PACKAGES = 3;
        public static final int REFRESH_REMOVED_PACKAGES = 4;
        public static final int REFRESH_DEBIAN_PACKAGES = 5;
        private JDialog progressDialog;

        public Job(Node node, Collection<Package> packageCollection) {
            this.node = node;
            this.packageCollection = packageCollection;
            this.packageList = new ArrayList<Package>(packageCollection);
            this.pkgmgr = this.getPackageManagementNode(node).getPackageManagerDelegation();
        }

        public Job(Node node) {
            this.node = node;
            this.pkgmgr = this.getPackageManagementNode(node).getPackageManagerDelegation();
        }

        public Node getNode() {
            return this.node;
        }

        abstract Object doPMJob() throws PackageManagerException;

        public boolean doErrorLoadForApplication(Realm realm, List<Application> applicationSet) {
            DetailViewFormBuilder dfb = new DetailViewFormBuilder(new FormLayout("f:p:g"));
            for (Application appl : applicationSet) {
                try {
                    dfb.append(new JLabel(Messages.getString("Job.ApplicationAlreadyUsed", appl.getName(), appl.getSchema(realm).getName())));
                }
                catch (SchemaLoadingException e1) {
                    e1.printStackTrace();
                    ErrorManager.getDefault().notify((Throwable)e1);
                }
            }
            dfb.nextLine();
            dfb.append(new JLabel(Messages.getString("Job.ApplicationAlreadyUsedQuestion")));
            DialogDescriptor descriptor = new DialogDescriptor((Object)dfb.getPanel(), this.getNodeAction(), true, new Object[]{DialogDescriptor.CANCEL_OPTION, DialogDescriptor.OK_OPTION}, null, 0, null, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                }
            });
            descriptor.setClosingOptions(new Object[]{DialogDescriptor.OK_OPTION, DialogDescriptor.CANCEL_OPTION});
            Dialog dialog = DialogDisplayer.getDefault().createDialog(descriptor);
            dialog.setIconImage(Utilities.loadImage((String)"org/openthinclient/console/icon.png", (boolean)true));
            dialog.setVisible(true);
            if (descriptor.getValue() == DialogDescriptor.OK_OPTION) {
                boolean ret = true;
                for (Application appl : applicationSet) {
                    try {
                        LDAPDirectory dir = realm.getDirectory();
                        if (dir.delete((Object)appl)) continue;
                        ret = false;
                    }
                    catch (DirectoryException e1) {
                        e1.printStackTrace();
                        ret = false;
                        ErrorManager.getDefault().notify((Throwable)e1);
                    }
                }
                if (ret) {
                    for (Node tmp = this.node; tmp != null; tmp = tmp.getParentNode()) {
                        if (!(tmp instanceof RealmNode)) continue;
                        for (Node chilnode : ((RealmNode)tmp).getChildren().getNodes()) {
                            if (!chilnode.getName().equalsIgnoreCase(Messages.getString("Applications_title"))) continue;
                            ((DirObjectListNode)chilnode).refresh();
                        }
                    }
                }
                return ret;
            }
            return false;
        }

        public boolean accepptLicenseDialog(String packageName, String licenseText) {
            JTextArea jta = new JTextArea(licenseText);
            jta.setFocusable(false);
            jta.setLineWrap(true);
            jta.setWrapStyleWord(true);
            JScrollPane scrollPane = new JScrollPane(jta);
            JButton okButton = new JButton("I Accept");
            okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                }
            });
            DialogDescriptor descriptor = new DialogDescriptor((Object)scrollPane, "License Agreement for Package " + packageName, true, new Object[]{DialogDescriptor.CANCEL_OPTION, okButton}, null, 0, null, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                }
            });
            descriptor.setClosingOptions(new Object[]{okButton, DialogDescriptor.CANCEL_OPTION});
            Dialog licenseDialog = DialogDisplayer.getDefault().createDialog(descriptor);
            licenseDialog.setPreferredSize(new Dimension(640, 480));
            licenseDialog.setMinimumSize(new Dimension(640, 480));
            licenseDialog.pack();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            licenseDialog.setLocation((screenSize.width - licenseDialog.getWidth()) / 2, (screenSize.height - licenseDialog.getHeight()) / 2);
            licenseDialog.setIconImage(Utilities.loadImage((String)"org/openthinclient/console/icon.png", (boolean)true));
            licenseDialog.setVisible(true);
            return descriptor.getValue() == okButton;
        }

        public void loadDialog(final PackageManagerDelegation pm) {
            CellConstraints cc = new CellConstraints();
            Font f = UIManager.getFont("TitledBorder.font");
            f = f.deriveFont(1, AffineTransform.getScaleInstance(1.5, 1.5));
            this.progressDialog = new JDialog((Frame)ConsoleFrame.getINSTANCE(), true);
            this.progressDialog.setResizable(false);
            final JPanel cp = new JPanel((LayoutManager)new FormLayout("f:p:g", "p,p,p"));
            cp.setPreferredSize(new Dimension(300, 100));
            this.progressDialog.setContentPane(cp);
            this.progressDialog.setIconImage(Utilities.loadImage((String)"org/openthinclient/console/icon.png", (boolean)true));
            cp.setBorder(Borders.DIALOG_BORDER);
            JLabel jl2 = new JLabel(Messages.getString("pleasewait"));
            jl2.setFont(f);
            jl2.setForeground(new Color(50, 50, 150));
            cp.add((Component)jl2, cc.xy(1, 1));
            Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
            cp.setLocation(new Double(dim.getWidth()).intValue() / 2 - 150, new Double(dim.getHeight()).intValue() / 2 - 150);
            cp.setSize(new Dimension(300, 100));
            this.progressBar = new JProgressBar(0, pm.getMaxProgress());
            this.progressBar.setValue(0);
            this.progressBar.setStringPainted(true);
            pm.resetValuesForDisplaying();
            this.jLInfo = new JLabel(" ");
            cp.add((Component)this.jLInfo, cc.xy(1, 3));
            if (this.node.getName().equalsIgnoreCase(Messages.getString("node.AvailablePackagesNode")) || this.node.getName().equalsIgnoreCase(Messages.getString("node.UpdatablePackagesNode"))) {
                this.moreInformation = true;
            }
            this.timer = new Timer(200, new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    while (!(pm.isDone() || Thread.interrupted() || errorExisting)) {
                        Job.this.progressBar.setValue(pm.getActprogress());
                        if (Job.this.moreInformation && null != pm.getActPackName()) {
                            Job.this.jLInfo.setText(pm.getActPackName() + ": " + pm.getActMaxFileSize()[0] + "KB / " + pm.getActMaxFileSize()[1] + "KB");
                        }
                        cp.repaint();
                        cp.paint(cp.getGraphics());
                        try {
                            if (!Thread.interrupted()) {
                                Thread.sleep(300L);
                                continue;
                            }
                            Job.this.timer.stop();
                        }
                        catch (InterruptedException e) {
                            Job.this.timer.stop();
                            ErrorManager.getDefault().notify((Throwable)e);
                        }
                    }
                    Job.this.timer.stop();
                }
            });
            cp.add((Component)this.progressBar, cc.xy(1, 2));
            this.timer.start();
            this.progressDialog.setContentPane(cp);
            this.progressDialog.pack();
            this.pgw = new ProgressbarWorker(this, this.progressDialog);
            this.pgw.start();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            this.progressDialog.setLocation((screenSize.width - this.progressDialog.getWidth()) / 2, (screenSize.height - this.progressDialog.getHeight()) / 2);
            this.progressDialog.getSize();
            this.progressDialog.setIconImage(Utilities.loadImage((String)"org/openthinclient/console/icon.png", (boolean)true));
            this.progressDialog.setVisible(true);
        }

        private void stopTimer() {
            this.timer.stop();
        }

        public void createInformationOptionPane(boolean reloadSchemaProviderOption) {
            if (reloadSchemaProviderOption) {
                Realm realm = (Realm)this.node.getLookup().lookup(Realm.class);
                String hostname = realm.getConnectionDescriptor().getHostname();
                try {
                    realm.removeSchemaProvider();
                    realm.setNeedsRefresh();
                    HTTPSchemaProvider httpsp = new HTTPSchemaProvider(hostname);
                    httpsp.reload();
                }
                catch (MalformedURLException e2) {
                    e2.printStackTrace();
                    ErrorManager.getDefault().notify((Throwable)e2);
                }
            }
            this.progressBar.setValue(this.pkgmgr.getActprogress());
            this.progressDialog.setVisible(false);
            this.progressDialog.validate();
            this.progressDialog.dispose();
            this.timer.stop();
            String message = "";
            message = this.node.getName().equalsIgnoreCase(Messages.getString("node.AvailablePackagesNode")) ? Messages.getString("action.end.allpackagesinstalled") : (this.node.getName().equalsIgnoreCase(Messages.getString("node.InstalledPackagesNode")) ? Messages.getString("action.end.allpackagesdeleted") : (this.node.getName().equalsIgnoreCase(Messages.getString("node.UpdatablePackagesNode")) ? Messages.getString("action.end.allpackagesupdated") : (this.node.getName().equalsIgnoreCase(Messages.getString("node.AlreadyDeletedPackagesNode")) ? Messages.getString("action.end.allpackagesdeleted") : (this.node.getName().equalsIgnoreCase(Messages.getString("node.DebianFilePackagesNode")) ? Messages.getString("action.end.allfilesdeleted") : Messages.getString("action.end.reloadCacheDB")))));
            JLabel what = new JLabel(message);
            while (this.progressDialog.isVisible()) {
                try {
                    this.progressDialog.setVisible(false);
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    ErrorManager.getDefault().notify((Throwable)e);
                }
            }
            DialogDescriptor descriptor = new DialogDescriptor((Object)what, this.getNodeAction(), true, new Object[]{DialogDescriptor.OK_OPTION}, DialogDescriptor.OK_OPTION, -1, null, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                }
            });
            descriptor.setClosingOptions(new Object[]{DialogDescriptor.OK_OPTION});
            Dialog readyDialog = DialogDisplayer.getDefault().createDialog(descriptor);
            readyDialog.setIconImage(Utilities.loadImage((String)"org/openthinclient/console/icon.png", (boolean)true));
            readyDialog.setVisible(true);
        }

        public String getNodeAction() {
            String ret = "";
            ret = this.node.getName().equalsIgnoreCase(Messages.getString("node.AvailablePackagesNode")) ? Messages.getString("installAction.getName") : (this.node.getName().equalsIgnoreCase(Messages.getString("node.InstalledPackagesNode")) ? Messages.getString("deleteAction.getName") : (this.node.getName().equalsIgnoreCase(Messages.getString("node.UpdatablePackagesNode")) ? Messages.getString("updateAction.getName") : (this.node.getName().equalsIgnoreCase(Messages.getString("node.AlreadyDeletedPackagesNode")) ? Messages.getString("realyDeleteAction.getName") : (this.node.getName().equalsIgnoreCase(Messages.getString("node.DebianFilePackagesNode")) ? Messages.getString("deleteAction.getName") : Messages.getString("reloadAction.getName")))));
            return ret;
        }

        abstract void doJob();

        public void dontWantToInstall() {
            this.packageList.removeAll(this.packageList);
        }

        public boolean checkIfApplicationsLinkToPackages() {
            Realm realm = (Realm)this.node.getLookup().lookup(Realm.class);
            ArrayList<Application> applSet = new ArrayList<Application>();
            try {
                for (Application appl : realm.getDirectory().list(Application.class)) {
                    for (Package pkg : this.packageList) {
                        if (!pkg.getName().equalsIgnoreCase(appl.getSchema(realm).getName())) continue;
                        applSet.add(appl);
                    }
                }
            }
            catch (SchemaLoadingException e) {
                e.printStackTrace();
                ErrorManager.getDefault().notify((Throwable)e);
            }
            catch (DirectoryException e) {
                e.printStackTrace();
                ErrorManager.getDefault().notify((Throwable)e);
            }
            boolean ret = false;
            if (applSet.size() == 0) {
                ret = true;
            } else if (this.doErrorLoadForApplication(realm, applSet)) {
                ret = true;
            }
            return ret;
        }

        public PackageManagementNode getPackageManagementNode(Node node) {
            if (node instanceof PackageManagementNode) {
                return (PackageManagementNode)node;
            }
            if (node.getParentNode() instanceof PackageManagementNode) {
                return (PackageManagementNode)node.getParentNode();
            }
            return null;
        }
    }

    static final class ProgressbarWorker
    extends SwingWorker {
        Job job;
        final Dialog jd;
        private boolean isAccomplished = true;

        public ProgressbarWorker(Job job, Dialog progressbarDialog) {
            this.job = job;
            this.jd = progressbarDialog;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object construct() {
            try {
                Object o = this.job.doPMJob();
                try {
                    MainTreeTopComponent.getDefault().getExplorerManager().setSelectedNodes(new Node[]{this.job.node});
                }
                catch (PropertyVetoException e) {
                    e.printStackTrace();
                    ErrorManager.getDefault().notify((Throwable)e);
                }
                finally {
                    this.jd.setVisible(false);
                }
                Object object = o;
                return object;
            }
            catch (Exception e) {
                e.printStackTrace();
                ErrorManager.getDefault().notify((Throwable)e);
                PackageManagerJobQueue.getInstance().destroyJobQueue();
                this.interrupt();
                this.isAccomplished = false;
                errorExisting = true;
                Boolean bl = false;
                return bl;
            }
            finally {
                this.jd.setVisible(false);
                this.jd.setIconImage(Utilities.loadImage((String)"org/openthinclient/console/icon.png", (boolean)true));
                this.job.stopTimer();
                for (String warning : this.job.pkgmgr.getWarnings()) {
                    ErrorManager.getDefault().notify(new Throwable(warning));
                }
            }
        }

        public void refreshnode(Node node) {
            while (node != null) {
                if (node instanceof PackageManagementNode) {
                    ((PackageManagementNode)node).refresh();
                }
                node = node.getParentNode();
            }
        }

        public void finished() {
            if (this.isAccomplished) {
                this.jd.setVisible(false);
                this.jd.dispose();
                this.refreshnode(this.job.getNode());
            }
        }
    }
}

