/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console.nodes.pkgmgr;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.levigo.util.swing.IconManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.TopComponent;
import org.openthinclient.console.DetailView;
import org.openthinclient.console.DetailViewProvider;
import org.openthinclient.console.EditorProvider;
import org.openthinclient.console.Messages;
import org.openthinclient.console.Refreshable;
import org.openthinclient.console.nodes.MyAbstractNode;
import org.openthinclient.console.nodes.pkgmgr.AlreadyDeletedPackagesNode;
import org.openthinclient.console.nodes.pkgmgr.AvailablePackagesNode;
import org.openthinclient.console.nodes.pkgmgr.DebianFilePackagesNode;
import org.openthinclient.console.nodes.pkgmgr.DebianPackagesDeleteAction;
import org.openthinclient.console.nodes.pkgmgr.DeleteAction;
import org.openthinclient.console.nodes.pkgmgr.InstallAction;
import org.openthinclient.console.nodes.pkgmgr.InstalledPackagesNode;
import org.openthinclient.console.nodes.pkgmgr.PackageListNodeActionForPackageNode;
import org.openthinclient.console.nodes.pkgmgr.PackageManagementNode;
import org.openthinclient.console.nodes.pkgmgr.PackageManagerDelegation;
import org.openthinclient.console.nodes.pkgmgr.RealyDeleteAction;
import org.openthinclient.console.nodes.pkgmgr.UpdatablePackagesNode;
import org.openthinclient.console.nodes.pkgmgr.UpdateAction;
import org.openthinclient.console.ui.CollapsibleTitlePanel;
import org.openthinclient.console.util.DetailViewFormBuilder;
import org.openthinclient.util.dpkg.Package;

public class PackageNode
extends MyAbstractNode
implements DetailViewProvider,
EditorProvider,
Refreshable {
    public PackageNode(Node node, Package pkg) {
        super(Children.LEAF, (Lookup)new ProxyLookup(new Lookup[]{Lookups.fixed((Object[])new Object[]{pkg}), node.getLookup()}));
    }

    public String getName() {
        return ((Package)this.getLookup().lookup(Package.class)).getName();
    }

    public Action[] getActions(boolean context) {
        if (!this.isWritable()) {
            return new Action[0];
        }
        Node parentNode = this.getParentNode();
        if (parentNode instanceof InstalledPackagesNode) {
            return new Action[]{SystemAction.get(DeleteAction.class)};
        }
        if (parentNode instanceof AvailablePackagesNode) {
            return new Action[]{SystemAction.get(InstallAction.class)};
        }
        if (parentNode instanceof UpdatablePackagesNode) {
            return new Action[]{SystemAction.get(UpdateAction.class)};
        }
        if (parentNode instanceof AlreadyDeletedPackagesNode) {
            return new Action[]{SystemAction.get(RealyDeleteAction.class)};
        }
        if (parentNode instanceof DebianFilePackagesNode) {
            return new Action[]{SystemAction.get(DebianPackagesDeleteAction.class)};
        }
        return new Action[0];
    }

    public SystemAction getDefaultAction() {
        if (this.isWritable()) {
            return SystemAction.get(PackageListNodeActionForPackageNode.class);
        }
        return null;
    }

    public boolean canCopy() {
        return true;
    }

    public boolean canDestroy() {
        return false;
    }

    public boolean canRename() {
        return false;
    }

    public DetailView getDetailView() {
        return new PackageDetailView();
    }

    public DetailView getEditor() {
        return null;
    }

    public void refresh() {
    }

    public void refresh(String type) {
    }

    public Image getIcon(int type) {
        return this.getOpenedIcon(type);
    }

    public Image getOpenedIcon(int type) {
        return IconManager.getInstance(DetailViewProvider.class, (String)"icons").getImage("tree." + this.getClass().getSimpleName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class PackageDetailView
    implements DetailView {
        private Package p;
        private Node node2;
        private PackageManagerDelegation pkgmgr;

        @Override
        public JComponent getFooterComponent() {
            return null;
        }

        @Override
        public JComponent getHeaderComponent() {
            if (null == this.p) {
                return null;
            }
            DetailViewFormBuilder dfb = new DetailViewFormBuilder(new FormLayout("p, 10dlu, r:p, 3dlu, f:p:g"), Messages.getBundle());
            dfb.setLeadingColumnOffset(2);
            dfb.setColumn(3);
            String simpleClassName = this.p.getClass().getSimpleName();
            Font f = UIManager.getFont("TitledBorder.font");
            f = f.deriveFont(1, AffineTransform.getScaleInstance(1.5, 1.5));
            JLabel typeLabel = new JLabel(Messages.getString("types.singular." + simpleClassName) + ":");
            typeLabel.setForeground(new Color(10, 10, 150));
            typeLabel.setFont(f);
            JLabel nameLabel = new JLabel(this.p.getName() != null ? this.p.getName() : "");
            nameLabel.setForeground(new Color(50, 50, 200));
            nameLabel.setFont(f);
            dfb.append((Component)typeLabel, (Component)nameLabel);
            dfb.add(new JLabel(IconManager.getInstance(DetailViewProvider.class, (String)"icons").getIcon("tree." + this.p.getClass().getSimpleName())), new CellConstraints(1, 1, 1, dfb.getRowCount(), CellConstraints.CENTER, CellConstraints.TOP));
            return dfb.getPanel();
        }

        @Override
        public JComponent getMainComponent() {
            if (null == this.p) {
                return null;
            }
            String simpleClassName = "PackageData";
            Font f = UIManager.getFont("TitledBorder.font");
            f = f.deriveFont(1, AffineTransform.getScaleInstance(1.5, 1.5));
            JLabel typeLabel = new JLabel(Messages.getString("types.singular.PackageData") + ":");
            typeLabel.setForeground(new Color(10, 10, 150));
            typeLabel.setFont(f);
            JLabel generalLabel = new JLabel(this.p.getName() != null ? this.p.getName() : "");
            generalLabel.setName(Messages.getString("types.singular.PackageData") + ":");
            generalLabel.setForeground(new Color(50, 50, 200));
            generalLabel.setFont(f);
            LinkedList<JComponent> sections = new LinkedList<JComponent>();
            sections.add(this.createDescriptionPanel());
            sections.add(this.createBasePanel());
            sections.add(this.createInstallPanel());
            sections.add(this.createDependencyPanel());
            sections.add(this.createChangelogPanel());
            DetailViewFormBuilder dfb = new DetailViewFormBuilder(new FormLayout("f:p:g", "f:p"));
            for (JComponent component : sections) {
                dfb.append(new CollapsibleTitlePanel(component.getName(), component, true));
            }
            JScrollPane scrollPane = new JScrollPane(dfb.getPanel());
            scrollPane.getVerticalScrollBar().setUnitIncrement(20);
            scrollPane.setPreferredSize(scrollPane.getMinimumSize());
            scrollPane.setBorder(null);
            return scrollPane;
        }

        private JComponent createDependencyPanel() {
            DetailViewFormBuilder dfb = new DetailViewFormBuilder(new FormLayout("f:p:g", "f:p:g"));
            LinkedList<JComponent> sections = new LinkedList<JComponent>();
            sections.add(this.dependencyHandling(Messages.getString("node.PackageNode.PackageDetailView.Depends") + ":", this.p.getDepends().toString()));
            sections.add(this.dependencyHandling(Messages.getString("node.PackageNode.PackageDetailView.Pre-Depends") + ":", this.p.getPreDepends().toString()));
            sections.add(this.dependencyHandling(Messages.getString("node.PackageNode.PackageDetailView.Conflicts") + ":", this.p.getConflicts().toString()));
            sections.add(this.dependencyHandling(Messages.getString("node.PackageNode.PackageDetailView.Provides") + ":", this.p.getProvides().toString()));
            for (JComponent component : sections) {
                dfb.append(new CollapsibleTitlePanel(component.getName(), component, false));
            }
            dfb.getPanel().setName(Messages.getString("node.PackageNode.PackageDetailView.createDependencyPanel.PanelName"));
            return dfb.getPanel();
        }

        private JComponent dependencyHandling(String name, String depends) {
            DetailViewFormBuilder dfb = new DetailViewFormBuilder(new FormLayout("left:p:g"));
            while (depends.length() > 0) {
                if (depends.contains(",")) {
                    dfb.append(depends.substring(0, depends.indexOf(",")).trim());
                    depends = depends.substring(depends.indexOf(",") + 1);
                    continue;
                }
                dfb.append(depends);
                depends = "";
            }
            dfb.getPanel().setName(name);
            return dfb.getPanel();
        }

        private JComponent createDescriptionPanel() {
            DetailViewFormBuilder dfb = new DetailViewFormBuilder(new FormLayout("f:p:g:"));
            String descript = this.p.getDescription();
            if (descript == null) {
                dfb.append(new JLabel(Messages.getString("node.PackageNode.PackageDetailView.createDescriptionPanel.noDescriptionAvailable")));
                dfb.getPanel().setName(Messages.getString("node.PackageNode.PackageDetailView.createDescriptionPanel.PanelName"));
                return dfb.getPanel();
            }
            while (descript.length() > 80) {
                String temp = (descript = descript.trim()).substring(0, 80);
                if (temp.contains("\n")) {
                    dfb.append(new JLabel(temp.substring(0, temp.indexOf("\n"))));
                    dfb.append(new JLabel(""));
                    descript = descript.substring(temp.indexOf("\n") + 2);
                    continue;
                }
                dfb.append(new JLabel(descript.substring(0, temp.lastIndexOf(" "))));
                descript = descript.substring(temp.lastIndexOf(" "));
            }
            descript = descript.trim();
            while (descript.contains("\n")) {
                descript = descript.trim();
                dfb.append(new JLabel(descript.substring(0, descript.indexOf("\n"))));
                dfb.append(new JLabel(""));
                descript = descript.substring(descript.indexOf("\n") + 2);
            }
            descript = descript.trim();
            dfb.append(new JLabel(descript));
            dfb.getPanel().setName(Messages.getString("node.PackageNode.PackageDetailView.createDescriptionPanel.PanelName"));
            return dfb.getPanel();
        }

        private JComponent createInstallPanel() {
            DetailViewFormBuilder dfb = new DetailViewFormBuilder(new FormLayout("p,2dlu,left:p"));
            float groesse = this.p.getSize();
            float calcSize = groesse / 1024.0f / 1024.0f;
            calcSize *= 10000.0f;
            calcSize = (float)Math.round(calcSize) / 10000.0f;
            dfb.append(Messages.getString("node.PackageNode.PackageDetailView.Size") + ":", (Component)new JLabel(String.valueOf(calcSize) + " MB"));
            dfb.append(Messages.getString("node.PackageNode.PackageDetailView.Filename") + ":", (Component)new JLabel(this.p.getFilename().substring(this.p.getFilename().lastIndexOf("/") + 1)));
            dfb.getPanel().setName(Messages.getString("node.PackageNode.PackageDetailView.createInstallPanel.PanelName"));
            return dfb.getPanel();
        }

        private JComponent createBasePanel() {
            DetailViewFormBuilder dfb = new DetailViewFormBuilder(new FormLayout("l:p,2dlu,f:p:g"));
            String temp = this.p.getVersion().toString().startsWith("0:") ? this.p.getVersion().toString().substring(2, this.p.getVersion().toString().length()) : this.p.getVersion().toString();
            dfb.append(Messages.getString("node.PackageNode.PackageDetailView.Name") + ":", (Component)new JLabel(this.p.getName()));
            dfb.append(Messages.getString("node.PackageNode.PackageDetailView.Version") + ":", (Component)new JLabel(temp));
            dfb.append(Messages.getString("node.PackageNode.PackageDetailView.Section") + ":", (Component)new JLabel(this.p.getSection()));
            dfb.append(Messages.getString("node.PackageNode.PackageDetailView.Priority") + ":", (Component)new JLabel(this.p.getPriority()));
            dfb.getPanel().setName(Messages.getString("node.PackageNode.PackageDetailView.createBasePanel.PanelName"));
            return dfb.getPanel();
        }

        private JComponent createChangelogPanel() {
            if (this.node2.getParentNode().getName().equalsIgnoreCase(Messages.getString("node.UpdatablePackagesNode"))) {
                // empty if block
            }
            DetailViewFormBuilder dfb = new DetailViewFormBuilder(new FormLayout("f:p:g"));
            ArrayList<String> changeLog = new ArrayList<String>();
            if (this.node2.getParentNode().getName().equalsIgnoreCase(Messages.getString("node.DebianFilePackagesNode")) || this.node2.getParentNode().getName().equalsIgnoreCase(Messages.getString("node.AlreadyDeletedPackagesNode")) || null == this.pkgmgr.getChangelogFile(this.p)) {
                changeLog.add(Messages.getString("node.PackageNode.PackageDetailView.createChangelogPanel.noChangeLogFile"));
            } else {
                changeLog = new ArrayList<String>(this.pkgmgr.getChangelogFile(this.p));
            }
            List<Object> sections = new LinkedList();
            sections = this.node2.getParentNode().getName().equalsIgnoreCase(Messages.getString("node.UpdatablePackagesNode")) ? this.createChangelogListOnlyNewer(changeLog) : this.createChangelogList(changeLog);
            for (JComponent jComponent : sections) {
                dfb.append(new CollapsibleTitlePanel(jComponent.getName(), jComponent, false));
            }
            dfb.getPanel().setName(Messages.getString("node.PackageNode.PackageDetailView.createChangelogPanel.PanelName"));
            return dfb.getPanel();
        }

        private List<JComponent> createChangelogList(List<String> changeLog) {
            LinkedList<JComponent> sections = new LinkedList<JComponent>();
            ArrayList<String> lines = new ArrayList<String>();
            for (String line : changeLog) {
                if (line.length() == 0) continue;
                if (line.startsWith(this.p.getName())) {
                    if (lines.size() > 0) {
                        sections.add(this.createChangeLogEntry(lines));
                        lines.clear();
                    }
                    lines.add(line);
                    continue;
                }
                lines.add(line);
            }
            if (lines.size() > 0) {
                sections.add(this.createChangeLogEntry(lines));
            }
            return sections;
        }

        private List<JComponent> createChangelogListOnlyNewer(List<String> changeLog) {
            LinkedList<JComponent> sections = new LinkedList<JComponent>();
            ArrayList<String> lines = new ArrayList<String>();
            Package oldPack = null;
            for (Package pack : this.pkgmgr.getInstalledPackages()) {
                if (!pack.getName().equalsIgnoreCase(this.p.getName())) continue;
                oldPack = pack;
                break;
            }
            String version = oldPack.getVersion().toString().substring(oldPack.getVersion().toString().indexOf(":") + 1);
            boolean contains = false;
            for (String line : changeLog) {
                if (line.contains(version)) {
                    contains = true;
                }
                if (line.length() == 0 || contains) continue;
                if (line.startsWith(oldPack.getName())) {
                    if (lines.size() > 0) {
                        sections.add(this.createChangeLogEntry(lines));
                        lines.clear();
                    }
                    lines.add(line);
                    continue;
                }
                lines.add(line);
            }
            if (lines.size() > 0) {
                sections.add(this.createChangeLogEntry(lines));
            }
            return sections;
        }

        private JComponent createChangeLogEntry(ArrayList<String> lines) {
            DetailViewFormBuilder dfb = new DetailViewFormBuilder(new FormLayout("left:p"));
            String firstLine = lines.get(0);
            lines.remove(0);
            for (String line : lines) {
                dfb.append(new JLabel(line));
            }
            dfb.getPanel().setName(firstLine);
            return dfb.getPanel();
        }

        @Override
        public void init(Node[] selection, TopComponent tc) {
            Node[] arr$ = selection;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Node node;
                this.node2 = node = arr$[i$];
                this.p = (Package)node.getLookup().lookup(Package.class);
                this.pkgmgr = ((PackageManagementNode)node.getParentNode().getParentNode()).getPackageManagerDelegation();
            }
        }
    }
}

