/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console.nodes.pkgmgr;

import com.levigo.util.swing.IconManager;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;
import org.openthinclient.console.Messages;
import org.openthinclient.console.Refreshable;
import org.openthinclient.console.nodes.pkgmgr.AlreadyDeletedPackagesNode;
import org.openthinclient.console.nodes.pkgmgr.AvailablePackagesNode;
import org.openthinclient.console.nodes.pkgmgr.DebianFilePackagesNode;
import org.openthinclient.console.nodes.pkgmgr.InstalledPackagesNode;
import org.openthinclient.console.nodes.pkgmgr.PackageListNode;
import org.openthinclient.console.nodes.pkgmgr.PackageManagementNode;
import org.openthinclient.console.nodes.pkgmgr.PackageManagerJobQueue;
import org.openthinclient.console.nodes.pkgmgr.UpdatablePackagesNode;
import org.openthinclient.pkgmgr.PackageManagerException;

public class RefreshPackageManagerValuesAction
extends NodeAction {
    private static final long serialVersionUID = 3089422954495094295L;
    private Node[] nodes;

    public RefreshPackageManagerValuesAction() {
        this.setIcon(IconManager.getInstance(((Object)((Object)this)).getClass(), (String)"icons").getIcon("Refresh"));
    }

    protected void performAction(Node[] activatedNodes) {
        Node node = null;
        for (Node tmp : activatedNodes) {
            if (!(tmp instanceof PackageManagementNode) && !(tmp instanceof PackageListNode)) continue;
            node = tmp;
            break;
        }
        PackageManagerJobQueue.Job job = new PackageManagerJobQueue.Job(node){

            void doJob() {
            }

            Object doPMJob() throws PackageManagerException {
                int what;
                if (this.node instanceof PackageManagementNode) {
                    what = 0;
                } else if (this.node instanceof InstalledPackagesNode) {
                    what = 1;
                } else if (this.node instanceof AvailablePackagesNode) {
                    what = 2;
                } else if (this.node instanceof UpdatablePackagesNode) {
                    what = 3;
                } else if (this.node instanceof AlreadyDeletedPackagesNode) {
                    what = 4;
                } else if (this.node instanceof DebianFilePackagesNode) {
                    what = 5;
                } else {
                    throw new PackageManagerException("bad error requested!");
                }
                this.pkgmgr.refresh(what);
                return null;
            }
        };
        PackageManagerJobQueue.getInstance().addPackageManagerJob(job);
        for (Node tmpnode : activatedNodes) {
            if (!(tmpnode instanceof Refreshable)) continue;
            ((Refreshable)tmpnode).refresh();
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        this.nodes = activatedNodes;
        for (Node node : activatedNodes) {
            if (!(node instanceof PackageManagementNode) && !(node instanceof PackageListNode)) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        for (Node node : this.nodes) {
            if (!(node instanceof PackageManagementNode) && !(node instanceof PackageListNode)) continue;
            return Messages.getString("RefreshAction.name");
        }
        return "";
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    protected boolean asynchronous() {
        return true;
    }
}

