/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console.nodes.views;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.levigo.util.swing.IconManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.geom.AffineTransform;
import java.util.LinkedList;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import org.openide.nodes.Node;
import org.openide.windows.TopComponent;
import org.openthinclient.common.model.AssociatedObjectsProvider;
import org.openthinclient.common.model.Client;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.common.model.Group;
import org.openthinclient.common.model.Profile;
import org.openthinclient.common.model.Realm;
import org.openthinclient.common.model.UnrecognizedClient;
import org.openthinclient.common.model.User;
import org.openthinclient.console.AbstractDetailView;
import org.openthinclient.console.DetailViewProvider;
import org.openthinclient.console.Messages;
import org.openthinclient.console.nodes.DirObjectNode;
import org.openthinclient.console.nodes.RealmNode;
import org.openthinclient.console.nodes.views.ClientView;
import org.openthinclient.console.nodes.views.IncomingAssociationsView;
import org.openthinclient.console.nodes.views.OutgoingAssociationsView;
import org.openthinclient.console.nodes.views.ProfileView;
import org.openthinclient.console.nodes.views.UnrecognizedClientView;
import org.openthinclient.console.nodes.views.UserView;
import org.openthinclient.console.ui.CollapsibleTitlePanel;
import org.openthinclient.console.util.DetailViewFormBuilder;

public class DirObjectDetailView
extends AbstractDetailView {
    private DirectoryObject dirObject;
    private Realm realm;

    public JComponent getHeaderComponent() {
        DetailViewFormBuilder dfb = new DetailViewFormBuilder(new FormLayout("p, 10dlu, r:p, 3dlu, f:p:g"), Messages.getBundle());
        dfb.setLeadingColumnOffset(2);
        dfb.setColumn(3);
        String simpleClassName = this.dirObject.getClass().getSimpleName();
        Font f = UIManager.getFont("TitledBorder.font");
        f = f.deriveFont(1, AffineTransform.getScaleInstance(1.5, 1.5));
        JLabel typeLabel = new JLabel(Messages.getString("types.singular." + simpleClassName) + ":");
        typeLabel.setForeground(new Color(10, 10, 150));
        typeLabel.setFont(f);
        JLabel nameLabel = new JLabel();
        if (simpleClassName.equals("Realm")) {
            String dn = this.realm.getConnectionDescriptor().getBaseDN();
            dn = dn.replace("\\,", "#%COMMA%#");
            String[] s = dn.split(",");
            String nameRealm = "";
            if (s.length > 0) {
                nameRealm = s[0].replace("ou=", "").trim();
                nameRealm = nameRealm.replace("#%COMMA%#", "\\,").trim();
            }
            nameLabel = new JLabel(nameRealm);
        } else {
            nameLabel = new JLabel(this.dirObject.getName() != null ? this.dirObject.getName() : "");
        }
        nameLabel.setForeground(new Color(50, 50, 200));
        nameLabel.setFont(f);
        JLabel descField = new JLabel(this.dirObject.getDescription() != null ? this.dirObject.getDescription() : "");
        dfb.append((Component)typeLabel, (Component)nameLabel);
        dfb.append((Component)descField, 3);
        dfb.add(new JLabel(IconManager.getInstance(DetailViewProvider.class, (String)"icons").getIcon("tree." + this.dirObject.getClass().getSimpleName())), new CellConstraints(1, 1, 1, dfb.getRowCount(), CellConstraints.CENTER, CellConstraints.TOP));
        return dfb.getPanel();
    }

    public JComponent getMainComponent() {
        LinkedList<Object> sections = new LinkedList<Object>();
        if (this.dirObject instanceof User) {
            sections.add(new UserView((User)this.dirObject));
        }
        if (this.dirObject instanceof Client) {
            sections.add(new ClientView((Client)this.dirObject));
        }
        if (this.dirObject instanceof UnrecognizedClient) {
            sections.add(new UnrecognizedClientView((UnrecognizedClient)this.dirObject));
        }
        if (this.dirObject instanceof Profile) {
            sections.add((Object)new ProfileView((Profile)this.dirObject, this.realm));
        }
        if (this.dirObject instanceof Group) {
            sections.add((Object)new IncomingAssociationsView((Group<DirectoryObject>)((Group)this.dirObject)));
        }
        if (this.dirObject instanceof Realm) {
            IncomingAssociationsView view = new IncomingAssociationsView((Group<DirectoryObject>)((Realm)this.dirObject).getAdministrators());
            view.setName(Messages.getString("DirObjectDetailView.administrators"));
            sections.add((Object)view);
        }
        if (this.dirObject instanceof AssociatedObjectsProvider) {
            sections.add((Object)new OutgoingAssociationsView((AssociatedObjectsProvider)this.dirObject));
        }
        DetailViewFormBuilder dfb = new DetailViewFormBuilder(new FormLayout("f:p:g"));
        for (JComponent jComponent : sections) {
            dfb.append(new CollapsibleTitlePanel(jComponent.getName(), jComponent, true));
        }
        JScrollPane scrollPane = new JScrollPane(dfb.getPanel());
        scrollPane.getVerticalScrollBar().setUnitIncrement(20);
        scrollPane.setPreferredSize(scrollPane.getMinimumSize());
        scrollPane.setBorder(null);
        return scrollPane;
    }

    public void init(Node[] selection, TopComponent tc) {
        this.realm = null;
        this.dirObject = null;
        for (Node node : selection) {
            if (node instanceof DirObjectNode) {
                this.realm = (Realm)node.getLookup().lookup(Realm.class);
                this.dirObject = (DirectoryObject)node.getLookup().lookup(DirectoryObject.class);
                continue;
            }
            if (!(node instanceof RealmNode)) continue;
            this.realm = (Realm)node.getLookup().lookup(Realm.class);
            this.dirObject = this.realm;
            this.realm.ensureInitialized();
        }
        if (null == this.dirObject) {
            throw new IllegalStateException("Could not lookup a DirectoryObject instance");
        }
        if (null == this.realm) {
            throw new IllegalStateException("Could not lookup a Realm instance");
        }
    }

    public String getTitle() {
        return null;
    }
}

