/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console.nodes.views;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.ldap.LdapContext;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.openide.nodes.Node;
import org.openide.windows.TopComponent;
import org.openthinclient.console.AbstractDetailView;
import org.openthinclient.console.Messages;
import org.openthinclient.console.nodes.DirectoryEntryNode;
import org.openthinclient.console.nodes.DirectoryNode;
import org.openthinclient.console.util.DetailViewFormBuilder;
import org.openthinclient.ldap.LDAPConnectionDescriptor;

public class DirectoryEntryDetailView
extends AbstractDetailView {
    private String dn;
    private String rdn;
    private LDAPConnectionDescriptor connectionDescriptor;
    private Image icon;
    private String displayName;

    public JComponent getHeaderComponent() {
        DetailViewFormBuilder dfb = new DetailViewFormBuilder(new FormLayout("p, 10dlu, p, 0dlu, f:p:g"), Messages.getBundle());
        dfb.setLeadingColumnOffset(2);
        dfb.setColumn(3);
        Font f = UIManager.getFont("TitledBorder.font");
        f = f.deriveFont(1, AffineTransform.getScaleInstance(1.5, 1.5));
        JLabel nameLabel = new JLabel(this.displayName);
        nameLabel.setForeground(UIManager.getColor("textHighlight"));
        nameLabel.setFont(f);
        JLabel nameField = new JLabel(this.dn.substring(this.rdn.length()));
        nameField.setForeground(UIManager.getColor("textHighlight").brighter());
        nameField.setFont(f);
        JLabel descField = new JLabel(this.connectionDescriptor.getLDAPUrl());
        dfb.append((Component)nameLabel, (Component)nameField);
        dfb.append((Component)descField, 3);
        dfb.add(new JLabel(new ImageIcon(this.icon)), new CellConstraints(1, 1, 1, dfb.getRowCount(), CellConstraints.CENTER, CellConstraints.TOP));
        return dfb.getPanel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JComponent getMainComponent() {
        JScrollPane jScrollPane;
        LdapContext ctx = this.connectionDescriptor.createDirectoryFacade().createDirContext();
        try {
            JXTable table = new JXTable((TableModel)new AttributesTableModel(ctx.getAttributes(this.dn)));
            table.setShowGrid(true);
            JScrollPane mainComponent = new JScrollPane((Component)table);
            mainComponent.setBackground(UIManager.getColor("TextField.background"));
            mainComponent.setBorder(BorderFactory.createEmptyBorder());
            jScrollPane = mainComponent;
        }
        catch (Throwable throwable) {
            try {
                ctx.close();
                throw throwable;
            }
            catch (NamingException e) {
                return new JLabel(e.toString());
            }
        }
        ctx.close();
        return jScrollPane;
    }

    public void init(Node[] selection, TopComponent tc) {
        for (Node node : selection) {
            if (node instanceof DirectoryEntryNode) {
                DirectoryEntryNode den = (DirectoryEntryNode)node;
                this.dn = den.getDn();
                this.rdn = den.getRdn();
                this.connectionDescriptor = den.getConnectionDescriptor();
                this.icon = den.getIcon(0);
                this.displayName = den.getDisplayName();
                continue;
            }
            if (!(node instanceof DirectoryNode)) continue;
            DirectoryNode dirn = (DirectoryNode)node;
            this.dn = "";
            this.rdn = "";
            this.connectionDescriptor = dirn.getConnectionDescriptor();
            this.icon = dirn.getIcon(0);
            this.displayName = dirn.getDisplayName();
        }
    }

    public String getTitle() {
        return null;
    }

    private static class AttributesTableModel
    extends AbstractTableModel {
        private final List<Row> rows = new ArrayList<Row>();

        public AttributesTableModel(Attributes attributes) throws NamingException {
            ArrayList<String> ids = new ArrayList<String>();
            NamingEnumeration<String> i = attributes.getIDs();
            while (i.hasMore()) {
                ids.add(i.next());
            }
            Collections.sort(ids);
            for (String id : ids) {
                Attribute a = attributes.get(id);
                if (a.size() == 0) {
                    this.rows.add(new Row(a, null, true));
                    continue;
                }
                for (int j = 0; j < a.size(); ++j) {
                    this.rows.add(new Row(a, a.get(j), j == 0));
                }
            }
        }

        public int getRowCount() {
            return this.rows.size();
        }

        public int getColumnCount() {
            return 2;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            Row r = this.rows.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return r.isFirst ? r.a.getID() : "";
                }
            }
            return r.val != null ? r.val : "";
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return Messages.getString("DirectoryEntryDetailView.name");
                }
            }
            return Messages.getString("DirectoryEntryDetailView.value");
        }

        private class Row {
            public final Attribute a;
            public final Object val;
            public final boolean isFirst;

            Row(Attribute a, Object val, boolean isFirst) {
                this.a = a;
                this.val = val;
                this.isFirst = isFirst;
            }
        }
    }
}

