/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console.nodes.views;

import com.jgoodies.binding.PresentationModel;
import com.jgoodies.binding.adapter.BasicComponentFactory;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.validation.ValidationResult;
import com.jgoodies.validation.Validator;
import com.jgoodies.validation.util.PropertyValidationSupport;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import org.openthinclient.common.model.Realm;
import org.openthinclient.common.model.User;
import org.openthinclient.console.Messages;
import org.openthinclient.console.util.DetailViewFormBuilder;

public class RealmEditor
extends JPanel {
    public RealmEditor(final Realm realm) {
        PresentationModel roPrincipalModel = new PresentationModel((ValueModel)new ValueHolder((Object)realm.getReadOnlyPrincipal(), true));
        DetailViewFormBuilder dfb = new DetailViewFormBuilder(new FormLayout("r:p, 3dlu, f:p:g"), Messages.getBundle(), this);
        dfb.getPanel().setName(Messages.getString("Settings_title"));
        dfb.appendI15d("User.changePassword", BasicComponentFactory.createPasswordField((ValueModel)roPrincipalModel.getModel("newPassword"), (boolean)false));
        dfb.nextLine();
        dfb.appendI15d("User.verifyPassword", BasicComponentFactory.createPasswordField((ValueModel)roPrincipalModel.getModel("verifyPassword"), (boolean)false));
        dfb.nextLine();
        realm.getReadOnlyPrincipal().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                realm.fakePropertyChange();
            }
        });
        this.putClientProperty("validator", new UserValidator(roPrincipalModel, realm.getReadOnlyPrincipal()));
    }

    private static class UserValidator
    implements Validator {
        private final User user;
        private final PresentationModel model;

        UserValidator(PresentationModel model, User user) {
            this.model = model;
            this.user = user;
        }

        public ValidationResult validate() {
            this.model.triggerCommit();
            PropertyValidationSupport support = new PropertyValidationSupport((Object)this.user, "User");
            if (null != this.user.getNewPassword() && !this.user.getNewPassword().equals(this.user.getVerifyPassword())) {
                support.addError("password", Messages.getString("UserEditor.validation.password.mismatch"));
            } else if (null != this.user.getNewPassword() && this.user.getNewPassword().length() > 0) {
                support.addWarning("password", Messages.getString("RealmEditor.validation.changePWNotice"));
            }
            return support.getResult();
        }
    }
}

