/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console.ui;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.ButtonStackBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.FormLayout;
import com.levigo.util.swing.table.JTableFormatter;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.SortOrder;
import org.openide.ErrorManager;
import org.openide.util.Utilities;
import org.openthinclient.common.directory.LDAPDirectory;
import org.openthinclient.common.model.AssociatedObjectsProvider;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.common.model.Group;
import org.openthinclient.common.model.Realm;
import org.openthinclient.common.model.User;
import org.openthinclient.common.model.UserGroup;
import org.openthinclient.console.Messages;
import org.openthinclient.console.ui.DirObjectsTableModel;
import org.openthinclient.console.util.ExcludeFilterTableModel;
import org.openthinclient.ldap.DirectoryException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssociationEditor
extends JPanel {
    private final Set<? extends DirectoryObject> members;
    private final Realm realm;
    private final Class memberClass;
    private final DirectoryObject dirObject;
    private final int type;
    public static final int TYPE_MEMBERS = 1;
    public static final int TYPE_ASSOC_OBJECTS = 2;
    private JXTable availableObjectsTable;
    private DirObjectsTableModel membersTableModel;
    private ExcludeFilterTableModel availableObjectsTableModel;

    public AssociationEditor(Set<? extends DirectoryObject> members, Realm realm, Class memberClass, DirectoryObject dirObject, int type) {
        this.members = members;
        this.realm = realm;
        this.memberClass = memberClass;
        this.dirObject = dirObject;
        this.type = type;
        this.setName(this.getTitle());
        this.init();
    }

    protected JDialog getAddDialog() {
        final JDialog f = new JDialog((Dialog)SwingUtilities.getRoot(this), Messages.getString("AssociationEditor.choice"), true);
        DefaultFormBuilder dfb = new DefaultFormBuilder(new FormLayout("f:p:g"));
        dfb.setDefaultDialogBorder();
        dfb.appendTitle(Messages.getString("AssociationEditor.select"));
        dfb.nextLine();
        dfb.appendRelatedComponentsGapRow();
        dfb.nextLine();
        dfb.appendRow("f:max(100dlu;min):g");
        dfb.append((Component)new JScrollPane((Component)this.getAvailableObjectsTable()));
        dfb.nextLine();
        ButtonBarBuilder bbb = new ButtonBarBuilder();
        JButton ok = new JButton(new AddObjectsAction(this.getAvailableObjectsTable(), this.membersTableModel, f));
        bbb.addGridded((JComponent)ok);
        bbb.addRelatedGap();
        AbstractAction cancelAction = new AbstractAction(Messages.getString("AssociationEditor.cancel")){

            public void actionPerformed(ActionEvent e) {
                f.setVisible(false);
            }
        };
        bbb.addGridded((JComponent)new JButton(cancelAction));
        dfb.appendUnrelatedComponentsGapRow();
        dfb.nextLine();
        dfb.append((Component)bbb.getPanel());
        dfb.nextLine();
        f.setContentPane(dfb.getPanel());
        f.getRootPane().setDefaultButton(ok);
        f.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke("ESCAPE"), "ESCAPE");
        f.getRootPane().getActionMap().put("ESCAPE", cancelAction);
        f.pack();
        return f;
    }

    private void init() {
        this.setLayout((LayoutManager)new FormLayout("f:p:g, 5dlu, p", "f:p:g"));
        this.setBorder(Borders.DIALOG_BORDER);
        JXTable memberTable = this.createMemberTable();
        this.add((Component)new JScrollPane((Component)memberTable), "1,1");
        if (this.canModify(this.memberClass)) {
            this.add((Component)this.initButtonPanel(memberTable), "3,1");
        }
    }

    private JXTable createMemberTable() {
        this.membersTableModel = new DirObjectsTableModel(this.members);
        JXTable memberTable = new JXTable((TableModel)this.membersTableModel);
        memberTable.setSortable(true);
        memberTable.setSortOrder(0, SortOrder.ASCENDING);
        memberTable.setPreferredScrollableViewportSize(new Dimension(300, 300));
        JTableFormatter.initColumnSizes((JTable)memberTable);
        return memberTable;
    }

    private JXTable getAvailableObjectsTable() {
        if (null == this.availableObjectsTable) {
            HashSet other = new HashSet();
            HashSet<DirectoryObject> obj = new HashSet<DirectoryObject>();
            try {
                LDAPDirectory directory = this.realm.getDirectory();
                if (directory != null) {
                    other.addAll(directory.list(this.memberClass));
                }
                for (DirectoryObject o : other) {
                    if (o.equals((Object)this.dirObject)) continue;
                    obj.add(o);
                }
            }
            catch (DirectoryException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
            this.availableObjectsTableModel = new ExcludeFilterTableModel(new DirObjectsTableModel(obj), this.membersTableModel);
            this.availableObjectsTable = new JXTable((TableModel)this.availableObjectsTableModel);
            this.availableObjectsTable.setSortable(true);
            this.availableObjectsTable.setSortOrder(0, SortOrder.ASCENDING);
            JTableFormatter.initColumnSizes((JTable)this.availableObjectsTable);
        }
        return this.availableObjectsTable;
    }

    protected JPanel initButtonPanel(JXTable memberTable) {
        ButtonStackBuilder bsb = new ButtonStackBuilder();
        bsb.addGridded((JComponent)new JButton(new OpenAddFrameAction((JTable)memberTable)));
        bsb.addRelatedGap();
        bsb.addGridded((JComponent)new JButton(new RemoveAction(memberTable)));
        bsb.addRelatedGap();
        return bsb.getPanel();
    }

    private void commit() {
        if (this.type == 2) {
            ((AssociatedObjectsProvider)this.dirObject).setAssociatedObjects(this.memberClass, new HashSet<DirectoryObject>(this.membersTableModel.getDirectoryObjects()));
        } else if (this.type == 1) {
            HashSet<? extends DirectoryObject> newMembers = new HashSet<DirectoryObject>(((Group)this.dirObject).getMembers());
            Iterator i = newMembers.iterator();
            while (i.hasNext()) {
                Object member = i.next();
                if (!member.getClass().equals(this.memberClass)) continue;
                i.remove();
            }
            newMembers.addAll(this.membersTableModel.getDirectoryObjects());
            ((Group)this.dirObject).setMembers(newMembers);
        }
    }

    public String getTitle() {
        String prefix = "";
        String postfix = "";
        return "" + Messages.getString(this.memberClass.getSimpleName() + "s_title") + "";
    }

    private boolean canModify(Class object) {
        boolean isUser = this.dirObject.getClass() == User.class;
        boolean isGroup = this.dirObject.getClass() == UserGroup.class;
        boolean isMutable = LDAPDirectory.isMutable(UserGroup.class);
        if (this.realm.getAdministrators() == this.dirObject) {
            return true;
        }
        if (isUser && object == UserGroup.class && !isMutable) {
            return false;
        }
        return !isGroup || object != UserGroup.class && object != User.class || false != isMutable;
    }

    private final class RemoveAction
    extends AbstractAction
    implements ListSelectionListener {
        private final JXTable table;

        private RemoveAction(JXTable table) {
            super(Messages.getString("AssociationEditor.deleteButton"));
            this.table = table;
            this.setEnabled(table.getSelectedRowCount() > 0);
            table.getSelectionModel().addListSelectionListener(this);
        }

        public void actionPerformed(ActionEvent e) {
            int i;
            int[] selectedRows = this.table.getSelectedRows();
            DirObjectsTableModel memberTableModel = (DirObjectsTableModel)this.table.getModel();
            for (i = 0; i < selectedRows.length; ++i) {
                selectedRows[i] = this.table.convertRowIndexToModel(selectedRows[i]);
            }
            Arrays.sort(selectedRows);
            for (i = selectedRows.length - 1; i >= 0; --i) {
                memberTableModel.removeDirectoryObjectAt(selectedRows[i]);
            }
            AssociationEditor.this.commit();
        }

        public void valueChanged(ListSelectionEvent e) {
            this.setEnabled(this.table.getSelectedRowCount() > 0);
        }
    }

    private final class AddObjectsAction
    extends AbstractAction
    implements ListSelectionListener {
        private final JXTable availableTable;
        private final DirObjectsTableModel membersTableModel;
        private final JDialog dialog;

        private AddObjectsAction(JXTable availableTable, DirObjectsTableModel membersTableModel, JDialog dialog) {
            super(Messages.getString("AssociationEditor.ok"));
            this.availableTable = availableTable;
            this.membersTableModel = membersTableModel;
            this.dialog = dialog;
            this.setEnabled(availableTable.getSelectedRowCount() > 0);
            availableTable.getSelectionModel().addListSelectionListener(this);
        }

        public void actionPerformed(ActionEvent e) {
            int[] selectedRows = this.availableTable.getSelectedRows();
            DirObjectsTableModel availableTableModel = (DirObjectsTableModel)AssociationEditor.this.availableObjectsTableModel.getTableModel();
            for (int i = 0; i < selectedRows.length; ++i) {
                selectedRows[i] = this.availableTable.convertRowIndexToModel(selectedRows[i]);
            }
            for (int i : selectedRows) {
                this.membersTableModel.addDirectoryObject(availableTableModel.getDirectoryObjectAt(AssociationEditor.this.availableObjectsTableModel.getUnfilteredRowIndex(i)));
            }
            AssociationEditor.this.commit();
            this.dialog.setVisible(false);
        }

        public void valueChanged(ListSelectionEvent e) {
            this.setEnabled(this.availableTable.getSelectedRowCount() > 0);
        }
    }

    private final class OpenAddFrameAction
    extends AbstractAction {
        private OpenAddFrameAction(JTable table) {
            super(Messages.getString("AssociationEditor.addButton"));
        }

        public void actionPerformed(ActionEvent e) {
            JDialog d = AssociationEditor.this.getAddDialog();
            d.setIconImage(Utilities.loadImage((String)"org/openthinclient/console/icon.png", (boolean)true));
            AssociationEditor.this.availableObjectsTableModel.updateFilteredRows();
            d.setSize(830, 600);
            this.locateDialog(d);
            d.setVisible(true);
        }

        private void locateDialog(JDialog d) {
            Container parent = d.getParent();
            int x = parent.getWidth() >= d.getWidth() ? parent.getX() + (parent.getWidth() - d.getWidth()) / 2 : parent.getX() + 20;
            int y = parent.getHeight() >= AssociationEditor.this.getHeight() ? parent.getY() + (parent.getHeight() - d.getHeight()) / 2 : parent.getY() + 20;
            d.setLocation(x, y);
        }
    }
}

