/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console.ui;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.log4j.Logger;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.console.Messages;
import org.openthinclient.console.ui.DirObjectsTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedDirObjectsTableModel
extends DirObjectsTableModel {
    private ArrayList<JTree> paths = new ArrayList();

    public ExtendedDirObjectsTableModel(Set<? extends DirectoryObject> other) {
        super(other);
    }

    public ExtendedDirObjectsTableModel(Map<String, Set<? extends DirectoryObject>> dirObjects) {
        Set<String> keys = dirObjects.keySet();
        for (String key : keys) {
            Set<? extends DirectoryObject> currDirObjects = dirObjects.get(key);
            for (DirectoryObject directoryObject : currDirObjects) {
                this.addDirectoryObject(directoryObject);
                int index = this.dirObjects.indexOf(directoryObject);
                String[] nodes = key.split(";");
                JTree tree = null;
                DefaultMutableTreeNode parent = null;
                for (int i = 0; i < nodes.length; ++i) {
                    if (nodes[i].length() > 0) {
                        DefaultMutableTreeNode node = new DefaultMutableTreeNode(nodes[i], true);
                        if (i == 0) {
                            tree = new JTree(node);
                            tree.setShowsRootHandles(true);
                            tree.setRootVisible(true);
                            tree.setVisible(true);
                            tree.addTreeSelectionListener(new TreeSelectionListener(){

                                public void valueChanged(TreeSelectionEvent e) {
                                    Logger.getLogger(this.getClass()).debug((Object)"tree selection changed");
                                    ((JTree)e.getSource()).repaint();
                                }
                            });
                            tree.addTreeExpansionListener(new TreeExpansionListener(){

                                public void treeExpanded(TreeExpansionEvent event) {
                                    Logger.getLogger(this.getClass()).debug((Object)"tree expanded");
                                    ExtendedDirObjectsTableModel.this.fireTableDataChanged();
                                    ExtendedDirObjectsTableModel.this.fireTableCellUpdated(ExtendedDirObjectsTableModel.this.paths.indexOf(event.getSource()), 2);
                                }

                                public void treeCollapsed(TreeExpansionEvent event) {
                                    ExtendedDirObjectsTableModel.this.fireTableDataChanged();
                                }
                            });
                        } else {
                            parent.add(node);
                        }
                        parent = node;
                    }
                    this.paths.add(index, tree);
                }
            }
        }
        String columns = Messages.getString("table.ExtendedDirObjects");
        if (columns != null) {
            this.columnNames = columns.split(",");
        }
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        DirectoryObject object = (DirectoryObject)this.dirObjects.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return object.getName();
            }
            case 1: {
                return object.getDescription();
            }
            case 2: {
                return this.paths.get(rowIndex);
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex == 2) {
            return true;
        }
        return super.isCellEditable(rowIndex, columnIndex);
    }

    @Override
    public void fireTableDataChanged() {
        super.fireTableDataChanged();
    }
}

