/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.openthinclient.console.util.SelectableSectionTitleBar;

public class TitledTreePanel
extends JPanel {
    private boolean contentVisible = false;
    private SelectableSectionTitleBar titleBar;
    private JComponent contentPanel;

    public TitledTreePanel(JComponent contentPanel) {
        this(contentPanel, "");
    }

    public TitledTreePanel(String title) {
        this(null, title);
    }

    public TitledTreePanel(JComponent contentPanel, String title) {
        this.setBackground(Color.WHITE);
        this.contentPanel = contentPanel;
        this.titleBar = new SelectableSectionTitleBar(title);
        this.init();
    }

    private void init() {
        this.titleBar.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName() == "contentVisibility") {
                    TitledTreePanel.this.update();
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.contentPanel.setBackground(UIManager.getColor("TextField.background"));
        this.add((Component)this.titleBar, "North");
        this.updateUI();
    }

    private void update() {
        if (this.contentVisible) {
            this.contentVisible = false;
            this.remove(this.contentPanel);
        } else {
            this.contentVisible = true;
            this.add(this.contentPanel);
        }
        this.revalidate();
        this.repaint();
    }

    public void setContentVisible(boolean visible) {
        this.update();
        this.titleBar.setContentVisible(visible);
    }
}

