/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console.ui.fields;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import org.openthinclient.common.model.Profile;
import org.openthinclient.common.model.schema.ChoiceNode;
import org.openthinclient.common.model.schema.Node;
import org.openthinclient.console.Messages;
import org.openthinclient.console.ui.fields.ConfigField;

public class ChoiceField
extends ConfigField {
    private JComboBox comboBox = new JComboBox();

    public ChoiceField(Profile profile, ChoiceNode n) {
        super(profile, (Node)n);
        this.comboBox.setModel(new ChoiceNodeModel((ChoiceNode)this.node));
        this.updateRepresentation();
        this.comboBox.setRenderer(new MyListCellRenderer());
        this.comboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ChoiceField.this.comboBox.getSelectedIndex() == 0) {
                    ChoiceField.this.resetValueToDefault();
                    ChoiceField.this.updateRepresentation();
                } else {
                    ChoiceField.this.setValue(((ChoiceNode.Option)ChoiceField.this.comboBox.getModel().getSelectedItem()).getValue());
                }
            }
        });
    }

    protected void updateRepresentation() {
        this.getMainComponent();
        if (this.isValueOverridden()) {
            String currentValue = this.profile.getValue(this.node.getKey());
            for (int i = 1; i < this.comboBox.getModel().getSize(); ++i) {
                ChoiceNode.Option option = (ChoiceNode.Option)this.comboBox.getModel().getElementAt(i);
                if (!option.getValue().equals(currentValue)) continue;
                this.comboBox.setSelectedIndex(i);
            }
            this.comboBox.setForeground(UIManager.getColor("ComboBox.foreground"));
        } else {
            this.comboBox.setSelectedIndex(0);
            this.comboBox.setForeground(UIManager.getColor("ComboBox.disabledForeground"));
        }
        super.updateRepresentation();
    }

    protected void setValue(String value) {
        this.profile.setValue(this.node.getKey(), value);
        this.updateRepresentation();
    }

    protected JComponent getMainComponent() {
        return this.comboBox;
    }

    protected String valueToDisplayedValue(String value) {
        for (int i = 0; i < this.comboBox.getModel().getSize(); ++i) {
            Object listElement = this.comboBox.getModel().getElementAt(i);
            if (!(listElement instanceof ChoiceNode.Option)) {
                return listElement.toString();
            }
            ChoiceNode.Option option = (ChoiceNode.Option)listElement;
            if (!option.getValue().equals(value)) continue;
            return option.getLabel();
        }
        return value + "(?)";
    }

    private static class ChoiceNodeModel
    extends DefaultComboBoxModel {
        private ChoiceNode node;

        public ChoiceNodeModel(ChoiceNode n) {
            this.node = n;
        }

        public Object getElementAt(int index) {
            if (index == 0) {
                ChoiceNode.Option selectedOption = this.node.getSelectedOption();
                if (null != selectedOption) {
                    return selectedOption.getLabel() + Messages.getString("ChoiceField.default");
                }
                return "<?>";
            }
            return this.node.getOptions().get(index - 1);
        }

        public int getIndexOf(Object anObject) {
            return this.node.getOptions().indexOf(anObject) + 1;
        }

        public int getSize() {
            return this.node.getOptions().size() + 1;
        }
    }

    public class MyListCellRenderer
    extends BasicComboBoxRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setEnabled(index != 0);
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }
}

