/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console.util;

import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.apache.commons.collections.primitives.ArrayIntList;
import org.apache.commons.collections.primitives.IntList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FilterTableModel
extends AbstractTableModel
implements TableModelListener {
    protected TableModel tableModel;
    private IntList filteredRowIndices = new ArrayIntList();

    public FilterTableModel() {
    }

    public FilterTableModel(TableModel delegate) {
        this.setTableModel(delegate);
    }

    protected void updateFilteredRows() {
        this.filteredRowIndices.clear();
        int rowCount = this.tableModel.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            if (!this.filterRow(i)) continue;
            this.filteredRowIndices.add(i);
        }
        this.fireTableDataChanged();
    }

    protected abstract boolean filterRow(int var1);

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return null != this.tableModel ? this.tableModel.getColumnClass(columnIndex) : Object.class;
    }

    @Override
    public int getColumnCount() {
        return null != this.tableModel ? this.tableModel.getColumnCount() : 0;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return null != this.tableModel ? this.tableModel.getColumnName(columnIndex) : "";
    }

    @Override
    public int getRowCount() {
        return this.filteredRowIndices.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return null != this.tableModel ? this.tableModel.getValueAt(this.filteredRowIndices.get(rowIndex), columnIndex) : null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return null != this.tableModel ? this.tableModel.isCellEditable(this.filteredRowIndices.get(rowIndex), columnIndex) : false;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (null != this.tableModel) {
            this.tableModel.setValueAt(aValue, this.filteredRowIndices.get(rowIndex), columnIndex);
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.updateFilteredRows();
        if (e.getFirstRow() == -1) {
            this.fireTableStructureChanged();
        } else {
            this.fireTableDataChanged();
        }
    }

    public TableModel getTableModel() {
        return this.tableModel;
    }

    public void setTableModel(TableModel delegate) {
        if (null != delegate) {
            delegate.removeTableModelListener(this);
        }
        this.tableModel = delegate;
        if (null != delegate) {
            delegate.addTableModelListener(this);
            this.updateFilteredRows();
        } else {
            this.filteredRowIndices.clear();
        }
        this.fireTableStructureChanged();
    }

    public int getUnfilteredRowIndex(int i) {
        return this.filteredRowIndices.get(i);
    }
}

