/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console.wizards;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.callback.CallbackHandler;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openide.WizardDescriptor;
import org.openthinclient.common.directory.LDAPDirectory;
import org.openthinclient.common.model.Property;
import org.openthinclient.common.model.Realm;
import org.openthinclient.console.Messages;
import org.openthinclient.console.util.UsernamePasswordCallbackHandler;
import org.openthinclient.console.wizards.ConnectionSettingsWizardPanel;
import org.openthinclient.console.wizards.initrealm.NewRealmInitWizardIterator;
import org.openthinclient.ldap.DirectoryException;
import org.openthinclient.ldap.LDAPConnectionDescriptor;

public final class ConnectionSettingsVisualPanel
extends JPanel {
    private JTextField baseDNField;
    private JTextField hostField;
    private JTextField schemaProviderName;
    private JComboBox connectMethodField;
    private JComboBox authMethodField;
    private JPasswordField passwordField;
    private JLabel passwordLabel;
    private JTextField portField;
    private JTextField userDNField;
    private JLabel userLabel;
    private JLabel dnLabel;
    private JLabel schemaProviderLabel;
    private JLabel connectMethodLabel;
    private JLabel authMethodLable;
    private JCheckBox savePasswordCheckbox;
    private LDAPConnectionDescriptor lcd;
    private Set<Property> propertyList;
    private boolean checkEnableForward = true;
    private URL url;

    public ConnectionSettingsVisualPanel(final ConnectionSettingsWizardPanel panel) {
        this.initComponents();
        if (null == panel) {
            return;
        }
        DocumentListener dl = new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                ConnectionSettingsVisualPanel.this.fireChangeEvent(panel);
            }

            public void insertUpdate(DocumentEvent e) {
                ConnectionSettingsVisualPanel.this.fireChangeEvent(panel);
            }

            public void removeUpdate(DocumentEvent e) {
                ConnectionSettingsVisualPanel.this.fireChangeEvent(panel);
            }
        };
        this.hostField.getDocument().addDocumentListener(dl);
        this.baseDNField.getDocument().addDocumentListener(dl);
        this.schemaProviderName.getDocument().addDocumentListener(dl);
        this.userDNField.getDocument().addDocumentListener(dl);
        this.passwordField.getDocument().addDocumentListener(dl);
        this.portField.getDocument().addDocumentListener(dl);
        ActionListener myActionForwarder = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConnectionSettingsVisualPanel.this.methodFieldItemStateChanged();
                ConnectionSettingsVisualPanel.this.fireChangeEvent(panel);
            }
        };
        this.connectMethodField.addActionListener(myActionForwarder);
        this.authMethodField.addActionListener(myActionForwarder);
    }

    LDAPConnectionDescriptor createLDAPConnectionDescriptor() {
        if (null == this.lcd) {
            this.lcd = new LDAPConnectionDescriptor();
            this.lcd.setAuthenticationMethod((LDAPConnectionDescriptor.AuthenticationMethod)this.authMethodField.getSelectedItem());
            this.lcd.setConnectionMethod((LDAPConnectionDescriptor.ConnectionMethod)this.connectMethodField.getSelectedItem());
            this.lcd.setBaseDN(this.baseDNField.getText());
            this.lcd.setHostname(this.hostField.getText());
            this.lcd.setPortNumber(Short.parseShort(this.portField.getText()));
            this.lcd.setCallbackHandler((CallbackHandler)((Object)new UsernamePasswordCallbackHandler(this.lcd.getLDAPUrl(), this.userDNField.getText(), this.passwordField.getPassword(), this.savePasswordCheckbox.isSelected())));
        }
        return this.lcd;
    }

    public String getName() {
        return Messages.getString("ConnectionSettings.name");
    }

    private String getProperty(WizardDescriptor wd, String name, String defaultValue) {
        Object value = wd.getProperty(name);
        return value != null ? value.toString() : defaultValue;
    }

    private void initComponents() {
        DefaultFormBuilder dfb = new DefaultFormBuilder(new FormLayout("r:p,3dlu,f:p:g,3dlu,p,3dlu,p"), Messages.getBundle(), (JPanel)this);
        int DEFAULT_COLSPAN = 5;
        if (null != System.getProperty("ThinClientManager.server.Codebase")) {
            try {
                this.url = new URL(System.getProperty("ThinClientManager.server.Codebase"));
            }
            catch (MalformedURLException e1) {
                e1.printStackTrace();
            }
        }
        this.hostField = new JTextField();
        if (null != this.url) {
            this.hostField.setText(this.url.getHost());
        }
        dfb.appendI15d("ConnectionSettings.connection.host", (Component)this.hostField);
        this.portField = new JTextField();
        this.portField.setText("10389");
        this.portField.setColumns(5);
        dfb.appendI15d("ConnectionSettings.connection.port", (Component)this.portField);
        dfb.nextLine();
        this.connectMethodField = new JComboBox<LDAPConnectionDescriptor.ConnectionMethod>(new DefaultComboBoxModel<LDAPConnectionDescriptor.ConnectionMethod>(LDAPConnectionDescriptor.ConnectionMethod.values()));
        this.connectMethodField.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                return super.getListCellRendererComponent((JList<?>)list, Messages.getString("ConnectionSettings.connection.method." + ((LDAPConnectionDescriptor.ConnectionMethod)value).name()), index, isSelected, cellHasFocus);
            }
        });
        this.connectMethodField.setEnabled(false);
        this.connectMethodLabel = dfb.appendI15d("ConnectionSettings.connection.method", (Component)this.connectMethodField);
        this.connectMethodLabel.setEnabled(false);
        dfb.nextLine();
        dfb.appendUnrelatedComponentsGapRow();
        dfb.nextLine();
        dfb.appendI15dSeparator("ConnectionSettings.optional");
        dfb.nextLine();
        this.baseDNField = new JTextField();
        this.baseDNField.setText("ou=openthinclient,dc=openthinclient,dc=org");
        this.dnLabel = dfb.appendI15d("ConnectionSettings.baseDN", (Component)this.baseDNField, 5);
        dfb.nextLine();
        this.schemaProviderName = new JTextField();
        this.schemaProviderName.setEnabled(false);
        this.schemaProviderLabel = dfb.appendI15d("ConnectionSettings.schemaProviderName", (Component)this.schemaProviderName, 5);
        this.schemaProviderLabel.setEnabled(false);
        dfb.nextLine();
        dfb.appendUnrelatedComponentsGapRow();
        dfb.nextLine();
        dfb.appendI15dSeparator("ConnectionSettings.authentication");
        dfb.nextLine();
        this.authMethodField = new JComboBox<LDAPConnectionDescriptor.AuthenticationMethod>(new DefaultComboBoxModel<LDAPConnectionDescriptor.AuthenticationMethod>(LDAPConnectionDescriptor.AuthenticationMethod.values()));
        this.authMethodField.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                return super.getListCellRendererComponent((JList<?>)list, Messages.getString("ConnectionSettings.authentication.method." + ((LDAPConnectionDescriptor.AuthenticationMethod)value).name()), index, isSelected, cellHasFocus);
            }
        });
        this.authMethodField.setEnabled(false);
        this.authMethodLable = dfb.appendI15d("ConnectionSettings.authentication.method", (Component)this.authMethodField, 5);
        this.authMethodLable.setEnabled(false);
        dfb.nextLine();
        this.userDNField = new JTextField();
        this.userLabel = dfb.appendI15d("ConnectionSettings.user", (Component)this.userDNField, 5);
        this.userDNField.setText("cn=administrator,ou=users,ou=openthinclient,dc=openthinclient,dc=org");
        dfb.nextLine();
        this.passwordField = new JPasswordField();
        this.passwordLabel = dfb.appendI15d("ConnectionSettings.password", (Component)this.passwordField, 5);
        dfb.nextLine();
        this.savePasswordCheckbox = new JCheckBox(Messages.getString("ConnectionSettings.savePassword"));
        dfb.append((Component)this.savePasswordCheckbox, 5);
        dfb.nextLine();
    }

    boolean valid(WizardDescriptor wd) {
        try {
            Integer.parseInt(this.portField.getText());
        }
        catch (NumberFormatException e) {
            wd.putProperty("WizardPanel_errorMessage", (Object)Messages.getString("ConnectionSettings.validation.port"));
            return false;
        }
        if (this.baseDNField.getText().length() <= 0 || this.hostField.getText().length() <= 0) {
            wd.putProperty("WizardPanel_errorMessage", (Object)Messages.getString("ConnectionSettings.validation.baseDNOrHost"));
            return false;
        }
        if (this.userDNField.isEnabled() && this.userDNField.getText().length() == 0) {
            wd.putProperty("WizardPanel_errorMessage", (Object)Messages.getString("ConnectionSettings.validation.notAnonymus"));
            return false;
        }
        wd.putProperty("WizardPanel_errorMessage", null);
        return true;
    }

    private void methodFieldItemStateChanged() {
        this.authMethodField.setSelectedItem(LDAPConnectionDescriptor.AuthenticationMethod.SIMPLE);
        boolean enabled = this.authMethodField.getSelectedItem() != null && this.authMethodField.getSelectedItem() != LDAPConnectionDescriptor.AuthenticationMethod.NONE;
        this.passwordField.setEnabled(enabled);
        this.passwordLabel.setEnabled(enabled);
        this.savePasswordCheckbox.setEnabled(enabled);
        if (!enabled) {
            this.passwordField.setText("");
        }
    }

    void readSettings(WizardDescriptor wd) {
        String host = "";
        if (null != this.url) {
            host = this.url.getHost();
        }
        this.hostField.setText(this.getProperty(wd, "hostname", host));
        this.portField.setText(this.getProperty(wd, "port", "10389"));
        this.connectMethodField.setSelectedItem(wd.getProperty("connectMethod") != null ? wd.getProperty("connectMethod") : LDAPConnectionDescriptor.ConnectionMethod.PLAIN);
        this.authMethodField.setSelectedItem(wd.getProperty("authMethod") != null ? wd.getProperty("authMethod") : LDAPConnectionDescriptor.AuthenticationMethod.NONE);
        this.savePasswordCheckbox.setSelected(wd.getProperty("savePassword") != null && (Boolean)wd.getProperty("savePassword") != false);
        this.valid(wd);
    }

    private void enableForward(LDAPConnectionDescriptor lcd, WizardDescriptor wd) {
        int indexNextObj;
        String activePanel;
        Object efo = wd.getProperty("enableForward");
        if (efo != null) {
            this.checkEnableForward = (Boolean)efo;
        }
        if (this.checkEnableForward && (activePanel = NewRealmInitWizardIterator.current(indexNextObj = NewRealmInitWizardIterator.getIndex()).getClass().getSimpleName()).equals("SelectBasePanel")) {
            JLabel jlabel;
            Set realms = new HashSet();
            try {
                realms = LDAPDirectory.listRealms((LDAPConnectionDescriptor)lcd);
            }
            catch (DirectoryException e) {
                e.printStackTrace();
                jlabel = new JLabel();
                JOptionPane.showMessageDialog(jlabel, e.toString(), Messages.getString("NewRealmInitAction.error.name"), 0);
            }
            if (!realms.isEmpty()) {
                String realmURLs = "";
                for (Realm realm : realms) {
                    realmURLs = realmURLs + realm.getConnectionDescriptor().getLDAPUrl() + "\n";
                }
                jlabel = new JLabel();
                JOptionPane.showMessageDialog(jlabel, Messages.getString("NewRealmInitAction.error.text") + ": \n" + realmURLs, Messages.getString("NewRealmInitAction.error.name"), 0);
                NewRealmInitWizardIterator.setIndex(0);
            }
        }
    }

    void storeSettings(WizardDescriptor wd) {
        if (this.valid(wd)) {
            wd.putProperty("hostname", (Object)this.hostField.getText());
            wd.putProperty("port", (Object)this.portField.getText());
            wd.putProperty("baseDN", (Object)this.baseDNField.getText());
            wd.putProperty("connectMethod", this.connectMethodField.getSelectedItem());
            wd.putProperty("authMethod", this.authMethodField.getSelectedItem());
            wd.putProperty("userDN", (Object)this.userDNField.getText());
            wd.putProperty("schemaProviderName", (Object)this.schemaProviderName.getText());
            wd.putProperty("savePassword", (Object)this.savePasswordCheckbox.isSelected());
            wd.putProperty("connectionDescriptor", (Object)this.createLDAPConnectionDescriptor());
            this.enableForward(this.createLDAPConnectionDescriptor(), wd);
        }
    }

    private void fireChangeEvent(ConnectionSettingsWizardPanel panel) {
        panel.fireChangeEvent();
        this.lcd = null;
    }
}

