/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console.wizards.initrealm;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openthinclient.console.Messages;
import org.openthinclient.ldap.LDAPConnectionDescriptor;

public class InitDefaultObjectsPanel
implements WizardDescriptor.Panel {
    private final Set<ChangeListener> listeners = new HashSet<ChangeListener>(1);
    private JPanel component;
    private WizardDescriptor wizardDescriptor;
    private String baseDN;
    private JCheckBox ousCheckBox;
    private JCheckBox adminCheckBox;
    private JLabel adminDNLabel;
    private JCheckBox locationCheckBox;
    private JCheckBox hwtypeAndDevicesCheckBox;
    private JTextField adminNameField;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator<ChangeListener> it;
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            it = new HashSet<ChangeListener>(this.listeners).iterator();
        }
        ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
            it.next().stateChanged(ev);
        }
    }

    public JComponent getComponent() {
        if (null == this.component) {
            DefaultFormBuilder dfb = new DefaultFormBuilder(new FormLayout("15dlu, 15dlu, p:g, 3dlu, p:g"), Messages.getBundle());
            ActionListener changeForwarder = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    InitDefaultObjectsPanel.this.updateComponentStates();
                    InitDefaultObjectsPanel.this.fireChangeEvent();
                }
            };
            DocumentListener documentForwarder = new DocumentListener(){

                public void changedUpdate(DocumentEvent e) {
                    InitDefaultObjectsPanel.this.updateComponentStates();
                    InitDefaultObjectsPanel.this.fireChangeEvent();
                }

                public void insertUpdate(DocumentEvent e) {
                    InitDefaultObjectsPanel.this.updateComponentStates();
                    InitDefaultObjectsPanel.this.fireChangeEvent();
                }

                public void removeUpdate(DocumentEvent e) {
                    InitDefaultObjectsPanel.this.updateComponentStates();
                    InitDefaultObjectsPanel.this.fireChangeEvent();
                }
            };
            this.ousCheckBox = new JCheckBox(Messages.getString("InitDefaultObjectsPanel.ous"));
            this.ousCheckBox.setSelected(true);
            this.ousCheckBox.addActionListener(changeForwarder);
            dfb.append((Component)this.ousCheckBox, dfb.getColumnCount());
            dfb.nextLine();
            dfb.setLeadingColumnOffset(1);
            this.adminCheckBox = new JCheckBox(Messages.getString("InitDefaultObjectsPanel.admin"));
            this.ousCheckBox.addActionListener(changeForwarder);
            this.adminCheckBox.setSelected(true);
            dfb.append((Component)this.adminCheckBox, dfb.getColumnCount() - dfb.getColumn() - 2);
            this.adminNameField = new JTextField(Messages.getString("InitDefaultObjectsPanel.defaultAdminUserName"));
            this.adminNameField.getDocument().addDocumentListener(documentForwarder);
            dfb.append((Component)this.adminNameField);
            dfb.nextLine();
            dfb.setLeadingColumnOffset(2);
            this.adminDNLabel = new JLabel();
            dfb.append((Component)this.adminDNLabel, dfb.getColumnCount() - 2);
            dfb.nextLine();
            dfb.setLeadingColumnOffset(1);
            this.locationCheckBox = new JCheckBox(Messages.getString("InitDefaultObjectsPanel.location"));
            this.locationCheckBox.setSelected(true);
            dfb.append((Component)this.locationCheckBox, dfb.getColumnCount() - 1);
            dfb.nextLine();
            this.hwtypeAndDevicesCheckBox = new JCheckBox(Messages.getString("InitDefaultObjectsPanel.hwtypeAndDevices"));
            this.hwtypeAndDevicesCheckBox.setSelected(true);
            dfb.append((Component)this.hwtypeAndDevicesCheckBox, dfb.getColumnCount() - dfb.getColumn());
            dfb.nextLine();
            this.updateComponentStates();
            this.component = dfb.getPanel();
            this.component.setName(Messages.getString("InitDefaultObjectsPanel.name"));
        }
        return this.component;
    }

    protected void updateComponentStates() {
        boolean enabled = this.ousCheckBox.isSelected();
        this.adminCheckBox.setEnabled(enabled);
        this.adminDNLabel.setEnabled(enabled && this.adminCheckBox.isSelected());
        this.adminDNLabel.setText(Messages.getString("InitDefaultObjectsPanel.adminDN", this.adminNameField.getText(), this.baseDN));
        this.adminNameField.setEnabled(enabled && this.adminCheckBox.isSelected());
        this.locationCheckBox.setEnabled(enabled);
        this.hwtypeAndDevicesCheckBox.setEnabled(enabled);
    }

    public HelpCtx getHelp() {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean isValid() {
        if (this.adminNameField.isEnabled() && this.adminNameField.getText().length() == 0) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)Messages.getString("InitDefaultObjectsPanel.validation.error.adminNameMandatory"));
            return false;
        }
        this.wizardDescriptor.putProperty("WizardPanel_errorMessage", null);
        return true;
    }

    public void readSettings(Object settings) {
        this.wizardDescriptor = (WizardDescriptor)settings;
        LDAPConnectionDescriptor lcd = (LDAPConnectionDescriptor)this.wizardDescriptor.getProperty("connectionDescriptor");
        this.baseDN = (String)this.wizardDescriptor.getProperty("selectedBaseDN") != null ? "ou=users," + (String)this.wizardDescriptor.getProperty("selectedBaseDN") + "," + lcd.getBaseDN() : "ou=users," + (String)this.wizardDescriptor.getProperty("oldSelectedBaseDN") + "," + lcd.getBaseDN();
        this.updateComponentStates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    public void storeSettings(Object settings) {
        WizardDescriptor wd = (WizardDescriptor)settings;
        wd.putProperty("initOUs", (Object)this.ousCheckBox.isSelected());
        wd.putProperty("initAdmin", (Object)this.adminCheckBox.isSelected());
        wd.putProperty("initLocation", (Object)this.locationCheckBox.isSelected());
        wd.putProperty("initHwtypeAndDevices", (Object)this.hwtypeAndDevicesCheckBox.isSelected());
        wd.putProperty("adminName", (Object)this.adminNameField.getText());
        wd.putProperty("adminBaseDN", (Object)this.baseDN);
    }
}

