/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console.wizards.initrealm;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openide.WizardDescriptor;
import org.openide.explorer.ExplorerManager;
import org.openide.util.HelpCtx;
import org.openthinclient.console.Messages;
import org.openthinclient.console.wizards.initrealm.EnableableWizardPanel;
import org.openthinclient.ldap.LDAPConnectionDescriptor;

public class InitEnvironmentPanel
implements WizardDescriptor.Panel,
EnableableWizardPanel {
    private final ExplorerManager manager = new ExplorerManager();
    private LDAPConnectionDescriptor connectionDescriptor;
    private JTextField descriptionField;
    private final Set<ChangeListener> listeners = new HashSet<ChangeListener>(1);
    private JTextField nameField;
    private JLabel baseDNLabel;
    private String baseDN;
    private String newBaseDN;
    private JPanel component;
    private WizardDescriptor wizardDescriptor;
    private static boolean allowed = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator<ChangeListener> it;
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            it = new HashSet<ChangeListener>(this.listeners).iterator();
        }
        ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
            it.next().stateChanged(ev);
        }
    }

    public JComponent getComponent() {
        if (null == this.component) {
            DefaultFormBuilder dfb = new DefaultFormBuilder(new FormLayout("r:p,3dlu,f:p:g,3dlu,p,3dlu,p"), Messages.getBundle(), (JPanel)new MyPanel());
            int DEFAULT_COLSPAN = 5;
            this.manager.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    InitEnvironmentPanel.this.fireChangeEvent();
                }
            });
            DocumentListener documentForwarder = new DocumentListener(){

                public void changedUpdate(DocumentEvent e) {
                    InitEnvironmentPanel.this.updateComponentStates();
                    InitEnvironmentPanel.this.fireChangeEvent();
                }

                public void insertUpdate(DocumentEvent e) {
                    InitEnvironmentPanel.this.updateComponentStates();
                    InitEnvironmentPanel.this.fireChangeEvent();
                }

                public void removeUpdate(DocumentEvent e) {
                    InitEnvironmentPanel.this.updateComponentStates();
                    InitEnvironmentPanel.this.fireChangeEvent();
                }
            };
            dfb.appendI15dSeparator(Messages.getString("InitEnvironmentPanel.separator.baseDN"));
            dfb.nextLine();
            this.baseDNLabel = new JLabel();
            dfb.append((Component)this.baseDNLabel, dfb.getColumnCount() - 2);
            dfb.nextLine();
            dfb.appendI15dSeparator(Messages.getString("InitEnvironmentPanel.separator.settings"));
            dfb.nextLine();
            URL url = null;
            String urlSpec = System.getProperty("ThinClientManager.server.Codebase");
            if (null != urlSpec) {
                try {
                    url = new URL(urlSpec);
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
            String newFolderName = null != url ? url.getHost() : Messages.getString("NewRealmInit.new_folder.defaultName");
            this.nameField = new JTextField();
            this.nameField.setText(newFolderName);
            this.nameField.getDocument().addDocumentListener(documentForwarder);
            dfb.appendI15d(Messages.getString("NewRealmInit.new_folder_name"), (Component)this.nameField, 5);
            dfb.nextLine();
            this.descriptionField = new JTextField();
            dfb.appendI15d("NewRealmInit.description", (Component)this.descriptionField, 5);
            dfb.nextLine();
            this.descriptionField.getDocument().addDocumentListener(new DocumentListener(){

                public void changedUpdate(DocumentEvent e) {
                    InitEnvironmentPanel.this.updateComponentStates();
                    InitEnvironmentPanel.this.fireChangeEvent();
                }

                public void insertUpdate(DocumentEvent e) {
                    InitEnvironmentPanel.this.updateComponentStates();
                    InitEnvironmentPanel.this.fireChangeEvent();
                }

                public void removeUpdate(DocumentEvent e) {
                    InitEnvironmentPanel.this.updateComponentStates();
                    InitEnvironmentPanel.this.fireChangeEvent();
                }
            });
            this.updateComponentStates();
            this.component = dfb.getPanel();
            this.component.setName(Messages.getString("InitEnvironmentPanel.name"));
        }
        return this.component;
    }

    protected void updateComponentStates() {
        this.newBaseDN = "ou=" + this.nameField.getText();
        if (this.baseDN != null) {
            if (this.baseDN.equals("")) {
                this.baseDNLabel.setText(Messages.getString("InitEnvironmentPanel.baseDN", this.newBaseDN, this.connectionDescriptor.getBaseDN()));
            } else {
                this.baseDNLabel.setText(Messages.getString("InitEnvironmentPanel.baseDN.long", this.newBaseDN, this.baseDN, this.connectionDescriptor.getBaseDN()));
                this.newBaseDN = this.newBaseDN + "," + this.baseDN;
            }
        }
    }

    public HelpCtx getHelp() {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean isValid() {
        this.wizardDescriptor.putProperty("WizardPanel_errorMessage", null);
        return true;
    }

    public void readSettings(Object settings) {
        this.wizardDescriptor = (WizardDescriptor)settings;
        this.connectionDescriptor = (LDAPConnectionDescriptor)this.wizardDescriptor.getProperty("connectionDescriptor");
        this.baseDN = this.wizardDescriptor.getProperty("oldSelectedBaseDN").toString();
        this.updateComponentStates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    public void storeSettings(Object settings) {
        WizardDescriptor wd = (WizardDescriptor)settings;
        wd.putProperty("newFolderName", (Object)this.nameField.getText());
        wd.putProperty("treeSelection", (Object)this.manager.getSelectedNodes());
        wd.putProperty("selectedBaseDN", (Object)this.newBaseDN);
        wd.putProperty("description", (Object)this.descriptionField.getText());
        wd.putProperty("ConnectionDescriptor", (Object)this.connectionDescriptor);
    }

    public boolean isEnabled(WizardDescriptor wd) {
        if (null == wd) {
            return true;
        }
        Object tco = wd.getProperty("newFolderBox");
        return tco == null || (Boolean)tco != false;
    }

    private class MyPanel
    extends JPanel
    implements ExplorerManager.Provider {
        private MyPanel() {
        }

        public ExplorerManager getExplorerManager() {
            return InitEnvironmentPanel.this.manager;
        }
    }
}

