/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console.wizards.newdirobject;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.common.model.Profile;
import org.openthinclient.common.model.Realm;
import org.openthinclient.common.model.schema.Schema;
import org.openthinclient.common.model.schema.provider.SchemaLoadingException;
import org.openthinclient.console.Messages;
import org.openthinclient.console.ValidateNames;
import org.openthinclient.ldap.DirectoryException;

public class SelectSchemaPanel
extends JPanel
implements WizardDescriptor.Panel {
    private JTextField descriptionTextField;
    private final Set<ChangeListener> listeners = new HashSet<ChangeListener>(1);
    private JTextField nameField;
    private JComboBox typeComboBox;
    private String[] types;
    private WizardDescriptor wd;
    private Class dirObjectClass;
    private ArrayList<String> existingNames;
    private static HashMap<Schema, String> typeKeyBySchema = new HashMap();

    public SelectSchemaPanel() {
        this.setName(Messages.getString("NewDirObject.SelectSchemaPanel.name"));
        this.initComponents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator<ChangeListener> it;
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            it = new HashSet<ChangeListener>(this.listeners).iterator();
        }
        ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
            it.next().stateChanged(ev);
        }
    }

    public Component getComponent() {
        return this;
    }

    public HelpCtx getHelp() {
        return HelpCtx.DEFAULT_HELP;
    }

    private void initComponents() {
        DocumentListener dl = new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                SelectSchemaPanel.this.fireChangeEvent();
            }

            public void insertUpdate(DocumentEvent e) {
                SelectSchemaPanel.this.fireChangeEvent();
            }

            public void removeUpdate(DocumentEvent e) {
                SelectSchemaPanel.this.fireChangeEvent();
            }
        };
        DefaultFormBuilder dfb = new DefaultFormBuilder(new FormLayout("r:p,3dlu,f:p:g,3dlu,p,3dlu,p"), Messages.getBundle(), (JPanel)this);
        this.nameField = new JTextField();
        this.nameField.getDocument().addDocumentListener(dl);
        dfb.appendI15d("NewDirObject.SelectSchemaPanel.name_label", (Component)this.nameField);
        dfb.nextLine();
        this.descriptionTextField = new JTextField();
        this.descriptionTextField.getDocument().addDocumentListener(dl);
        dfb.appendI15d("NewDirObject.SelectSchemaPanel.description_label", (Component)this.descriptionTextField);
        dfb.nextLine();
        this.typeComboBox = new JComboBox();
        this.typeComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SelectSchemaPanel.this.fireChangeEvent();
            }
        });
        dfb.appendI15d("NewDirObject.SelectSchemaPanel.type_label", (Component)this.typeComboBox);
        dfb.nextLine();
    }

    public boolean isValid() {
        if (null == this.wd) {
            return false;
        }
        this.wd.putProperty("WizardPanel_errorMessage", null);
        if (this.nameField.getText().length() == 0) {
            this.wd.putProperty("WizardPanel_errorMessage", (Object)Messages.getString("NewDirObject.SelectSchemaPanel.name_error"));
            return false;
        }
        if (this.typeComboBox.getSelectedIndex() == -1) {
            this.wd.putProperty("WizardPanel_errorMessage", (Object)Messages.getString("NewDirObject.SelectSchemaPanel.type_error"));
            return false;
        }
        ValidateNames validate = new ValidateNames();
        String result = validate.validate(this.nameField.getText(), this.dirObjectClass);
        if (result != null) {
            this.wd.putProperty("WizardPanel_errorMessage", (Object)result);
            return false;
        }
        Realm realm = (Realm)this.wd.getProperty("realm");
        if (this.existingNames == null) {
            this.existingNames = new ArrayList();
            try {
                if (realm != null && realm.getDirectory() != null) {
                    Set existingObjects = realm.getDirectory().list(this.dirObjectClass);
                    for (DirectoryObject existingObject : existingObjects) {
                        this.existingNames.add(existingObject.getName());
                    }
                }
            }
            catch (DirectoryException e) {
                ErrorManager.getDefault().annotate((Throwable)e, Messages.getString("NewDirObject.SelectSchemaPanel.list_existing_failed_error"));
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
        if (this.existingNames.contains(this.nameField.getText())) {
            this.wd.putProperty("WizardPanel_errorMessage", (Object)Messages.getString("NewDirObject.SelectSchemaPanel.name_exists_error"));
            return false;
        }
        return true;
    }

    public void readSettings(Object settings) {
        this.wd = (WizardDescriptor)settings;
        this.dirObjectClass = (Class)this.wd.getProperty("type");
        Realm realm = (Realm)this.wd.getProperty("realm");
        this.existingNames = null;
        try {
            this.types = realm.getSchemaProvider().getSchemaNames(this.dirObjectClass);
            typeKeyBySchema.clear();
            for (String type : this.types) {
                Schema schema = realm.getSchemaProvider().getSchema(this.dirObjectClass, type).getSchema();
                if (null == schema) continue;
                typeKeyBySchema.put(realm.getSchemaProvider().getSchema(this.dirObjectClass, type).getSchema(), type);
            }
            Object[] schemas = typeKeyBySchema.keySet().toArray(new Schema[typeKeyBySchema.size()]);
            Arrays.sort(schemas);
            this.typeComboBox.setModel(new DefaultComboBoxModel<Object>(schemas));
        }
        catch (SchemaLoadingException e) {
            ErrorManager.getDefault().annotate((Throwable)e, 4096, Messages.getString("NewDirObject.schema_not_loaded_error"), null, null, null);
            ErrorManager.getDefault().notify((Throwable)e);
        }
        this.typeComboBox.setEnabled(Profile.class.isAssignableFrom(this.dirObjectClass));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    public void storeSettings(Object settings) {
        this.wd = (WizardDescriptor)settings;
        this.wd.putProperty("name", (Object)this.nameField.getText());
        this.wd.putProperty("description", (Object)this.descriptionTextField.getText());
        this.wd.putProperty("schemaType", (Object)typeKeyBySchema.get(this.typeComboBox.getSelectedItem()));
    }
}

