/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console.wizards.registerrealm;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.openide.ErrorManager;
import org.openide.nodes.Node;
import org.openthinclient.common.directory.LDAPDirectory;
import org.openthinclient.common.model.Realm;
import org.openthinclient.console.Messages;
import org.openthinclient.console.nodes.AbstractAsyncArrayChildren;
import org.openthinclient.console.nodes.DirectoryEntryNode;
import org.openthinclient.console.nodes.ErrorNode;
import org.openthinclient.console.nodes.RealmNode;
import org.openthinclient.ldap.LDAPConnectionDescriptor;

class RealmsInPartition
extends AbstractAsyncArrayChildren {
    private final String dn;

    public RealmsInPartition(String dn) {
        this.dn = dn;
    }

    protected Collection asyncInitChildren() {
        try {
            LDAPConnectionDescriptor lcd = new LDAPConnectionDescriptor(((DirectoryEntryNode)this.getNode()).getConnectionDescriptor());
            if (lcd == null) {
                return Collections.EMPTY_LIST;
            }
            lcd.setBaseDN(this.dn);
            Set realms = LDAPDirectory.listRealms((LDAPConnectionDescriptor)lcd);
            return realms;
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify((Throwable)e);
            this.add(new Node[]{new ErrorNode(Messages.getString("RealmsInPartition.cantDisplay"), e)});
            return Collections.EMPTY_LIST;
        }
    }

    protected Node[] createNodes(Object key) {
        if (key instanceof Node[]) {
            return (Node[])key;
        }
        return new Node[]{new RealmNode((Realm)key, true)};
    }
}

